/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cfile/RCS/display_cred.c,v $
 *
 *
 *  MODULE NAME:    display_cred.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <syslog.h>
#include "cdc.h"
#include "cdc_db.h"
#include "SPHINX-types.h"
#include "BigNum.h"
#include "BigRSA.h"
#include "random.h"
#include "spxapi_defs.h"

int display_claimant_cred (cred,debugflag)
ClaimantCred *cred;
int debugflag;
{
    char *env;
    int  time_now;

      printf("fullname   is '%s'\n", cred->fullname);
      if (cred->uidlen) {
        printf("uid        is ");
        hexdump(cred->uuid,cred->uidlen);
      }
      printf("session keySize is %d ; deleg_flag is %s\n",2*cred->bitlen, (cred->deleg_flag?"ON":"OFF"));
      if ((env = getenv("SPHINX_CLAIMANT_FILE")) != NULL)
	printf("credentials delegated in : %s\n", env);
      else printf("credentials created locally : %s\n", spx_tkt_string(cred->name, NULL));
      printf("\n");

      printf("  not valid before %s", ctime(&cred->before));
      printf("  not valid after  %s", ctime(&cred->after));
      if (debugflag) {
        if (cred->deleg_flag) {
          printf("delegation key is ");
          PrintPrivKey(cred->s_privRSAKey);
        }
      }
      time_now = time(0);
      if (cred->after < time_now) return(0);
      return(1);
}

int display_verifier_cred (cred,debugflag)
VerifierCred *cred;
int debugflag;
{
      printf("fullname   is '%s'\n", cred->fullname);
      if (cred->uidlen) {
        printf("uid        is ");
        hexdump (cred->uuid,cred->uidlen);
      }      
      printf("  not valid before %s", ctime(&cred->before));
      printf("  not valid after  %s", ctime(&cred->after));
      if (debugflag) {
        printf("private key is ");
        PrintPrivKey(cred->privRSAKey);
      }
      return(1);
}

int display_ta_cred (ta_cred,debugflag)
TrustedCred *ta_cred;
int debugflag;
{
      TrustedAuthority *ta;
      int i = 1, j;

      if (!ta_cred || ((j=ta_cred->count) == 0) || !(ta = ta_cred->head)) {
        printf("no TA credentials.\n");
        return(0);

      } else 
         printf("%d Trusted Authorit%s\n", j, ((j==1)?"y":"ies"));

      for (;ta;ta=ta->next,i++) {
	printf("\nTA #%d '%s'  %s", i, ta->fullname, ((ta->cross_certifier)?"[CROSS CERTIFIER]\n":"\n"));
	if (debugflag) {
	  if (ta->uidlen) {
	    printf("uid        is ");
	    hexdump( ta->uuid, ta->uidlen );
	  }
	  printf("key        is :");
	  PrintPubKey (ta->pubRSAKey);
        }
      }
      return(1);
}
