/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/verify_certif_aux.c,v $
 *
 *
 *  MODULE NAME:    verify_certif_aux.c
 *
 *
 *  AUTHORS:
 *
 *      J. Tardo
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "SPHINX-types.h"
#include "BigNum.h"
#include "BigRSA.h"

/*  Define for more verbose debugging.
#define DEBUG2
*
*    return  1    verification success
*    return  0    verification failure, invalid signature
*    return -1    verification failure, certificate expired
*/

struct type_SPHINX_Certificate *encode_SPHINX_CertifInfo();

int verify_certif_aux(certif, key)
struct type_SPHINX_Certificate *certif;
RSAKeyStorage *key ;
{
  int status = rsamd2_verify_aux ((struct type_Sign_SignedData *) certif,
			      encode_SPHINX_CertifInfo, key);

  if(status == 0) {
#ifdef DEBUG
	  printf("%s: Error verifying certificate.\n", __FILE__);
#endif
  }
  if (status)
    if (validate_expired(certif->cinfo->valid, 0) != 0) status = -1;
  return(status);
}

