/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/alg_id.c,v $
 *
 *
 *  MODULE NAME:    alg_id.c
 *
 *
 *  AUTHORS:
 *
 *      J. Tardo
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "SPHINX-types.h"
#include "sign_aux.h"

#include "objid.h"

#ifdef DEBUG
#undef DEBUG
#endif

struct type_SPHINX_AlgorithmIdentifier *create_alg_id (oid,keysize)
char *oid;
int *keysize;
{
    struct type_SPHINX_AlgorithmIdentifier *x_alg;

    x_alg = (struct type_SPHINX_AlgorithmIdentifier *)
		malloc(sizeof (struct type_SPHINX_AlgorithmIdentifier));
    if (x_alg == NULL) { 
#ifdef DEBUG
printf("%s: Error allocating algorithm identifier.\n", __FILE__);
fflush(stdout);
#endif
        return(NULL);
    }
    x_alg->algorithm = oid_cpy(str2oid(oid));

    if((strcmp(oid,DEC_DEA_MAC_OID)==0)||(strcmp(oid,DEC_DEA_OID)==0)) {
        x_alg->parameter = NULL;
        return(x_alg);
    }

    x_alg->parameter = (struct choice_SPHINX_0 *) malloc(sizeof(struct choice_SPHINX_0));

    if(keysize){
        x_alg->parameter->offset = choice_SPHINX_0_keySize;
        x_alg->parameter->un.keySize = *keysize;
    }
    else {
        x_alg->parameter->offset = choice_SPHINX_0_null;
        x_alg->parameter->un.null = 0;
    }

    return(x_alg);
}

