#| -*-Scheme-*-

Copyright (C) 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994,
    1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
    2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016,
    2017, 2018, 2019, 2020, 2021, 2022 Massachusetts Institute of
    Technology

This file is part of MIT/GNU Scheme.

MIT/GNU Scheme is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

MIT/GNU Scheme is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with MIT/GNU Scheme; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,
USA.

|#

;;;; UCD property: WB+EP (word-break+ext-pict)

;;; Generated from Unicode 13.0.0

(declare (usual-integrations))

(define (ucd-wb+ep-value char)
  (let ((sv (char->integer char)))
    (vector-ref |ucd-WB+EP-table-5| (bytevector-u8-ref |ucd-WB+EP-table-4| (fix:or (fix:lsh (bytevector-u16be-ref |ucd-WB+EP-table-3| (fix:lsh (fix:or (fix:lsh (bytevector-u8-ref |ucd-WB+EP-table-2| (fix:or (fix:lsh (bytevector-u8-ref |ucd-WB+EP-table-1| (fix:or (fix:lsh (bytevector-u8-ref |ucd-WB+EP-table-0| (fix:lsh sv -16)) 4) (fix:and 15 (fix:lsh sv -12)))) 4) (fix:and 15 (fix:lsh sv -8)))) 4) (fix:and 15 (fix:lsh sv -4))) 1)) 4) (fix:and 15 sv))))))

(define |ucd-WB+EP-table-0|
  '#u8(0 1 2 2 2 2 2 2 2 2 2 2 2 2 3 2 2))

(define |ucd-WB+EP-table-1|
  '#u8(0 1 2 3 4 4 4 4 4 4 5 6 6 7 4 8 9 10 11 12 13 4 14 4 4 4 4 15 4 16 17 18 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 19 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4))

(define |ucd-WB+EP-table-2|
  '#u8(0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 1 17 18 19 1 20 21 22 23 24 25 26 27 1 28 29 30 31 32 33 34 35 36 31 37 31 38 39 40 41 31 42 43 44 45 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 1 1 1 1 46 1 47 48 49 50 51 52 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 53 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 54 1 55 56 57 58 59 60 61 62 63 1 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 31 84 85 86 87 1 1 1 88 89 90 31 31 31 31 31 31 31 31 31 31 1 1 1 1 91 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 1 1 92 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 1 1 93 94 31 31 95 96 97 98 31 31 31 31 31 31 31 31 31 31 99 31 31 31 31 100 101 31 102 103 104 105 31 31 106 31 31 31 31 31 107 108 109 31 31 31 31 31 110 111 31 31 31 31 112 31 113 114 115 116 113 117 118 119 120 121 113 122 113 113 113 123 124 125 31 31 31 31 31 31 31 31 31 31 31 31 31 31))

(define |ucd-WB+EP-table-3|
  '#u8(0 0 0 1 0 2 0 3 0 4 0 5 0 4 0 6 0 7 0 1 0 8 0 9 0 10 0 11 0 10 0 11 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 12 0 10 0 10 0 13 0 13 0 13 0 13 0 13 0 13 0 13 0 14 0 15 0 10 0 16 0 10 0 10 0 10 0 10 0 17 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 18 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 4 0 10 0 19 0 10 0 10 0 20 0 21 0 13 0 22 0 23 0 24 0 25 0 26 0 27 0 28 0 10 0 10 0 29 0 13 0 30 0 31 0 10 0 10 0 10 0 10 0 10 0 32 0 33 0 34 0 35 0 36 0 10 0 13 0 37 0 10 0 10 0 10 0 10 0 10 0 38 0 39 0 40 0 10 0 29 0 41 0 10 0 42 0 43 0 1 0 10 0 44 0 6 0 1 0 1 0 1 0 10 0 45 0 46 0 47 0 48 0 13 0 49 0 10 0 10 0 50 0 13 0 51 0 52 0 4 0 53 0 54 0 55 0 56 0 57 0 58 0 52 0 59 0 60 0 54 0 55 0 61 0 62 0 63 0 64 0 65 0 66 0 16 0 55 0 67 0 68 0 69 0 52 0 70 0 71 0 54 0 55 0 67 0 72 0 73 0 52 0 74 0 75 0 76 0 77 0 78 0 79 0 80 0 64 0 1 0 81 0 82 0 55 0 83 0 84 0 85 0 52 0 1 0 86 0 82 0 55 0 87 0 84 0 88 0 52 0 89 0 90 0 82 0 10 0 91 0 92 0 93 0 52 0 94 0 95 0 96 0 10 0 97 0 98 0 99 0 64 0 100 0 1 0 1 0 1 0 101 0 102 0 103 0 1 0 1 0 1 0 1 0 1 0 104 0 105 0 103 0 1 0 1 0 69 0 106 0 103 0 107 0 108 0 10 0 109 0 21 0 110 0 111 0 13 0 112 0 113 0 1 0 1 0 1 0 1 0 1 0 114 0 115 0 103 0 116 0 117 0 118 0 119 0 120 0 10 0 10 0 121 0 10 0 10 0 122 0 10 0 10 0 10 0 10 0 123 0 124 0 10 0 10 0 123 0 10 0 10 0 125 0 126 0 11 0 10 0 10 0 10 0 126 0 10 0 10 0 10 0 127 0 1 0 1 0 10 0 1 0 10 0 10 0 10 0 10 0 10 0 128 0 4 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 129 0 10 0 130 0 6 0 10 0 10 0 10 0 10 0 131 0 132 0 133 0 134 0 10 0 134 0 10 0 135 0 133 0 136 0 1 0 1 0 1 0 137 0 13 0 138 0 103 0 1 0 139 0 103 0 10 0 10 0 10 0 10 0 10 0 132 0 140 0 10 0 141 0 10 0 10 0 10 0 10 0 142 0 10 0 143 0 144 0 144 0 64 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 103 0 1 0 1 0 10 0 145 0 1 0 1 0 1 0 146 0 13 0 147 0 103 0 103 0 1 0 13 0 148 0 1 0 1 0 1 0 149 0 10 0 10 0 150 0 151 0 103 0 114 0 152 0 153 0 10 0 154 0 40 0 10 0 10 0 38 0 152 0 10 0 10 0 150 0 155 0 156 0 40 0 10 0 157 0 132 0 10 0 10 0 158 0 1 0 159 0 160 0 161 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 13 0 13 0 13 0 162 0 10 0 128 0 10 0 10 0 128 0 163 0 10 0 157 0 10 0 10 0 10 0 164 0 165 0 166 0 109 0 165 0 167 0 168 0 169 0 170 0 171 0 172 0 173 0 174 0 1 0 109 0 1 0 1 0 1 0 13 0 13 0 148 0 175 0 176 0 177 0 178 0 179 0 1 0 10 0 10 0 132 0 180 0 181 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 182 0 183 0 1 0 1 0 1 0 1 0 1 0 183 0 1 0 1 0 1 0 184 0 1 0 185 0 186 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 187 0 188 0 10 0 189 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 182 0 190 0 191 0 1 0 1 0 192 0 193 0 194 0 195 0 195 0 195 0 195 0 195 0 195 0 196 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 197 0 198 0 199 0 200 0 201 0 202 0 203 0 1 0 1 0 204 0 205 0 206 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 207 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 204 0 208 0 1 0 1 0 1 0 209 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 143 0 10 0 10 0 143 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 210 0 211 0 10 0 10 0 121 0 10 0 10 0 10 0 212 0 213 0 10 0 214 0 215 0 215 0 215 0 215 0 13 0 13 0 1 0 1 0 216 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 217 0 1 0 218 0 219 0 1 0 1 0 1 0 1 0 1 0 220 0 221 0 221 0 221 0 221 0 221 0 222 0 223 0 10 0 10 0 4 0 10 0 10 0 10 0 10 0 143 0 1 0 10 0 10 0 1 0 1 0 1 0 221 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 224 0 1 0 1 0 1 0 221 0 221 0 225 0 221 0 221 0 221 0 221 0 221 0 226 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 109 0 1 0 1 0 1 0 1 0 10 0 10 0 157 0 109 0 10 0 227 0 1 0 10 0 10 0 228 0 229 0 10 0 230 0 10 0 10 0 10 0 10 0 10 0 231 0 232 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 233 0 1 0 1 0 223 0 234 0 10 0 235 0 1 0 10 0 10 0 10 0 236 0 237 0 10 0 10 0 150 0 238 0 103 0 13 0 239 0 40 0 10 0 240 0 10 0 241 0 152 0 10 0 109 0 49 0 10 0 10 0 242 0 243 0 103 0 244 0 103 0 10 0 10 0 245 0 246 0 247 0 103 0 1 0 248 0 1 0 1 0 1 0 249 0 250 0 1 0 29 0 251 0 252 0 253 0 215 0 10 0 10 0 10 0 189 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 254 0 103 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 236 0 10 0 255 0 10 0 10 1 0 0 214 1 1 1 2 1 3 1 4 0 10 0 10 0 10 0 10 0 10 0 10 1 5 0 1 1 6 0 10 0 10 0 10 0 10 0 10 0 157 0 1 0 10 0 10 0 10 0 10 1 7 0 10 0 10 0 46 0 1 0 1 1 0 0 13 1 8 0 13 1 9 1 10 1 11 0 1 0 45 0 10 0 10 0 10 0 10 0 10 0 10 0 10 1 12 1 13 0 3 0 4 0 5 0 4 0 6 1 14 0 221 0 221 1 15 0 10 0 143 1 16 1 17 0 1 1 18 1 19 0 10 0 11 1 20 0 157 0 157 0 1 0 1 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 6 0 1 0 1 0 1 0 1 0 10 0 10 0 10 1 21 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 22 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 109 0 10 0 10 0 10 0 69 0 148 0 1 0 10 0 10 1 23 0 10 0 6 0 10 0 10 1 24 0 10 0 157 0 10 0 10 1 25 1 26 0 1 0 1 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 157 0 103 0 10 0 10 1 25 0 10 1 0 0 10 0 10 0 46 0 10 0 10 0 10 0 236 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 10 0 214 0 10 0 142 0 46 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 27 0 10 0 10 1 28 0 10 0 142 0 10 0 214 0 10 0 143 0 1 0 1 0 1 0 1 0 10 1 29 0 10 0 142 0 10 0 189 0 1 0 1 0 1 0 1 0 10 0 10 0 10 0 12 0 1 0 1 0 1 0 1 1 30 1 31 0 10 1 32 0 1 0 1 0 10 0 109 0 10 0 109 0 1 0 1 0 108 0 10 1 33 0 1 0 10 0 10 0 10 0 142 0 10 0 142 0 10 1 34 0 10 1 5 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 10 0 10 0 132 0 1 0 1 0 1 0 10 0 10 0 10 1 34 0 10 0 10 0 10 1 34 0 10 0 10 1 35 0 103 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 1 36 1 5 0 1 0 1 0 1 0 1 0 10 0 109 1 37 0 10 0 38 0 148 0 1 0 1 0 1 0 1 0 1 0 10 1 21 0 1 0 10 0 214 0 153 0 10 0 10 1 38 0 246 0 1 0 64 0 213 0 153 0 10 0 10 1 39 1 40 0 10 0 132 0 103 0 153 0 10 0 241 1 41 1 42 0 10 0 10 1 43 0 153 0 10 0 10 0 242 1 44 1 45 0 1 0 1 0 10 0 16 1 46 1 47 0 1 0 1 0 1 0 1 1 48 1 49 0 132 0 10 0 10 0 228 1 50 0 103 1 51 0 54 0 55 1 52 0 72 1 53 1 54 1 55 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 10 1 56 1 57 1 58 1 5 0 1 0 10 0 10 0 10 0 13 1 59 0 103 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 228 1 60 0 148 1 61 0 1 0 1 0 10 0 10 0 10 0 13 1 62 0 103 0 1 0 1 0 10 0 10 0 29 1 63 0 103 0 1 0 1 0 1 0 1 1 64 0 144 0 103 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 1 46 1 50 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 10 0 10 0 103 0 216 1 65 1 66 0 10 1 67 1 68 0 103 0 1 0 1 0 1 0 1 1 69 0 10 0 10 1 70 1 71 0 1 1 72 0 10 0 10 1 73 1 74 1 75 0 10 0 10 1 76 1 77 0 1 0 1 0 10 0 10 0 10 0 132 0 55 0 10 0 228 1 78 0 69 0 103 0 1 1 7 0 10 1 79 0 111 0 246 0 1 0 1 0 1 0 1 1 80 0 10 0 10 1 81 1 82 0 103 1 83 0 10 1 84 1 85 0 103 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 1 86 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 69 0 1 0 1 0 1 0 1 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 189 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 10 0 10 0 10 0 10 0 143 0 1 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 236 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 143 1 87 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 10 0 10 0 214 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 10 0 132 0 10 0 143 0 103 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 157 1 55 0 10 0 10 0 10 0 246 0 236 0 103 1 6 1 88 0 10 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 10 0 10 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 10 0 10 1 89 1 90 0 13 0 13 1 91 0 153 0 1 0 1 0 1 0 1 1 92 0 231 1 93 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 94 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 10 0 10 0 10 0 10 0 6 0 109 0 132 1 95 1 96 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 97 1 98 1 99 0 1 1 100 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 101 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 10 0 10 0 10 0 45 0 10 0 10 0 10 0 133 1 102 1 103 1 104 0 10 0 10 0 10 1 105 1 106 0 10 1 107 1 108 0 82 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 1 109 0 10 0 82 0 122 0 10 0 122 0 10 0 45 0 10 0 45 0 143 0 10 0 143 0 10 0 55 0 10 0 55 0 10 1 110 1 111 1 111 1 111 0 13 0 13 0 13 1 112 0 13 0 13 0 112 0 244 1 113 0 114 0 21 0 1 0 1 0 1 0 1 0 1 1 78 1 114 1 115 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 0 109 1 116 1 117 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 10 0 10 1 46 0 103 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 0 10 1 21 0 246 0 1 0 1 0 10 0 10 0 10 0 10 1 118 0 103 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 104 0 10 1 119 1 120 1 121 1 122 1 123 1 124 1 125 1 0 1 126 1 0 0 1 0 1 0 1 0 1 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 1 127 0 1 0 184 0 10 0 189 0 10 1 128 1 129 1 130 1 131 1 127 0 195 0 195 0 195 1 132 1 133 1 134 1 135 0 184 1 136 0 185 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 1 137 0 195 0 195 0 195 1 138 1 139 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 1 0 1 0 1 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 140 0 1 0 1 0 1 0 1 0 1 1 141 0 195 0 195 1 142 0 1 0 1 0 1 1 143 1 144 0 1 0 1 1 143 0 1 1 145 0 195 0 195 0 195 0 195 0 195 1 142 0 195 0 195 1 146 0 193 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 103 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 0 195 1 138 1 147 0 1 0 13 0 13 0 13 0 13 0 13 0 13 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 13 0 13 0 13 0 13 0 13 0 13 0 13 0 13 0 13 0 13 0 13 0 13 0 13 0 13 0 13 0 1))

(define |ucd-WB+EP-table-4|
  '#u8(0 0 0 0 0 0 0 0 0 0 1 2 2 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 0 5 0 0 0 0 6 0 0 0 0 7 0 8 0 9 9 9 9 9 9 9 9 9 9 10 7 0 0 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 0 0 12 11 11 11 11 11 11 11 11 11 11 11 0 0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 11 0 0 14 13 0 0 0 0 0 0 11 0 10 0 0 11 0 0 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 0 0 0 0 11 11 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 11 11 11 11 11 0 11 11 0 0 11 11 11 11 7 11 0 0 0 0 0 0 11 10 11 11 11 0 11 0 11 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 0 15 15 15 15 15 15 15 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 11 11 11 11 0 11 10 11 11 11 11 11 11 11 11 11 7 11 0 0 0 0 0 0 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 0 15 0 15 15 0 15 15 0 15 0 0 0 0 0 0 0 0 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 0 0 0 0 16 16 16 16 11 10 0 0 0 0 0 0 0 0 0 0 0 14 14 14 14 14 14 0 0 0 0 0 0 7 7 0 0 15 15 15 15 15 15 15 15 15 15 15 0 14 0 0 0 11 11 11 11 11 11 11 11 11 11 11 15 15 15 15 15 9 9 9 9 9 9 9 9 9 9 0 9 7 0 11 11 15 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 11 15 15 15 15 15 15 15 14 0 15 15 15 15 15 15 11 11 15 15 0 15 15 15 15 11 11 9 9 9 9 9 9 9 9 9 9 11 11 11 0 0 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14 11 15 11 11 11 11 11 11 11 11 11 11 11 11 11 11 15 15 15 15 15 15 15 15 15 15 15 0 0 11 11 11 11 11 11 11 11 11 15 15 15 15 15 15 15 15 15 15 15 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 9 9 9 9 9 9 9 9 9 9 11 11 11 11 11 11 15 15 15 15 11 11 0 0 7 0 11 0 0 15 0 0 11 11 11 11 11 11 15 15 15 15 11 15 15 15 15 15 15 15 15 15 11 15 15 15 11 15 15 15 15 15 0 0 11 11 11 11 11 11 11 11 11 15 15 15 0 0 0 0 11 11 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 14 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 15 15 15 11 15 15 11 15 15 15 15 15 15 15 11 11 11 11 11 11 11 11 11 11 15 15 0 0 9 9 9 9 9 9 9 9 9 9 11 15 15 15 0 11 11 11 11 11 11 11 11 0 0 11 11 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 11 11 11 11 11 11 11 0 11 0 0 0 11 11 11 11 0 0 15 11 15 15 15 15 15 15 15 0 0 15 15 0 0 15 15 15 11 0 0 0 0 0 0 0 0 15 0 0 0 0 11 11 0 11 11 11 0 0 0 0 0 0 0 0 0 0 11 0 15 0 0 15 15 15 0 11 11 11 11 11 11 0 0 0 0 11 11 0 11 11 0 11 11 0 11 11 0 0 15 0 15 15 15 15 15 0 0 0 0 15 15 0 0 15 15 15 0 0 0 15 0 0 0 0 0 0 0 11 11 11 11 0 11 0 0 0 0 0 0 0 9 9 9 9 9 9 9 9 9 9 15 15 11 11 11 15 0 0 0 0 0 0 0 0 0 0 0 15 15 15 0 11 11 11 11 11 11 11 11 11 0 11 11 0 11 11 0 11 11 11 11 11 0 0 15 11 15 15 15 15 15 15 15 15 0 15 15 15 0 15 15 15 0 0 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 11 15 15 15 15 15 15 0 15 15 15 0 11 11 11 11 11 11 11 11 0 0 11 15 15 15 15 15 0 0 15 15 0 0 15 15 15 0 0 0 0 0 0 0 15 15 15 0 0 0 0 11 11 0 11 0 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 11 0 11 11 11 11 11 11 0 0 0 11 11 11 0 11 11 11 11 0 0 0 11 11 0 11 0 11 11 0 0 0 11 11 0 0 0 11 11 11 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 0 0 0 0 15 15 15 15 15 0 0 0 15 15 15 0 15 15 15 15 0 0 11 0 0 0 0 0 0 15 0 0 0 0 0 0 0 0 15 15 15 15 15 11 11 11 11 11 11 11 11 0 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 0 11 15 15 15 15 15 15 15 0 15 15 15 0 15 15 15 15 0 0 0 0 0 0 0 15 15 0 11 11 11 0 0 0 0 0 11 15 15 15 0 11 11 11 11 11 11 11 11 0 11 11 11 11 11 11 0 11 11 11 11 11 0 0 15 11 15 15 0 0 0 0 0 15 15 0 0 0 0 0 0 0 11 0 0 11 11 0 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 11 11 11 11 11 11 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 11 15 15 11 15 15 15 15 15 15 15 0 15 15 15 0 15 15 15 15 11 0 0 0 0 0 11 11 11 15 0 0 0 0 0 0 0 11 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 11 0 15 15 15 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 0 11 11 11 11 11 11 11 11 0 11 11 11 11 11 11 11 11 11 0 11 0 0 11 11 11 11 11 11 11 0 0 0 15 0 0 0 0 15 15 15 15 15 15 0 15 0 15 15 15 15 15 15 15 15 0 0 15 15 0 0 0 0 0 0 0 0 0 0 0 0 0 15 0 0 15 15 15 15 15 15 15 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 15 15 15 15 0 9 9 9 9 9 9 9 9 9 9 0 0 0 0 0 0 0 15 0 0 15 15 15 15 15 15 15 15 15 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 15 15 0 0 0 0 0 0 0 0 0 0 15 15 0 0 0 0 0 0 0 0 0 0 0 15 0 15 0 15 0 0 0 0 15 15 11 11 11 11 11 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 0 15 15 15 15 15 0 15 15 11 11 11 11 11 15 15 15 15 15 15 15 15 15 15 15 0 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 0 0 0 0 0 0 0 0 0 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 0 0 0 0 0 0 0 15 15 15 15 0 0 0 0 15 15 15 0 15 15 15 0 0 15 15 15 15 15 15 15 0 0 0 15 15 15 15 0 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 15 15 15 15 15 15 15 15 0 15 9 9 9 9 9 9 9 9 9 9 15 15 15 15 0 0 11 11 11 11 11 11 0 11 0 0 0 0 0 11 0 0 11 11 11 11 11 11 11 11 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 11 0 11 11 11 11 0 0 11 11 11 11 11 11 11 0 11 0 11 11 11 11 0 0 11 0 11 11 11 11 0 0 11 11 11 11 11 11 11 0 11 0 11 11 11 11 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 15 15 15 11 11 11 11 11 11 0 0 11 11 11 11 11 11 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 11 4 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 0 11 11 11 11 11 11 11 11 11 11 11 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 0 11 11 11 11 15 15 15 0 0 0 0 0 0 0 0 0 0 0 11 11 15 15 0 0 0 0 0 0 0 0 0 0 0 0 11 0 15 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 0 0 0 0 0 0 0 0 0 15 0 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 14 0 11 11 11 11 11 15 15 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 15 11 0 0 0 0 0 11 11 11 11 11 11 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 15 15 15 15 15 15 15 15 15 15 15 15 0 0 0 0 11 11 11 11 11 11 11 15 15 15 15 15 0 0 0 0 0 0 0 0 0 15 15 15 15 15 15 15 15 15 15 0 15 15 15 15 15 15 15 15 15 15 15 15 15 0 0 15 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 15 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 11 11 11 11 11 11 11 0 0 0 0 15 15 15 15 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 11 11 11 11 11 11 11 11 11 11 11 11 11 11 15 15 15 15 15 15 15 15 15 15 15 15 15 11 11 15 15 15 15 15 15 15 15 0 0 0 0 0 0 0 0 9 9 9 9 9 9 9 9 9 9 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 11 11 11 11 11 11 11 11 11 11 11 0 0 11 11 11 15 15 15 0 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 11 11 11 11 15 11 11 11 11 11 11 15 11 11 15 15 15 11 0 0 0 0 0 15 15 15 15 15 15 15 15 15 15 0 15 15 15 15 15 11 11 11 11 11 11 11 11 0 11 0 11 0 11 0 11 11 11 11 11 11 0 11 11 11 11 11 11 11 0 11 0 0 0 11 11 11 0 11 11 11 11 11 11 11 0 0 0 11 11 11 11 0 0 11 11 11 11 11 11 0 0 0 0 4 4 4 4 4 4 4 0 4 4 4 0 15 17 14 14 0 0 0 0 0 0 0 0 8 8 0 0 0 0 0 0 0 0 0 0 8 0 0 10 2 2 14 14 14 14 14 12 0 0 0 0 0 0 0 0 0 0 0 0 13 0 0 12 12 0 0 0 7 0 0 0 0 13 0 0 0 0 0 0 0 0 0 0 12 0 0 0 0 0 0 0 0 0 0 4 14 14 14 14 14 0 14 14 14 14 14 14 14 14 14 14 0 11 0 0 0 0 0 0 0 0 0 0 0 0 0 11 0 0 11 0 0 0 0 11 0 0 11 11 11 11 11 11 11 11 11 11 0 11 0 0 0 11 11 11 11 11 0 0 0 0 13 0 11 0 11 0 11 0 11 11 11 11 0 11 11 11 11 11 11 11 11 11 11 18 0 0 11 11 11 11 0 0 0 0 0 11 11 11 11 11 0 0 0 0 11 0 0 0 0 0 13 13 13 13 13 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 13 0 0 0 0 0 0 0 0 0 0 0 0 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 0 0 0 0 0 0 0 0 0 13 13 13 13 13 13 13 13 13 13 13 0 0 0 0 13 13 13 0 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 18 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 0 0 0 0 0 0 0 0 0 0 13 0 0 0 0 0 0 0 0 0 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 13 13 13 0 13 13 13 13 13 13 0 13 13 13 13 13 13 13 13 13 13 13 13 0 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 0 0 0 0 0 0 0 0 0 0 13 13 13 13 13 13 0 0 13 13 13 13 13 13 13 13 13 13 13 0 13 0 13 0 0 0 0 0 0 13 0 0 0 13 0 0 0 0 0 0 13 0 0 0 0 0 0 0 0 0 0 13 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 0 0 13 0 0 0 0 13 0 13 0 0 0 0 13 13 13 0 13 0 0 0 0 0 0 0 0 0 0 0 13 13 13 13 13 0 0 0 0 0 0 0 0 0 0 0 0 0 13 13 13 0 0 0 0 0 0 0 0 0 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 0 0 0 0 13 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 13 0 0 0 13 0 0 0 0 13 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 0 0 0 0 0 0 11 11 11 11 15 15 15 11 11 0 0 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 0 0 0 0 0 0 0 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 11 11 11 11 11 11 11 0 0 0 0 0 0 0 0 0 11 11 11 11 11 11 11 0 11 11 11 11 11 11 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 11 4 0 0 0 0 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 15 15 13 19 19 19 19 19 0 0 0 0 0 11 11 13 0 0 0 0 0 0 0 0 0 0 0 15 15 19 19 0 0 0 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 0 19 19 19 19 0 0 0 0 0 11 11 11 11 11 11 11 11 11 11 11 0 0 0 0 0 0 0 13 0 13 0 0 0 0 0 0 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 0 19 19 19 19 19 19 19 19 0 0 0 0 0 0 0 0 9 9 9 9 9 9 9 9 9 9 11 11 0 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 15 15 15 15 0 15 15 15 15 15 15 15 15 15 15 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 15 15 15 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 0 0 11 11 11 11 11 11 11 11 11 0 0 0 0 0 11 11 15 11 11 11 15 11 11 11 11 15 11 11 11 11 11 11 11 15 15 15 15 15 0 0 0 0 15 0 0 0 11 11 11 11 0 0 0 0 0 0 0 0 0 0 0 0 15 15 11 11 11 11 11 11 11 11 11 11 11 11 11 11 15 15 15 15 15 15 0 0 0 0 0 0 0 0 0 0 15 15 11 11 11 11 11 11 0 0 0 11 0 11 11 15 11 11 11 11 11 11 15 15 15 15 15 15 15 15 0 0 11 11 11 11 11 11 11 15 15 15 15 15 15 15 15 15 11 11 11 15 15 15 15 15 15 15 15 15 15 15 15 15 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 11 0 0 0 0 0 15 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 11 15 15 15 15 15 15 15 15 15 15 15 15 15 15 0 0 0 0 0 0 0 0 0 11 11 11 15 11 11 11 11 11 11 11 11 15 15 0 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 0 0 15 0 15 15 15 0 0 15 15 0 0 0 0 0 15 15 0 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 11 11 11 15 15 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 11 0 0 11 11 11 11 11 11 0 0 11 11 11 11 11 11 0 0 0 0 0 0 0 0 0 11 11 11 15 15 15 15 15 15 15 15 0 15 15 0 0 11 11 11 11 11 11 11 0 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 0 0 0 0 0 11 11 11 11 11 0 0 0 0 0 16 15 16 16 16 16 16 16 16 16 16 16 0 16 16 16 16 16 16 16 16 16 16 16 16 16 0 16 16 16 16 16 0 16 0 16 16 0 16 16 0 16 16 16 16 16 16 16 16 16 16 11 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 7 0 0 10 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 12 12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 12 12 12 7 0 8 0 7 10 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 14 0 0 0 0 0 0 0 8 0 0 0 0 7 0 8 0 0 0 0 0 0 0 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 15 15 0 0 11 11 11 11 11 11 0 0 11 11 11 11 11 11 0 0 11 11 11 11 11 11 0 0 11 11 11 0 0 0 0 0 0 0 0 0 0 0 0 14 14 14 0 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 11 11 0 11 11 11 11 11 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 11 15 15 15 15 15 0 0 0 0 0 11 11 11 11 0 0 0 0 11 11 11 11 11 11 11 11 0 11 11 11 11 11 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 11 0 0 11 0 11 11 11 11 11 11 11 11 11 11 11 11 0 11 11 0 0 0 11 0 0 11 11 11 11 0 11 11 0 0 0 0 0 0 0 0 0 0 11 15 15 15 0 15 15 0 0 0 0 0 15 15 15 15 11 11 11 11 0 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 15 15 15 0 0 0 0 15 11 11 11 11 11 15 15 0 0 0 0 0 0 0 0 0 11 11 11 0 0 0 0 0 0 0 0 0 0 0 0 0 11 11 11 11 15 15 15 15 0 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 11 11 0 15 15 0 0 0 0 0 0 0 0 0 0 11 0 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 0 0 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14 0 0 15 15 15 15 15 0 9 9 9 9 9 9 9 9 9 9 0 0 0 0 11 15 15 11 0 0 0 0 0 0 0 0 11 11 11 15 0 0 11 0 0 0 0 0 0 0 0 0 15 11 11 11 11 0 0 0 0 15 15 15 15 0 15 15 9 9 9 9 9 9 9 9 9 9 11 0 11 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 15 15 15 15 15 15 15 15 15 15 15 15 0 0 0 0 0 0 15 0 11 11 11 11 11 11 11 0 11 0 11 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 11 15 15 15 15 15 15 15 15 15 15 15 0 0 0 0 0 15 15 15 15 0 11 11 11 11 11 11 11 11 0 0 11 11 0 11 11 0 11 11 11 11 11 0 15 15 11 15 15 11 0 0 0 0 0 0 15 0 0 0 0 0 11 11 11 11 11 15 15 0 0 15 15 15 15 15 15 15 0 0 0 15 15 15 15 15 0 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 11 11 11 11 0 0 0 0 0 9 9 9 9 9 9 9 9 9 9 0 0 0 0 15 11 15 15 15 15 11 11 0 11 0 0 0 0 0 0 0 0 15 15 15 15 15 15 0 0 15 15 15 15 15 15 15 15 0 0 0 0 0 0 0 0 11 11 11 11 15 15 0 0 15 0 0 0 11 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 15 15 15 15 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 11 11 11 11 11 11 11 0 0 11 0 0 11 11 11 11 11 11 11 11 0 11 11 0 11 11 11 11 11 11 11 11 15 15 15 15 15 15 0 15 15 0 0 15 15 15 15 11 15 11 15 15 0 0 0 0 0 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 0 0 11 11 11 11 11 11 11 15 15 15 15 15 15 15 0 0 15 15 15 15 15 15 15 11 0 11 15 0 0 0 0 0 0 0 0 0 0 0 11 15 15 15 15 15 15 15 15 15 15 11 11 11 11 11 11 11 11 15 15 15 15 15 15 15 11 15 15 15 15 0 0 0 0 0 0 0 0 15 0 0 0 0 0 0 0 0 11 15 15 15 15 15 15 15 15 15 15 15 11 11 11 11 11 11 11 11 11 11 11 11 11 11 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 0 0 0 11 0 0 15 15 15 15 15 15 15 0 15 15 15 15 15 15 15 15 0 0 15 15 15 15 15 15 15 15 15 15 15 15 15 15 11 11 11 11 11 11 11 0 11 11 0 11 11 11 11 11 11 15 15 15 15 15 15 0 0 0 15 0 15 15 0 15 15 15 15 15 15 15 11 15 0 0 0 0 0 0 0 0 11 11 11 11 11 11 0 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 15 15 15 15 15 0 15 15 0 15 15 15 15 15 11 0 0 0 0 0 0 0 11 11 11 15 15 15 15 0 0 0 0 0 0 0 0 0 14 14 14 14 14 14 14 14 14 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 0 0 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 0 0 0 15 11 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 0 0 0 0 0 0 0 15 11 11 0 11 15 0 0 0 0 0 0 0 0 0 0 0 19 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 19 19 19 19 0 0 0 0 0 0 0 0 11 11 11 11 11 11 11 11 11 11 0 0 0 15 15 0 14 14 14 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 15 0 0 0 15 15 15 15 15 15 14 14 14 14 14 14 14 14 15 15 15 15 15 15 15 15 0 0 15 15 15 15 15 15 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 0 0 0 0 15 15 15 0 0 0 0 0 0 0 0 0 0 0 0 0 11 0 0 11 11 0 0 11 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 0 11 0 11 11 11 11 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 0 11 11 11 11 0 0 11 11 11 11 11 11 11 11 0 11 11 11 11 11 11 11 0 11 11 11 11 11 11 11 11 11 11 11 11 0 11 11 11 11 0 11 11 11 11 11 0 11 0 0 0 11 11 11 11 11 11 11 11 11 11 11 11 0 0 11 11 11 11 11 11 11 11 11 11 11 0 11 11 11 11 11 11 11 11 0 0 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 15 15 15 15 15 15 15 0 0 0 0 15 15 15 15 15 0 0 0 0 15 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 15 15 15 15 15 0 0 15 15 15 15 15 15 15 0 15 15 0 15 15 15 15 15 0 0 0 0 0 15 15 15 15 15 15 15 11 11 11 11 11 11 11 0 0 9 9 9 9 9 9 9 9 9 9 0 0 0 0 11 0 11 11 11 11 15 15 15 15 15 15 15 11 0 0 0 0 0 11 11 0 11 0 0 11 0 11 11 11 11 11 11 11 11 11 11 0 11 11 11 11 0 11 0 11 0 0 0 0 0 0 11 0 0 0 0 11 0 11 0 11 0 11 11 11 0 11 11 0 11 0 0 11 0 11 0 11 0 11 0 11 0 11 11 0 11 0 0 11 11 11 11 0 11 11 11 11 11 11 11 0 11 11 11 11 0 11 11 11 11 0 11 0 11 11 11 11 11 11 11 11 11 11 0 11 11 11 11 11 0 11 11 11 0 11 11 11 11 11 0 11 11 11 11 11 0 0 0 0 0 0 0 0 0 0 0 0 0 13 13 13 11 11 11 11 11 11 11 11 11 11 0 0 13 13 13 13 18 18 11 11 11 11 11 11 11 11 11 11 11 11 18 18 11 11 11 11 11 11 11 11 11 11 0 0 0 0 13 0 0 13 13 13 13 13 13 13 13 13 13 0 0 0 0 0 13 13 13 13 13 13 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 0 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 0 0 0 0 0 0 0 0 0 0 13 0 0 0 0 0 0 0 13 13 13 13 13 13 13 13 13 0 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 15 15 15 15 15 13 13 13 13 13 13 13 13 13 13 13 13 13 13 0 0 0 0 0 0 0 0 13 13 13 13 13 13 13 13 13 13 0 0 0 0 13 13 13 13 13 13 13 13 13 13 13 13 0 0 0 0 0 13 13 13 13 13 13 13 13 13 13 13 0 0 0 0 0 0 0 0 0 0 0 0 13 13 13 13 0 0 0 0 0 0 0 0 13 13 13 13 13 13 13 13 0 0 0 0 0 0 0 0 0 0 13 13 13 13 13 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 13 13 13 13 13 13 13 13 13 13 13 13 0 13 13 13 13 0 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0))

(define |ucd-WB+EP-table-5|
  '#(18 9 13 0 17 1 16 12 10 14 11 7 2 19 4 3 5 20 8 6 15))
