#| -*-Scheme-*-

Copyright (C) 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994,
    1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
    2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016,
    2017, 2018, 2019, 2020, 2021, 2022 Massachusetts Institute of
    Technology

This file is part of MIT/GNU Scheme.

MIT/GNU Scheme is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

MIT/GNU Scheme is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with MIT/GNU Scheme; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,
USA.

|#

;;;; UCD property: stc (simple-title-case)

;;; Generated from Unicode 13.0.0

(declare (usual-integrations))

(define (ucd-stc-value char)
  (or (let ((sv (char->integer char)))
        (vector-ref ucd-stc-table-5 (bytevector-u16be-ref ucd-stc-table-4 (fix:lsh (fix:or (fix:lsh (bytevector-u8-ref ucd-stc-table-3 (fix:or (fix:lsh (bytevector-u8-ref ucd-stc-table-2 (fix:or (fix:lsh (bytevector-u8-ref ucd-stc-table-1 (fix:or (fix:lsh (bytevector-u8-ref ucd-stc-table-0 (fix:lsh sv -16)) 4) (fix:and 15 (fix:lsh sv -12)))) 4) (fix:and 15 (fix:lsh sv -8)))) 4) (fix:and 15 (fix:lsh sv -4)))) 4) (fix:and 15 sv)) 1))))
      char))

(define ucd-stc-table-0
  '#u8(0 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))

(define ucd-stc-table-1
  '#u8(0 1 2 3 3 3 3 3 3 3 4 3 3 3 3 5 6 7 3 3 3 3 8 3 3 3 3 3 3 3 9 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3))

(define ucd-stc-table-2
  '#u8(0 1 2 3 4 5 6 6 6 6 6 6 6 6 6 6 6 6 6 7 6 6 6 6 6 6 6 6 8 9 10 11 6 12 6 6 13 6 6 6 6 6 6 6 14 15 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 16 17 6 6 6 18 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 19 6 6 6 6 20 6 6 6 6 6 6 6 21 6 6 6 6 6 6 6 6 6 6 6 22 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 23 6 6 6 6 6 6 6 6 6 6 24 6 6 6 6 6 6))

(define ucd-stc-table-3
  '#u8(0 0 0 0 0 0 1 2 0 0 0 3 0 0 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 0 0 0 0 0 0 0 0 0 0 32 0 0 33 0 0 34 35 36 37 38 39 0 0 0 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 0 0 0 56 57 58 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 59 0 0 0 0 0 0 0 0 60 0 0 0 0 0 0 0 0 0 0 0 0 0 0 61 62 0 0 0 0 0 0 0 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 0 0 0 0 95 0 0 96 97 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 98 99 0 0 0 0 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 116 117 118 0 119 120 0 0 0 0 0 0 0 0 121 122 123 124 125 126 127 128 129 130 131 0 0 132 0 0 0 0 0 133 0 134 135 136 137 138 0 0 0 0 0 0 0 0 139 140 0 0 0 0 0 0 0 0 0 0 0 0 141 142 143 0 0 0 0 0 0 0 0 144 145 146 0 0 0 0 0 0 0 0 0 0 0 0 147 148 149 150 0 0 0 0 0 0 0 0 0 0 0 0 151 152 0 0 0 0 0 0 0 0 153 154 0 0 0 0 0 0 0 0 0 0 155 156 157 0 0 0 0 0 0 0 0 0 0 0))

(define ucd-stc-table-4
  '#u8(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 2 0 3 0 4 0 5 0 6 0 7 0 8 0 9 0 10 0 11 0 12 0 13 0 14 0 15 0 16 0 17 0 18 0 19 0 20 0 21 0 22 0 23 0 24 0 25 0 26 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 27 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 28 0 29 0 30 0 31 0 32 0 33 0 34 0 35 0 36 0 37 0 38 0 39 0 40 0 41 0 42 0 43 0 44 0 45 0 46 0 47 0 48 0 49 0 50 0 0 0 51 0 52 0 53 0 54 0 55 0 56 0 57 0 58 0 0 0 59 0 0 0 60 0 0 0 61 0 0 0 62 0 0 0 63 0 0 0 64 0 0 0 65 0 0 0 66 0 0 0 67 0 0 0 68 0 0 0 69 0 0 0 70 0 0 0 71 0 0 0 72 0 0 0 73 0 0 0 74 0 0 0 75 0 0 0 76 0 0 0 77 0 0 0 78 0 0 0 79 0 0 0 80 0 0 0 81 0 0 0 82 0 0 0 9 0 0 0 83 0 0 0 84 0 0 0 85 0 0 0 0 0 86 0 0 0 87 0 0 0 88 0 0 0 89 0 0 0 90 0 0 0 91 0 0 0 92 0 0 0 93 0 0 0 0 0 94 0 0 0 95 0 0 0 96 0 0 0 97 0 0 0 98 0 0 0 99 0 0 0 100 0 0 0 101 0 0 0 102 0 0 0 103 0 0 0 104 0 0 0 105 0 0 0 106 0 0 0 107 0 0 0 108 0 0 0 109 0 0 0 110 0 0 0 111 0 0 0 112 0 0 0 113 0 0 0 114 0 0 0 115 0 0 0 116 0 0 0 0 0 117 0 0 0 118 0 0 0 119 0 19 0 120 0 0 0 0 0 121 0 0 0 122 0 0 0 0 0 123 0 0 0 0 0 0 0 124 0 0 0 0 0 0 0 0 0 0 0 125 0 0 0 0 0 126 0 0 0 0 0 0 0 127 0 128 0 0 0 0 0 0 0 129 0 0 0 0 0 130 0 0 0 131 0 0 0 132 0 0 0 0 0 133 0 0 0 0 0 0 0 0 0 134 0 0 0 0 0 135 0 0 0 0 0 0 0 136 0 0 0 137 0 0 0 0 0 138 0 0 0 0 0 0 0 139 0 0 0 140 0 0 0 0 0 0 0 0 0 141 0 0 0 141 0 142 0 0 0 142 0 143 0 0 0 143 0 0 0 144 0 0 0 145 0 0 0 146 0 0 0 147 0 0 0 148 0 0 0 149 0 0 0 150 0 0 0 151 0 152 0 0 0 153 0 0 0 154 0 0 0 155 0 0 0 156 0 0 0 157 0 0 0 158 0 0 0 159 0 0 0 160 0 0 0 161 0 0 0 162 0 0 0 162 0 0 0 163 0 0 0 0 0 0 0 164 0 0 0 165 0 0 0 166 0 0 0 167 0 0 0 168 0 0 0 169 0 0 0 170 0 0 0 171 0 0 0 172 0 0 0 173 0 0 0 174 0 0 0 175 0 0 0 176 0 0 0 177 0 0 0 178 0 0 0 179 0 0 0 180 0 0 0 181 0 0 0 182 0 0 0 183 0 0 0 0 0 0 0 184 0 0 0 185 0 0 0 186 0 0 0 187 0 0 0 188 0 0 0 189 0 0 0 190 0 0 0 191 0 0 0 192 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 193 0 0 0 0 0 194 0 195 0 0 0 196 0 0 0 0 0 0 0 0 0 197 0 0 0 198 0 0 0 199 0 0 0 200 0 0 0 201 0 202 0 203 0 204 0 205 0 206 0 0 0 207 0 208 0 0 0 209 0 0 0 210 0 211 0 0 0 0 0 0 0 212 0 213 0 0 0 214 0 0 0 215 0 216 0 0 0 217 0 218 0 219 0 220 0 221 0 0 0 0 0 222 0 0 0 223 0 224 0 0 0 0 0 225 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 226 0 0 0 0 0 227 0 0 0 228 0 229 0 0 0 0 0 0 0 230 0 231 0 232 0 233 0 234 0 235 0 0 0 0 0 0 0 0 0 0 0 236 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 237 0 238 0 0 0 0 0 0 0 0 0 0 0 0 0 239 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 240 0 0 0 241 0 0 0 0 0 0 0 242 0 0 0 0 0 0 0 243 0 244 0 245 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 246 0 247 0 248 0 249 0 0 0 250 0 251 0 252 0 253 0 254 0 255 1 0 1 1 0 239 1 2 1 3 0 27 1 4 1 5 1 6 1 7 1 8 1 9 1 9 1 10 1 11 1 12 1 13 1 14 1 15 1 16 1 17 1 18 1 19 1 20 0 0 0 251 1 1 0 0 0 0 0 0 1 12 1 7 1 21 0 0 1 22 0 0 1 23 0 0 1 24 0 0 1 25 0 0 1 26 0 0 1 27 0 0 1 28 0 0 1 29 0 0 1 30 0 0 1 31 0 0 1 32 0 0 1 33 1 2 1 8 1 34 1 35 0 0 0 254 0 0 0 0 1 36 0 0 0 0 1 37 0 0 0 0 0 0 0 0 1 38 1 39 1 40 1 41 1 42 1 43 1 44 1 45 1 46 1 47 1 48 1 49 1 50 1 51 1 52 1 53 1 54 1 55 1 56 1 57 1 58 1 59 1 60 1 61 1 62 1 63 1 64 1 65 1 66 1 67 1 68 1 69 1 70 1 71 1 72 1 73 1 74 1 75 1 76 1 77 1 78 1 79 1 80 1 81 1 82 1 83 1 84 1 85 0 0 1 86 0 0 1 87 0 0 1 88 0 0 1 89 0 0 1 90 0 0 1 91 0 0 1 92 0 0 1 93 0 0 1 94 0 0 1 95 0 0 1 96 0 0 1 97 0 0 1 98 0 0 1 99 0 0 1 100 0 0 1 101 0 0 1 102 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 103 0 0 1 104 0 0 1 105 0 0 1 106 0 0 1 107 0 0 1 108 0 0 1 109 0 0 1 110 0 0 1 111 0 0 1 112 0 0 1 113 0 0 1 114 0 0 1 115 0 0 1 116 0 0 1 117 0 0 1 118 0 0 1 119 0 0 1 120 0 0 1 121 0 0 1 122 0 0 1 123 0 0 1 124 0 0 1 125 0 0 1 126 0 0 1 127 0 0 1 128 0 0 1 129 0 0 0 0 1 130 0 0 1 131 0 0 1 132 0 0 1 133 0 0 1 134 0 0 1 135 0 0 1 136 1 137 0 0 1 138 0 0 1 139 0 0 1 140 0 0 1 141 0 0 1 142 0 0 1 143 0 0 1 144 0 0 1 145 0 0 1 146 0 0 1 147 0 0 1 148 0 0 1 149 0 0 1 150 0 0 1 151 0 0 1 152 0 0 1 153 0 0 1 154 0 0 1 155 0 0 1 156 0 0 1 157 0 0 1 158 0 0 1 159 0 0 1 160 0 0 1 161 0 0 1 162 0 0 1 163 0 0 1 164 0 0 1 165 0 0 1 166 0 0 1 167 0 0 1 168 0 0 1 169 0 0 1 170 0 0 1 171 0 0 1 172 0 0 1 173 0 0 1 174 0 0 1 175 0 0 1 176 0 0 1 177 0 0 1 178 0 0 1 179 0 0 1 180 0 0 1 181 0 0 1 182 0 0 1 183 0 0 1 184 0 0 1 185 0 0 1 186 1 187 1 188 1 189 1 190 1 191 1 192 1 193 1 194 1 195 1 196 1 197 1 198 1 199 1 200 1 201 1 202 1 203 1 204 1 205 1 206 1 207 1 208 1 209 1 210 1 211 1 212 1 213 1 214 1 215 1 216 1 217 1 218 1 219 1 220 1 221 1 222 1 223 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 224 1 225 1 226 1 227 1 228 1 229 0 0 0 0 1 40 1 42 1 52 1 55 1 56 1 56 1 64 1 87 1 230 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 231 0 0 0 0 0 0 1 232 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 233 0 0 0 0 1 234 0 0 1 235 0 0 1 236 0 0 1 237 0 0 1 238 0 0 1 239 0 0 1 240 0 0 1 241 0 0 1 242 0 0 1 243 0 0 1 244 0 0 1 245 0 0 1 246 0 0 1 247 0 0 1 248 0 0 1 249 0 0 1 250 0 0 1 251 0 0 1 252 0 0 1 253 0 0 1 254 0 0 1 255 0 0 2 0 0 0 2 1 0 0 2 2 0 0 2 3 0 0 2 4 0 0 2 5 0 0 2 6 0 0 2 7 0 0 2 8 0 0 2 9 0 0 2 10 0 0 2 11 0 0 2 12 0 0 2 13 0 0 2 14 0 0 2 15 0 0 2 16 0 0 2 17 0 0 2 18 0 0 2 19 0 0 2 20 0 0 2 21 0 0 2 22 0 0 2 23 0 0 2 24 0 0 2 25 0 0 2 26 0 0 2 27 0 0 2 28 0 0 2 29 0 0 2 30 0 0 2 31 0 0 2 32 0 0 2 33 0 0 2 34 0 0 2 35 0 0 2 36 0 0 2 37 0 0 2 38 0 0 2 39 0 0 2 40 0 0 2 41 0 0 2 42 0 0 2 43 0 0 2 44 0 0 2 45 0 0 2 46 0 0 2 47 0 0 2 48 0 0 2 49 0 0 2 50 0 0 2 51 0 0 2 52 0 0 0 0 0 0 0 0 0 0 2 26 0 0 0 0 0 0 0 0 0 0 2 53 0 0 2 54 0 0 2 55 0 0 2 56 0 0 2 57 0 0 2 58 0 0 2 59 0 0 2 60 0 0 2 61 0 0 2 62 0 0 2 63 0 0 2 64 0 0 2 65 0 0 2 66 0 0 2 67 0 0 2 68 0 0 2 69 0 0 2 70 0 0 2 71 0 0 2 72 0 0 2 73 0 0 2 74 0 0 2 75 0 0 2 76 0 0 2 77 0 0 2 78 0 0 2 79 0 0 2 80 0 0 2 81 0 0 2 82 0 0 2 83 0 0 2 84 0 0 2 85 0 0 2 86 0 0 2 87 0 0 2 88 0 0 2 89 0 0 2 90 0 0 2 91 0 0 2 92 0 0 2 93 0 0 2 94 0 0 2 95 0 0 2 96 0 0 2 97 0 0 2 98 0 0 2 99 0 0 2 100 2 101 2 102 2 103 2 104 2 105 2 106 2 107 2 108 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 109 2 110 2 111 2 112 2 113 2 114 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 115 2 116 2 117 2 118 2 119 2 120 2 121 2 122 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 123 2 124 2 125 2 126 2 127 2 128 2 129 2 130 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 131 2 132 2 133 2 134 2 135 2 136 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 137 0 0 2 138 0 0 2 139 0 0 2 140 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 141 2 142 2 143 2 144 2 145 2 146 2 147 2 148 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 149 2 150 2 151 2 152 2 153 2 154 2 155 2 156 2 157 2 158 2 159 2 160 2 161 2 162 0 0 0 0 2 163 2 164 2 165 2 166 2 167 2 168 2 169 2 170 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 171 2 172 2 173 2 174 2 175 2 176 2 177 2 178 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 179 2 180 2 181 2 182 2 183 2 184 2 185 2 186 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 187 2 188 0 0 2 189 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 239 0 0 0 0 0 0 0 0 2 190 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 191 2 192 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 193 2 194 0 0 0 0 0 0 2 195 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 196 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 197 0 0 2 198 2 199 2 200 2 201 2 202 2 203 2 204 2 205 2 206 2 207 2 208 2 209 2 210 2 211 2 212 2 213 0 0 0 0 0 0 0 0 2 214 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 215 2 216 2 217 2 218 2 219 2 220 2 221 2 222 2 223 2 224 2 225 2 226 2 227 2 228 2 229 2 230 2 231 2 232 2 233 2 234 2 235 2 236 2 237 2 238 2 239 2 240 0 0 0 0 0 0 0 0 0 0 0 0 2 241 2 242 2 243 2 244 2 245 2 246 2 247 2 248 2 249 2 250 2 251 2 252 2 253 2 254 2 255 3 0 3 1 3 2 3 3 3 4 3 5 3 6 3 7 3 8 3 9 3 10 3 11 3 12 3 13 3 14 3 15 3 16 3 17 3 18 3 19 3 20 3 21 3 22 3 23 3 24 3 25 3 26 3 27 3 28 3 29 3 30 3 31 0 0 0 0 3 32 0 0 0 0 0 0 3 33 3 34 0 0 3 35 0 0 3 36 0 0 3 37 0 0 0 0 0 0 0 0 0 0 0 0 3 38 0 0 0 0 3 39 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 40 0 0 3 41 0 0 3 42 0 0 3 43 0 0 3 44 0 0 3 45 0 0 3 46 0 0 3 47 0 0 3 48 0 0 3 49 0 0 3 50 0 0 3 51 0 0 3 52 0 0 3 53 0 0 3 54 0 0 3 55 0 0 3 56 0 0 3 57 0 0 3 58 0 0 3 59 0 0 3 60 0 0 3 61 0 0 3 62 0 0 3 63 0 0 3 64 0 0 3 65 0 0 3 66 0 0 3 67 0 0 3 68 0 0 3 69 0 0 3 70 0 0 3 71 0 0 3 72 0 0 3 73 0 0 3 74 0 0 3 75 0 0 3 76 0 0 3 77 0 0 3 78 0 0 3 79 0 0 3 80 0 0 3 81 0 0 3 82 0 0 3 83 0 0 3 84 0 0 3 85 0 0 3 86 0 0 3 87 0 0 3 88 0 0 3 89 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 90 0 0 3 91 0 0 0 0 0 0 0 0 3 92 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 93 3 94 3 95 3 96 3 97 3 98 3 99 3 100 3 101 3 102 3 103 3 104 3 105 3 106 3 107 3 108 3 109 3 110 3 111 3 112 3 113 3 114 3 115 3 116 3 117 3 118 3 119 3 120 3 121 3 122 3 123 3 124 3 125 3 126 3 127 3 128 3 129 3 130 0 0 3 131 0 0 0 0 0 0 0 0 0 0 3 132 0 0 0 0 0 0 3 133 0 0 3 134 0 0 3 135 0 0 3 136 0 0 3 137 0 0 1 230 0 0 3 138 0 0 3 139 0 0 3 140 0 0 3 141 0 0 3 142 0 0 3 143 0 0 3 144 0 0 3 145 0 0 3 146 0 0 3 147 0 0 3 148 0 0 3 149 0 0 3 150 0 0 3 151 0 0 3 152 0 0 3 153 0 0 3 154 0 0 0 0 0 0 3 155 0 0 3 156 0 0 3 157 0 0 3 158 0 0 3 159 0 0 3 160 0 0 3 161 0 0 3 162 0 0 3 163 0 0 3 164 0 0 3 165 0 0 3 166 0 0 3 167 0 0 3 168 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 169 0 0 3 170 0 0 3 171 0 0 3 172 0 0 3 173 0 0 3 174 0 0 3 175 0 0 0 0 0 0 3 176 0 0 3 177 0 0 3 178 0 0 3 179 0 0 3 180 0 0 3 181 0 0 3 182 0 0 3 183 0 0 3 184 0 0 3 185 0 0 3 186 0 0 3 187 0 0 3 188 0 0 3 189 0 0 3 190 0 0 3 191 0 0 3 192 0 0 3 193 0 0 3 194 0 0 3 195 0 0 3 196 0 0 3 197 0 0 3 198 0 0 3 199 0 0 3 200 0 0 3 201 0 0 3 202 0 0 3 203 0 0 3 204 0 0 3 205 0 0 3 206 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 207 0 0 3 208 0 0 0 0 3 209 0 0 3 210 0 0 3 211 0 0 3 212 0 0 3 213 0 0 0 0 0 0 0 0 3 214 0 0 0 0 0 0 0 0 3 215 0 0 3 216 3 217 0 0 0 0 3 218 0 0 3 219 0 0 3 220 0 0 3 221 0 0 3 222 0 0 3 223 0 0 3 224 0 0 3 225 0 0 3 226 0 0 3 227 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 228 0 0 3 229 0 0 3 230 0 0 3 231 0 0 3 232 0 0 3 233 0 0 0 0 0 0 3 234 0 0 0 0 0 0 0 0 3 235 0 0 3 236 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 237 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 238 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 239 3 240 3 241 3 242 3 243 3 244 3 245 3 246 3 247 3 248 3 249 3 250 3 251 3 252 3 253 3 254 3 255 4 0 4 1 4 2 4 3 4 4 4 5 4 6 4 7 4 8 4 9 4 10 4 11 4 12 4 13 4 14 4 15 4 16 4 17 4 18 4 19 4 20 4 21 4 22 4 23 4 24 4 25 4 26 4 27 4 28 4 29 4 30 4 31 4 32 4 33 4 34 4 35 4 36 4 37 4 38 4 39 4 40 4 41 4 42 4 43 4 44 4 45 4 46 4 47 4 48 4 49 4 50 4 51 4 52 4 53 4 54 4 55 4 56 4 57 4 58 4 59 4 60 4 61 4 62 0 0 4 63 4 64 4 65 4 66 4 67 4 68 4 69 4 70 4 71 4 72 4 73 4 74 4 75 4 76 4 77 4 78 4 79 4 80 4 81 4 82 4 83 4 84 4 85 4 86 4 87 4 88 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 89 4 90 4 91 4 92 4 93 4 94 4 95 4 96 4 97 4 98 4 99 4 100 4 101 4 102 4 103 4 104 4 105 4 106 4 107 4 108 4 109 4 110 4 111 4 112 4 113 4 114 4 115 4 116 4 117 4 118 4 119 4 120 4 121 4 122 4 123 4 124 4 125 4 126 4 127 4 128 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 129 4 130 4 131 4 132 4 133 4 134 4 135 4 136 4 137 4 138 4 139 4 140 4 141 4 142 4 143 4 144 4 145 4 146 4 147 4 148 4 149 4 150 4 151 4 152 4 153 4 154 4 155 4 156 4 157 4 158 4 159 4 160 4 161 4 162 4 163 4 164 0 0 0 0 0 0 0 0 4 165 4 166 4 167 4 168 4 169 4 170 4 171 4 172 4 173 4 174 4 175 4 176 4 177 4 178 4 179 4 180 4 181 4 182 4 183 4 184 4 185 4 186 4 187 4 188 4 189 4 190 4 191 4 192 4 193 4 194 4 195 4 196 4 197 4 198 4 199 4 200 4 201 4 202 4 203 4 204 4 205 4 206 4 207 4 208 4 209 4 210 4 211 4 212 4 213 4 214 4 215 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 216 4 217 4 218 4 219 4 220 4 221 4 222 4 223 4 224 4 225 4 226 4 227 4 228 4 229 4 230 4 231 4 232 4 233 4 234 4 235 4 236 4 237 4 238 4 239 4 240 4 241 4 242 4 243 4 244 4 245 4 246 4 247 4 248 4 249 4 250 4 251 4 252 4 253 4 254 4 255 5 0 5 1 5 2 5 3 5 4 5 5 5 6 5 7 5 8 5 9 5 10 5 11 5 12 5 13 5 14 5 15 5 16 5 17 5 18 5 19 5 20 5 21 5 22 5 23 0 0 0 0 5 24 5 25 5 26 5 27 5 28 5 29 5 30 5 31 5 32 5 33 5 34 5 35 5 36 5 37 5 38 5 39 5 40 5 41 5 42 5 43 5 44 5 45 5 46 5 47 5 48 5 49 5 50 5 51 5 52 5 53 5 54 5 55 5 56 5 57 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))

(define ucd-stc-table-5
  '#(#f       #\A      #\B      #\C      #\D      #\E      #\F      #\G      #\H      #\I      #\J      #\K      #\L      #\M      #\N      #\O      #\P      #\Q      #\R      #\S      #\T      #\U      #\V      #\W      #\X      #\Y      #\Z      #\x39c   #\xc0    #\xc1    #\xc2    #\xc3    #\xc4    #\xc5    #\xc6    #\xc7    #\xc8    #\xc9    #\xca    #\xcb    #\xcc    #\xcd    #\xce    #\xcf    #\xd0    #\xd1    #\xd2    #\xd3    #\xd4    #\xd5    #\xd6    #\xd8    #\xd9    #\xda    #\xdb    #\xdc    #\xdd    #\xde    #\x178   #\x100   #\x102   #\x104   #\x106   #\x108   #\x10a   #\x10c   #\x10e   #\x110   #\x112   #\x114   #\x116   #\x118   #\x11a   #\x11c   #\x11e   #\x120   #\x122   #\x124   #\x126   #\x128   #\x12a   #\x12c   #\x12e   #\x132   #\x134   #\x136   #\x139   #\x13b   #\x13d   #\x13f   #\x141   #\x143   #\x145   #\x147   #\x14a   #\x14c   #\x14e   #\x150   #\x152   #\x154   #\x156   #\x158   #\x15a   #\x15c   #\x15e   #\x160   #\x162   #\x164   #\x166
     #\x168   #\x16a   #\x16c   #\x16e   #\x170   #\x172   #\x174   #\x176   #\x179   #\x17b   #\x17d   #\x243   #\x182   #\x184   #\x187   #\x18b   #\x191   #\x1f6   #\x198   #\x23d   #\x220   #\x1a0   #\x1a2   #\x1a4   #\x1a7   #\x1ac   #\x1af   #\x1b3   #\x1b5   #\x1b8   #\x1bc   #\x1f7   #\x1c5   #\x1c8   #\x1cb   #\x1cd   #\x1cf   #\x1d1   #\x1d3   #\x1d5   #\x1d7   #\x1d9   #\x1db   #\x18e   #\x1de   #\x1e0   #\x1e2   #\x1e4   #\x1e6   #\x1e8   #\x1ea   #\x1ec   #\x1ee   #\x1f2   #\x1f4   #\x1f8   #\x1fa   #\x1fc   #\x1fe   #\x200   #\x202   #\x204   #\x206   #\x208   #\x20a   #\x20c   #\x20e   #\x210   #\x212   #\x214   #\x216   #\x218   #\x21a   #\x21c   #\x21e   #\x222   #\x224   #\x226   #\x228   #\x22a   #\x22c   #\x22e   #\x230   #\x232   #\x23b   #\x2c7e  #\x2c7f  #\x241   #\x246   #\x248   #\x24a   #\x24c   #\x24e   #\x2c6f  #\x2c6d  #\x2c70  #\x181   #\x186   #\x189   #\x18a   #\x18f   #\x190   #\xa7ab  #\x193   #\xa7ac  #\x194   #\xa78d  #\xa7aa  #\x197
     #\x196   #\xa7ae  #\x2c62  #\xa7ad  #\x19c   #\x2c6e  #\x19d   #\x19f   #\x2c64  #\x1a6   #\xa7c5  #\x1a9   #\xa7b1  #\x1ae   #\x244   #\x1b1   #\x1b2   #\x245   #\x1b7   #\xa7b2  #\xa7b0  #\x399   #\x370   #\x372   #\x376   #\x3fd   #\x3fe   #\x3ff   #\x386   #\x388   #\x389   #\x38a   #\x391   #\x392   #\x393   #\x394   #\x395   #\x396   #\x397   #\x398   #\x39a   #\x39b   #\x39d   #\x39e   #\x39f   #\x3a0   #\x3a1   #\x3a3   #\x3a4   #\x3a5   #\x3a6   #\x3a7   #\x3a8   #\x3a9   #\x3aa   #\x3ab   #\x38c   #\x38e   #\x38f   #\x3cf   #\x3d8   #\x3da   #\x3dc   #\x3de   #\x3e0   #\x3e2   #\x3e4   #\x3e6   #\x3e8   #\x3ea   #\x3ec   #\x3ee   #\x3f9   #\x37f   #\x3f7   #\x3fa   #\x410   #\x411   #\x412   #\x413   #\x414   #\x415   #\x416   #\x417   #\x418   #\x419   #\x41a   #\x41b   #\x41c   #\x41d   #\x41e   #\x41f   #\x420   #\x421   #\x422   #\x423   #\x424   #\x425   #\x426   #\x427   #\x428   #\x429   #\x42a   #\x42b   #\x42c   #\x42d   #\x42e   #\x42f   #\x400
     #\x401   #\x402   #\x403   #\x404   #\x405   #\x406   #\x407   #\x408   #\x409   #\x40a   #\x40b   #\x40c   #\x40d   #\x40e   #\x40f   #\x460   #\x462   #\x464   #\x466   #\x468   #\x46a   #\x46c   #\x46e   #\x470   #\x472   #\x474   #\x476   #\x478   #\x47a   #\x47c   #\x47e   #\x480   #\x48a   #\x48c   #\x48e   #\x490   #\x492   #\x494   #\x496   #\x498   #\x49a   #\x49c   #\x49e   #\x4a0   #\x4a2   #\x4a4   #\x4a6   #\x4a8   #\x4aa   #\x4ac   #\x4ae   #\x4b0   #\x4b2   #\x4b4   #\x4b6   #\x4b8   #\x4ba   #\x4bc   #\x4be   #\x4c1   #\x4c3   #\x4c5   #\x4c7   #\x4c9   #\x4cb   #\x4cd   #\x4c0   #\x4d0   #\x4d2   #\x4d4   #\x4d6   #\x4d8   #\x4da   #\x4dc   #\x4de   #\x4e0   #\x4e2   #\x4e4   #\x4e6   #\x4e8   #\x4ea   #\x4ec   #\x4ee   #\x4f0   #\x4f2   #\x4f4   #\x4f6   #\x4f8   #\x4fa   #\x4fc   #\x4fe   #\x500   #\x502   #\x504   #\x506   #\x508   #\x50a   #\x50c   #\x50e   #\x510   #\x512   #\x514   #\x516   #\x518   #\x51a   #\x51c   #\x51e   #\x520   #\x522
     #\x524   #\x526   #\x528   #\x52a   #\x52c   #\x52e   #\x531   #\x532   #\x533   #\x534   #\x535   #\x536   #\x537   #\x538   #\x539   #\x53a   #\x53b   #\x53c   #\x53d   #\x53e   #\x53f   #\x540   #\x541   #\x542   #\x543   #\x544   #\x545   #\x546   #\x547   #\x548   #\x549   #\x54a   #\x54b   #\x54c   #\x54d   #\x54e   #\x54f   #\x550   #\x551   #\x552   #\x553   #\x554   #\x555   #\x556   #\x13f0  #\x13f1  #\x13f2  #\x13f3  #\x13f4  #\x13f5  #\xa64a  #\xa77d  #\x2c63  #\xa7c6  #\x1e00  #\x1e02  #\x1e04  #\x1e06  #\x1e08  #\x1e0a  #\x1e0c  #\x1e0e  #\x1e10  #\x1e12  #\x1e14  #\x1e16  #\x1e18  #\x1e1a  #\x1e1c  #\x1e1e  #\x1e20  #\x1e22  #\x1e24  #\x1e26  #\x1e28  #\x1e2a  #\x1e2c  #\x1e2e  #\x1e30  #\x1e32  #\x1e34  #\x1e36  #\x1e38  #\x1e3a  #\x1e3c  #\x1e3e  #\x1e40  #\x1e42  #\x1e44  #\x1e46  #\x1e48  #\x1e4a  #\x1e4c  #\x1e4e  #\x1e50  #\x1e52  #\x1e54  #\x1e56  #\x1e58  #\x1e5a  #\x1e5c  #\x1e5e  #\x1e60  #\x1e62  #\x1e64  #\x1e66  #\x1e68  #\x1e6a  #\x1e6c
     #\x1e6e  #\x1e70  #\x1e72  #\x1e74  #\x1e76  #\x1e78  #\x1e7a  #\x1e7c  #\x1e7e  #\x1e80  #\x1e82  #\x1e84  #\x1e86  #\x1e88  #\x1e8a  #\x1e8c  #\x1e8e  #\x1e90  #\x1e92  #\x1e94  #\x1ea0  #\x1ea2  #\x1ea4  #\x1ea6  #\x1ea8  #\x1eaa  #\x1eac  #\x1eae  #\x1eb0  #\x1eb2  #\x1eb4  #\x1eb6  #\x1eb8  #\x1eba  #\x1ebc  #\x1ebe  #\x1ec0  #\x1ec2  #\x1ec4  #\x1ec6  #\x1ec8  #\x1eca  #\x1ecc  #\x1ece  #\x1ed0  #\x1ed2  #\x1ed4  #\x1ed6  #\x1ed8  #\x1eda  #\x1edc  #\x1ede  #\x1ee0  #\x1ee2  #\x1ee4  #\x1ee6  #\x1ee8  #\x1eea  #\x1eec  #\x1eee  #\x1ef0  #\x1ef2  #\x1ef4  #\x1ef6  #\x1ef8  #\x1efa  #\x1efc  #\x1efe  #\x1f08  #\x1f09  #\x1f0a  #\x1f0b  #\x1f0c  #\x1f0d  #\x1f0e  #\x1f0f  #\x1f18  #\x1f19  #\x1f1a  #\x1f1b  #\x1f1c  #\x1f1d  #\x1f28  #\x1f29  #\x1f2a  #\x1f2b  #\x1f2c  #\x1f2d  #\x1f2e  #\x1f2f  #\x1f38  #\x1f39  #\x1f3a  #\x1f3b  #\x1f3c  #\x1f3d  #\x1f3e  #\x1f3f  #\x1f48  #\x1f49  #\x1f4a  #\x1f4b  #\x1f4c  #\x1f4d  #\x1f59  #\x1f5b  #\x1f5d  #\x1f5f  #\x1f68
     #\x1f69  #\x1f6a  #\x1f6b  #\x1f6c  #\x1f6d  #\x1f6e  #\x1f6f  #\x1fba  #\x1fbb  #\x1fc8  #\x1fc9  #\x1fca  #\x1fcb  #\x1fda  #\x1fdb  #\x1ff8  #\x1ff9  #\x1fea  #\x1feb  #\x1ffa  #\x1ffb  #\x1f88  #\x1f89  #\x1f8a  #\x1f8b  #\x1f8c  #\x1f8d  #\x1f8e  #\x1f8f  #\x1f98  #\x1f99  #\x1f9a  #\x1f9b  #\x1f9c  #\x1f9d  #\x1f9e  #\x1f9f  #\x1fa8  #\x1fa9  #\x1faa  #\x1fab  #\x1fac  #\x1fad  #\x1fae  #\x1faf  #\x1fb8  #\x1fb9  #\x1fbc  #\x1fcc  #\x1fd8  #\x1fd9  #\x1fe8  #\x1fe9  #\x1fec  #\x1ffc  #\x2132  #\x2160  #\x2161  #\x2162  #\x2163  #\x2164  #\x2165  #\x2166  #\x2167  #\x2168  #\x2169  #\x216a  #\x216b  #\x216c  #\x216d  #\x216e  #\x216f  #\x2183  #\x24b6  #\x24b7  #\x24b8  #\x24b9  #\x24ba  #\x24bb  #\x24bc  #\x24bd  #\x24be  #\x24bf  #\x24c0  #\x24c1  #\x24c2  #\x24c3  #\x24c4  #\x24c5  #\x24c6  #\x24c7  #\x24c8  #\x24c9  #\x24ca  #\x24cb  #\x24cc  #\x24cd  #\x24ce  #\x24cf  #\x2c00  #\x2c01  #\x2c02  #\x2c03  #\x2c04  #\x2c05  #\x2c06  #\x2c07  #\x2c08  #\x2c09
     #\x2c0a  #\x2c0b  #\x2c0c  #\x2c0d  #\x2c0e  #\x2c0f  #\x2c10  #\x2c11  #\x2c12  #\x2c13  #\x2c14  #\x2c15  #\x2c16  #\x2c17  #\x2c18  #\x2c19  #\x2c1a  #\x2c1b  #\x2c1c  #\x2c1d  #\x2c1e  #\x2c1f  #\x2c20  #\x2c21  #\x2c22  #\x2c23  #\x2c24  #\x2c25  #\x2c26  #\x2c27  #\x2c28  #\x2c29  #\x2c2a  #\x2c2b  #\x2c2c  #\x2c2d  #\x2c2e  #\x2c60  #\x23a   #\x23e   #\x2c67  #\x2c69  #\x2c6b  #\x2c72  #\x2c75  #\x2c80  #\x2c82  #\x2c84  #\x2c86  #\x2c88  #\x2c8a  #\x2c8c  #\x2c8e  #\x2c90  #\x2c92  #\x2c94  #\x2c96  #\x2c98  #\x2c9a  #\x2c9c  #\x2c9e  #\x2ca0  #\x2ca2  #\x2ca4  #\x2ca6  #\x2ca8  #\x2caa  #\x2cac  #\x2cae  #\x2cb0  #\x2cb2  #\x2cb4  #\x2cb6  #\x2cb8  #\x2cba  #\x2cbc  #\x2cbe  #\x2cc0  #\x2cc2  #\x2cc4  #\x2cc6  #\x2cc8  #\x2cca  #\x2ccc  #\x2cce  #\x2cd0  #\x2cd2  #\x2cd4  #\x2cd6  #\x2cd8  #\x2cda  #\x2cdc  #\x2cde  #\x2ce0  #\x2ce2  #\x2ceb  #\x2ced  #\x2cf2  #\x10a0  #\x10a1  #\x10a2  #\x10a3  #\x10a4  #\x10a5  #\x10a6  #\x10a7  #\x10a8  #\x10a9  #\x10aa
     #\x10ab  #\x10ac  #\x10ad  #\x10ae  #\x10af  #\x10b0  #\x10b1  #\x10b2  #\x10b3  #\x10b4  #\x10b5  #\x10b6  #\x10b7  #\x10b8  #\x10b9  #\x10ba  #\x10bb  #\x10bc  #\x10bd  #\x10be  #\x10bf  #\x10c0  #\x10c1  #\x10c2  #\x10c3  #\x10c4  #\x10c5  #\x10c7  #\x10cd  #\xa640  #\xa642  #\xa644  #\xa646  #\xa648  #\xa64c  #\xa64e  #\xa650  #\xa652  #\xa654  #\xa656  #\xa658  #\xa65a  #\xa65c  #\xa65e  #\xa660  #\xa662  #\xa664  #\xa666  #\xa668  #\xa66a  #\xa66c  #\xa680  #\xa682  #\xa684  #\xa686  #\xa688  #\xa68a  #\xa68c  #\xa68e  #\xa690  #\xa692  #\xa694  #\xa696  #\xa698  #\xa69a  #\xa722  #\xa724  #\xa726  #\xa728  #\xa72a  #\xa72c  #\xa72e  #\xa732  #\xa734  #\xa736  #\xa738  #\xa73a  #\xa73c  #\xa73e  #\xa740  #\xa742  #\xa744  #\xa746  #\xa748  #\xa74a  #\xa74c  #\xa74e  #\xa750  #\xa752  #\xa754  #\xa756  #\xa758  #\xa75a  #\xa75c  #\xa75e  #\xa760  #\xa762  #\xa764  #\xa766  #\xa768  #\xa76a  #\xa76c  #\xa76e  #\xa779  #\xa77b  #\xa77e  #\xa780  #\xa782  #\xa784
     #\xa786  #\xa78b  #\xa790  #\xa792  #\xa7c4  #\xa796  #\xa798  #\xa79a  #\xa79c  #\xa79e  #\xa7a0  #\xa7a2  #\xa7a4  #\xa7a6  #\xa7a8  #\xa7b4  #\xa7b6  #\xa7b8  #\xa7ba  #\xa7bc  #\xa7be  #\xa7c2  #\xa7c7  #\xa7c9  #\xa7f5  #\xa7b3  #\x13a0  #\x13a1  #\x13a2  #\x13a3  #\x13a4  #\x13a5  #\x13a6  #\x13a7  #\x13a8  #\x13a9  #\x13aa  #\x13ab  #\x13ac  #\x13ad  #\x13ae  #\x13af  #\x13b0  #\x13b1  #\x13b2  #\x13b3  #\x13b4  #\x13b5  #\x13b6  #\x13b7  #\x13b8  #\x13b9  #\x13ba  #\x13bb  #\x13bc  #\x13bd  #\x13be  #\x13bf  #\x13c0  #\x13c1  #\x13c2  #\x13c3  #\x13c4  #\x13c5  #\x13c6  #\x13c7  #\x13c8  #\x13c9  #\x13ca  #\x13cb  #\x13cc  #\x13cd  #\x13ce  #\x13cf  #\x13d0  #\x13d1  #\x13d2  #\x13d3  #\x13d4  #\x13d5  #\x13d6  #\x13d7  #\x13d8  #\x13d9  #\x13da  #\x13db  #\x13dc  #\x13dd  #\x13de  #\x13df  #\x13e0  #\x13e1  #\x13e2  #\x13e3  #\x13e4  #\x13e5  #\x13e6  #\x13e7  #\x13e8  #\x13e9  #\x13ea  #\x13eb  #\x13ec  #\x13ed  #\x13ee  #\x13ef  #\xff21  #\xff22  #\xff23
     #\xff24  #\xff25  #\xff26  #\xff27  #\xff28  #\xff29  #\xff2a  #\xff2b  #\xff2c  #\xff2d  #\xff2e  #\xff2f  #\xff30  #\xff31  #\xff32  #\xff33  #\xff34  #\xff35  #\xff36  #\xff37  #\xff38  #\xff39  #\xff3a  #\x10400 #\x10401 #\x10402 #\x10403 #\x10404 #\x10405 #\x10406 #\x10407 #\x10408 #\x10409 #\x1040a #\x1040b #\x1040c #\x1040d #\x1040e #\x1040f #\x10410 #\x10411 #\x10412 #\x10413 #\x10414 #\x10415 #\x10416 #\x10417 #\x10418 #\x10419 #\x1041a #\x1041b #\x1041c #\x1041d #\x1041e #\x1041f #\x10420 #\x10421 #\x10422 #\x10423 #\x10424 #\x10425 #\x10426 #\x10427 #\x104b0 #\x104b1 #\x104b2 #\x104b3 #\x104b4 #\x104b5 #\x104b6 #\x104b7 #\x104b8 #\x104b9 #\x104ba #\x104bb #\x104bc #\x104bd #\x104be #\x104bf #\x104c0 #\x104c1 #\x104c2 #\x104c3 #\x104c4 #\x104c5 #\x104c6 #\x104c7 #\x104c8 #\x104c9 #\x104ca #\x104cb #\x104cc #\x104cd #\x104ce #\x104cf #\x104d0 #\x104d1 #\x104d2 #\x104d3 #\x10c80 #\x10c81 #\x10c82 #\x10c83 #\x10c84 #\x10c85 #\x10c86 #\x10c87 #\x10c88 #\x10c89
     #\x10c8a #\x10c8b #\x10c8c #\x10c8d #\x10c8e #\x10c8f #\x10c90 #\x10c91 #\x10c92 #\x10c93 #\x10c94 #\x10c95 #\x10c96 #\x10c97 #\x10c98 #\x10c99 #\x10c9a #\x10c9b #\x10c9c #\x10c9d #\x10c9e #\x10c9f #\x10ca0 #\x10ca1 #\x10ca2 #\x10ca3 #\x10ca4 #\x10ca5 #\x10ca6 #\x10ca7 #\x10ca8 #\x10ca9 #\x10caa #\x10cab #\x10cac #\x10cad #\x10cae #\x10caf #\x10cb0 #\x10cb1 #\x10cb2 #\x118a0 #\x118a1 #\x118a2 #\x118a3 #\x118a4 #\x118a5 #\x118a6 #\x118a7 #\x118a8 #\x118a9 #\x118aa #\x118ab #\x118ac #\x118ad #\x118ae #\x118af #\x118b0 #\x118b1 #\x118b2 #\x118b3 #\x118b4 #\x118b5 #\x118b6 #\x118b7 #\x118b8 #\x118b9 #\x118ba #\x118bb #\x118bc #\x118bd #\x118be #\x118bf #\x16e40 #\x16e41 #\x16e42 #\x16e43 #\x16e44 #\x16e45 #\x16e46 #\x16e47 #\x16e48 #\x16e49 #\x16e4a #\x16e4b #\x16e4c #\x16e4d #\x16e4e #\x16e4f #\x16e50 #\x16e51 #\x16e52 #\x16e53 #\x16e54 #\x16e55 #\x16e56 #\x16e57 #\x16e58 #\x16e59 #\x16e5a #\x16e5b #\x16e5c #\x16e5d #\x16e5e #\x16e5f #\x1e900 #\x1e901 #\x1e902 #\x1e903
     #\x1e904 #\x1e905 #\x1e906 #\x1e907 #\x1e908 #\x1e909 #\x1e90a #\x1e90b #\x1e90c #\x1e90d #\x1e90e #\x1e90f #\x1e910 #\x1e911 #\x1e912 #\x1e913 #\x1e914 #\x1e915 #\x1e916 #\x1e917 #\x1e918 #\x1e919 #\x1e91a #\x1e91b #\x1e91c #\x1e91d #\x1e91e #\x1e91f #\x1e920 #\x1e921))
