/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.Library;
import gnu.jel.TestingUtils;
import gnu.jel.tests.DoubleObject;
import gnu.jel.tests.IntegerObject;
import gnu.jel.tests.VariableProvider;

public class IntegralReferencesWideningTest
extends TestingUtils {
    Library lib;
    Object[] rtp;
    VariableProvider vp;

    public IntegralReferencesWideningTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Class[] dynamicLib = new Class[1];
        this.rtp = new Object[1];
        this.vp = new VariableProvider();
        Class[] staticLib = new Class[]{Class.forName("java.lang.Math"), this.vp.getClass()};
        this.vp.xvar = 5.0;
        this.vp.strVar = "strVar";
        this.rtp[0] = this.vp;
        dynamicLib[0] = this.vp.getClass();
        Class[] dotLib = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.Double"), Class.forName("gnu.jel.reflect.Double"), IntegerObject.class, DoubleObject.class};
        this.lib = new Library(staticLib, dynamicLib, dotLib, this.vp, null);
        this.vp.addProperty("p1", "p1value");
        this.vp.addProperty("p1.s1", "p1s1value");
        this.vp.addProperty("p1.s2", "p1s2value");
        this.vp.addProperty("p1.d1", VariableProvider.makeJELDoubleObject(1.0));
        this.vp.addProperty("p1.s2.ss1", "p1s2ss1value");
        this.vp.addProperty("p1.b1t", VariableProvider.makeJELBooleanObject(true));
        this.vp.addProperty("p1.b1f", VariableProvider.makeJELBooleanObject(false));
    }

    public void test1() throws Throwable {
        IntegralReferencesWideningTest.simExpression("convertNumberToInt(makeDoubleObject(5.0))", new Integer(5), null, this.rtp, this.lib, null);
    }

    public void test2() throws Throwable {
        IntegralReferencesWideningTest.simExpression("convertNumberToInt(arrIntegerObj[0])", new Integer(1), null, this.rtp, this.lib, null);
    }

    public void test3() throws Throwable {
        IntegralReferencesWideningTest.simExpression("convertNumberToDouble(arrIntegerObj[0])", new Double(1.0), null, this.rtp, this.lib, null);
    }

    public void test4() throws Throwable {
        IntegralReferencesWideningTest.simExpression("convertNumberToDouble(makeDoubleObject(5.0))", new Double(5.0), null, this.rtp, this.lib, null);
    }

    public void test5() throws Throwable {
        IntegralReferencesWideningTest.simExpression("convertNumberToDouble(makeDoubleObject(5.0))", new Double(5.0), null, this.rtp, this.lib, null);
    }

    public void test6() throws Throwable {
        IntegralReferencesWideningTest.simExpression("addNumbersDbl(makeDoubleObject(5.0),arrIntegerObj[0])", new Double(6.0), null, this.rtp, this.lib, null);
    }

    public void test7() throws Throwable {
        IntegralReferencesWideningTest.simExpression("addNumbersInt(makeDoubleObject(5.0),arrIntegerObj[0])", new Integer(6), null, this.rtp, this.lib, null);
    }

    public void test8() throws Throwable {
        IntegralReferencesWideningTest.simExpression("isNullDouble(getDoubleNull())", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test9() throws Throwable {
        IntegralReferencesWideningTest.simExpression("isNullDouble(makeDoubleObject(5.0))", Boolean.FALSE, null, this.rtp, this.lib, null);
    }
}

