/*
 * send.c        1.2 4/30/95
 *
 *      (c) Copyright 1995 by Lance Cottrell. All right reserved.
 *      The author assumes no liability for damages resulting from the
 *      use of this software, even if the damage results from defects in
 *      this software. No warranty is expressed or implied.
 *
 *      This software is being distributed under the GNU Public Licence,
 *      see the file GNU.license for more details.
 *
 *                      - Lance Cottrell (loki@obscura.com) 4/23/95
 *
 */

#include "mixmaster.h"
#include "crypt.h"


#include <sys/file.h>

#ifndef LOCK_SH
#define LOCK_SH 1    /* shared lock */
#define LOCK_EX 2    /* exclusive lock */
#define LOCK_NB 4    /* don't block when locking */
#define LOCK_UN 8    /* unlock */
#endif


int process_pool()
{
	FILE	*fptr,*in;
	char	name[80],temp[256],*names[256],*foo;
	int	i,j,k;

	update_random();
	do {
	  i = file_list("mail*", names);
	  if(i>POOLSIZE) {
	    j = (our_randombyte() % i) ; /* 0 to (i-1) */
	    in = fopen(names[j],"r");
	    if(in == NULL) return(0);
	    flock(fileno(in),LOCK_EX);
	    fgets(name,255,in); /* this is the destination */
	    name[strlen(name)-1] = 0;
	    /* Last check for blocked destinations */
	    foo = name;
	    if(destination_block(1,&foo)) {
	       fclose(in);
	       return(0);
	    }
	    strcpy(temp,SENDMAIL);
	    strcat(temp,"\""); /* put address in quotes */
	    strcat(temp,name);
	    strcat(temp,"\"");
	    fptr = popen(temp,"w");
	    if(fptr == NULL) return(-1);
	    fprintf(fptr,"To: %s\n",name); /* add a To: headder line */
	    while(fgets(temp,255,in)!=NULL){
	      fputs(temp,fptr);
  	    }
  	    pclose(fptr);
	    flock(fileno(in),LOCK_UN);
	    fclose(in);
	    unlink(names[j]);
	  }
	} while(i-1 > POOLSIZE);
	return(1);
}

int process_latent()
{
	int	num,i;
	unsigned ctime, stime;
	FILE	*fptr,*out;
	char	*names[256],line[256],foo[80];

	num = file_list("latent*",names);
	for(i=0;i<num;i++) {
	  if((fptr = fopen(names[i],"r"))!=NULL) {
	    flock(fileno(fptr),LOCK_EX);
	    fgets(line,255,fptr);
	    sscanf(line,"%s %u",foo,&stime);
	    ctime = time(NULL);
	    if(ctime > stime) {
	      /* now open up a mail file and put the body there */
	      sprintf(foo,"mail");
	      if((out = tempfile(foo))!=NULL){
		while(fgets(line,255,fptr)!=NULL) fputs(line,out);
	        fclose(out);
	      }
	    flock(fileno(fptr),LOCK_UN);
	    fclose(fptr);
	    unlink(names[i]);
	    } /* passed time */
	  } /* if could open latent */
	} /* for */
}


int process_partial()
{
	int	num,i,j;
	unsigned ctime, stime;
	struct timeval timestamp;
	long int diff;
	FILE	*fptr,*out,*lockptr;
	char	*names[256],line[256],foo[80];

	mix_lock("pac",&lockptr);
	num = file_list("pac*",names);
	for(i=0;i<num;i++) {
	  if((fptr = fopen(names[i],"r"))!=NULL) {
	    fread(&j,1,1,fptr);
	    stime = j;
	    fread(&j,1,1,fptr);
	    stime += j * 256;
	    fread(&j,1,1,fptr);
	    stime += j * 256 * 256;
	    fread(&j,1,1,fptr);
	    stime += j * 256 * 256 * 256;

	    gettimeofday(&timestamp,0);
	    ctime = timestamp.tv_sec;

	    diff = ctime - (stime + PACKETEXP);
	    if( diff < 0) { /* if the packet is too old */
	      fclose(fptr);
	      unlink(names[i]);
	    } else {
	      fclose(fptr);
	    } /* passed expiration time */
	  } /* if could open packet */
	} /* for */
	mix_unlock("pac",lockptr);
}

int packetID_housekeeping()
{
        FILE    *fptr,*lockptr;
        char    line[256],ID[50];
	struct timeval timestamp;
        unsigned i,now,then;
	BUFFER	*buff;

	mix_lock(IDLOG,&lockptr);
	buff = new_buffer();
        gettimeofday(&timestamp,0);
        now = timestamp.tv_sec;
	if((fptr = open_mix_file(IDLOG,"r+")) == NULL) return(-1);
	
	while(fgets(line,255,fptr)!=NULL) {
          sscanf(line,"%s %u", ID, &then);
	  if((now-then) < IDEXP) 
		add_to_buffer(buff,line,strlen(line));
	}
	fclose(fptr);
	if((fptr = open_mix_file(IDLOG,"r+")) == NULL) return(-1);
	fwrite(buff->message,1,buff->length,fptr);
	fclose(fptr);
	free_buffer(buff);
	mix_unlock(IDLOG,lockptr);
}
