/*
 * mixmaster.h        1.1 4/30/95
 *
 *      (c) Copyright 1995 by Lance Cottrell. All right reserved.
 *      The author assumes no liability for damages resulting from the
 *      use of this software, even if the damage results from defects in
 *      this software. No warranty is expressed or implied.
 *
 *      This software is being distributed under the GNU Public Licence,
 *      see the file GNU.license for more details.
 *
 *                      - Lance Cottrell (loki@obscura.com) 4/23/95
 *
 */

#include <fcntl.h>
#include <string.h>

#include "global.h"
#include "rsaref.h"
#include "def.h"
#include "buffers.h"

#include <sys/time.h>
#include <unistd.h>


#ifndef PASSPHRASE
#define PASSPHRASE "foobar"
#define PACKETEXP 604800
#define IDEXP 604800
#define SPOOL "/home/bob/Remailer/Mix"
#endif


#define PACKETSIZE 10236 /* 10240 - 4 (length bytes) */
#define HEADERSIZE 512
#define INNERHEAD  328


#define UNIXBOX 1

#define FL_MESSAGE 1
#define FL_OLD     2
#define FL_NEW     4
#define FL_STATS   8



static	char	VERSION[] =  "2.0b11";
static  char    remailer_type[] = "Remailer-Type: Mixmaster ";
static  char    begin_remailer[]="-----BEGIN REMAILER MESSAGE-----\n";
static  char    end_remailer[]="-----END REMAILER MESSAGE-----\n";
static  char    two_n [] = "\n\n";
static  char    begin_armour[]="-----BEGIN PGP MESSAGE-----\nVersion: ";
static  char    end_armour[]="-----END PGP MESSAGE-----\n";
static  char    begin_signed[]="-----BEGIN PGP SIGNED MESSAGE-----\n\n";
static  char    begin_signature[]="\n-----BEGIN PGP SIGNATURE-----\nVersion: ";
static  char    end_signature[]="-----END PGP SIGNATURE-----\n";
static	char	begin_key[]="-----Begin Mix Key-----\n";
static	char	end_key[]="-----End Mix Key-----\n";



extern char 	mix_dir[];
extern char KEYFILE[];
extern char REMAILERADDR[];
extern char REMAILERNAME[];
extern char SHORTNAME[];
extern char COMPLAINTS[]; 
extern int POOLSIZE;
extern char REMAILERLIST[];
extern char IDLOG[];
extern char STATS[];
extern char SENDMAIL[];
extern char ABILITIES[];
extern char MAILtoNEWS[];
extern char TYPE1[];

enum message_type_enum {NONE, REMAIL, POST, RETURNADDRESS, PGP};
typedef enum message_type_enum message_type;

typedef struct {
	char	name[80];
	char	shortname[80];
	unsigned char	key_ID[16];
	char	version[80];
	unsigned char	IPaddress[16];
	int	reliability;
} REMAILER;

int file_list(char *search, char **names);
int process_pool();
int process_latent();
unsigned char our_randombyte();
R_RANDOM_STRUCT *rand_struct();
