/* REXX
   Program JOINMAIL 1.2
   REceives Header from Queue
   Looks for a '-----BEGIN PGP' line in STDIN
       and skips everything before
   Writes the rest from STDIN to the file named in the first argument
   By deleting the file it is made sure that nothing is sent out when there was a PGP error
*/
/* CopyRight Lueko Willms <lueko.willms@T-Online.de>
                          <L.WILLMS@LINK-F.rhein-main.de>
*/

arg OutMail DEBUG .

DEBUG = (strip(translate(DEBUG)) = 'DEBUG')
TRUE = 1

CR = '0D'x

If DEBUG then
  PARSE SOURCE BetrSyst Shell MyName


Erg = ''
Say
Call CHAROUT  ,'         Wait for / Warte auf ' Outmail

Zaehler = 0
DO UNTIL Erg = 'READY:'          /* Waiting indefinitely for exclusive WRITE access to OutMail */
  If (Zaehler // 10) = 0 Then
      Call CHAROUT ,CR||Zaehler
  Erg = STREAM(Outmail,'C','OPEN WRITE')
  Zaehler = Zaehler + 1
  If DEBUG Then
     Say MyName i'. Versuch: Ergebnis von OPEN WRITE von ' Outmail':' Erg
end /* do */
Say

Erg = STREAM(Outmail,'C','CLOSE')
'del ' Outmail
Erg = STREAM(Outmail,'C','OPEN WRITE')
Erg = LINEOUT(Outmail,,1)
If DEBUG Then
  Say MyName 'ERgebnis von RESET ' OUtmail ':' Erg

IF (DEBUG & QUEUED() = 0) Then
   ERg = LINEOUT(STDERR,'He! nix in der Warteschlange! Queue is empty!')

DO UNTIL QUEUED() = 0
   Erg = Lineout(Outmail,LINEIN('QUEUE:'))
End

Textline=''
DO UNTIL (ABBREV(Textline,'-----BEGIN PGP') | (LINES() = 0))
   Textline = LINEIN()
END /* DO skip lines before PGP output */
Erg = LINEOUT(Outmail,Textline)

Do WHILE LINES() > 0
   Erg = LINEOUT(Outmail,LINEIN())
END

Erg = STREAM(Outmail,'C','CLOSE')
If DEBUG Then
  Say MyName 'Ergebnis von CLOSE ' OUtmail ':' Erg

EXIT 
