/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: PGPOpenAdminPrefs.cp,v 1.1.8.1 1998/11/12 03:09:47 heller Exp $
____________________________________________________________________________*/

#include <TextUtils.h>

#include "PGPOpenPrefs.h"

#include "MacErrors.h"
#include "MacFiles.h"
#include "pgpClientPrefs.h"
#include "pgpAdminPrefs.h"
#include "pgpSDKPrefs.h"
#include "pgpFileSpec.h"
#include "CComboError.h"
#include "pgpClientErrors.h"
#include "pgpClientLib.h"

const ResID		kPrefsNameListID			=	14444;
const short		kAdminPrefsFilenameStrIndex	=	2;

/*____________________________________________________________________________
	Acts differently, depending on whether this is an administrator build
	or not.  If it's an admin build, then the admin prefs will be created
	if they don't exist.  If it's not an admin build, then they won't be
	created and a kPGPError_AdminPrefsNotFound error will be returned.
____________________________________________________________________________*/

	PGPError
PGPOpenAdminPrefs(
	PGPMemoryMgrRef	memoryMgr,
	PGPPrefRef		*prefRef)
{
#if PGP_BUSINESS_SECURITY	// [
	CComboError		err;
	FSSpec			fsSpec;
	PGPBoolean		created = FALSE;
	
	PGPValidatePtr( prefRef );
	*prefRef	= NULL;
	
	err.err = FindPGPPreferencesFolder(-1, &fsSpec.vRefNum, &fsSpec.parID);
	if ( err.IsntError() )
	{
		PGPBoolean	adminConfig;
		
		GetIndString( fsSpec.name, kPrefsNameListID,
				kAdminPrefsFilenameStrIndex);
		pgpAssert( fsSpec.name[0] != 0 );
		
		/* create it if it doesn't already exist */
		if ( ! FSpExists( &fsSpec ) &&
			IsntPGPError( err.pgpErr = PGPIsAdminConfigured( &adminConfig )))
		{
			if( !adminConfig )
			{
				// only an administrator build is allowed to create these
				err.err	= FSpCreate( &fsSpec,
						kPGPMacFileCreator_Keys, 'pref', smSystemScript );
				created = TRUE;
			}
			else
				err.pgpErr	= kPGPClientError_AdminPrefsNotFound;
		}
		
		if ( err.IsntError() )
		{
			PFLFileSpecRef	fsRef	= NULL;
		
			err.pgpErr	= PFLNewFileSpecFromFSSpec( memoryMgr, &fsSpec, &fsRef);
			if ( err.IsntError() )
			{
				err.pgpErr = PGPOpenPrefFile(fsRef, adminDefaults, 
								adminDefaultsSize, prefRef);

				PFLFreeFileSpec( fsRef );
			}
		}
	}
	
	return( err.ConvertToPGPError() );
#else
	memoryMgr;
	prefRef;
	pgpAssert(0);	// This function is *only* called in non-BS builds
	return kPGPError_FeatureNotAvailable;
#endif	// ] PGP_BUSINESS_SECURITY
}


