/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CSearchPanel.h,v 1.13.8.1 1998/11/12 03:08:13 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LView.h>
#include <LListener.h>
#include <LBroadcaster.h>
#include <LLittleArrows.h>

#include "pgpPubTypes.h"

class CGADurationEditField;
class LEditText;
class LPopupButton;

class CSearchPanel	:	public LView,
						public LListener,
						public LBroadcaster
{
public:
	enum { class_ID = 'sPan' };
								CSearchPanel(LStream *inStream);
								~CSearchPanel();
	void						FinishCreateSelf();
	void						ListenToMessage(MessageT	inMessage,
												void		*ioParam);
	PGPError					MakeFilter(PGPFilterRef *outFilter);
	
	void						AdjustCategory(Boolean	first);
private:
	void						AdjustOperatorMenu();
	void						AdjustDataFields();
	PGPError					KeyIDFilterFromKeySet(
											PGPKeySetRef	keySet,
											PGPFilterRef	*filter);
	
	LPopupButton				*mCategoryPopup,
								*mAlgorithmPopup,
								*mKeyPopup,
								*mOperatorPopup;
	LEditText					*mEditBox;
	LLittleArrows				*mLittleArrows;
	CGADurationEditField		*mDurationEdit;
	Int16						mNumCategories;
	
	Int32						mLastArrowValue;
	
	static Int16				sLastCategory;
	
	enum	{
				kCategoryPopup			= 'pCat',
				kOperatorPopup			= 'pOpe',
				kAlgorithmPopup			= 'pAlg',
				kLittleArrows			= 'lArr',
				kEditBox				= 'eTxt',
				kDurationEdit			= 'eDur',
				kKeyPopup				= 'pKey'
			};
	enum	{
				kSearchPanelStringListID		= 1014,
				kBadKeyIDErrorStringID			= 1,
				kNoSignerKeyExtantErrorStringID,
				kOperatorStringListID			= 1016
			};
};

