/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CFingerprintField.cp,v 1.7.8.1 1998/11/12 03:07:52 heller Exp $
____________________________________________________________________________*/

#include <Scrap.h>

#include <LDragAndDrop.h>
#include <LDragTask.h>
#include <UGAColorRamp.h>
#include <UDrawingState.h>
#include <UDrawingUtils.h>
#include <UTextTraits.h>
#include <PP_Messages.h>
#include <string.h>

#include "CFingerprintField.h"


	CFingerprintField *
CFingerprintField::CreateFromStream(
	LStream * inStream)
{
	return new CFingerprintField(inStream);
}

CFingerprintField::CFingerprintField()
{
}

CFingerprintField::CFingerprintField(
	const CFingerprintField & inOriginal)
	: CRecessedCaption(inOriginal)
{
}

CFingerprintField::CFingerprintField(
	LStream * inStream)
	: CRecessedCaption(inStream)
{
}

	Boolean
CFingerprintField::ObeyCommand(
	CommandT			inCommand,
	void *				ioParam)
{
	Boolean cmdHandled;
	if ((inCommand == cmd_Copy) && (IsTarget()))
	{
		::ZeroScrap();
		::PutScrap(mText[ 0 ], 'TEXT', &mText[ 1 ]);
		cmdHandled = true;
	}
	else if( inCommand == msg_TabSelect )
	{
		cmdHandled = TRUE;
	}
	else
	{
		cmdHandled = LCommander::ObeyCommand(inCommand, ioParam);
	}
	return cmdHandled;
}

	void
CFingerprintField::FindCommandStatus(
	CommandT			inCommand,
	Boolean &			outEnabled,
	Boolean &			outUsesMark,
	Char16 &			outMark,
	Str255				outName)
{
	if ((inCommand == cmd_Copy) && (IsTarget()))
	{
		outEnabled = true;
		outUsesMark = false;
	}
	else
	{
		LCommander::FindCommandStatus(inCommand, outEnabled, outUsesMark,
										outMark, outName);
	}
}

	void
CFingerprintField::FinishCreateSelf()
{
	CRecessedCaption::FinishCreateSelf();
}

	void
CFingerprintField::ClickSelf(
	const SMouseDownEvent & inMouseDown)
{
	CRecessedCaption::ClickSelf(inMouseDown);
	// clicking in a CFingerprintField makes it the Target.

	if (!IsTarget())
	{
		SwitchTarget(this);
	}
	
	if( LDropArea::DragAndDropIsPresent() )
	{
		if( WaitMouseMoved( inMouseDown.macEvent.where ) )
		{
			Rect				dragRect;
			StPortOriginState	saveState( GetMacPort() );
			
			SetOrigin( 0, 0 );
			
			CalcPortFrameRect( dragRect );
			
			LDragTask	drag( inMouseDown.macEvent, dragRect,
								1, 'TEXT', &mText[1], mText[0], 0 );
		}
	}
}

	void
CFingerprintField::AdjustCursorSelf(
	Point				inPortPt,
	const EventRecord &	inMacEvent)
{
	CRecessedCaption::AdjustCursorSelf(inPortPt, inMacEvent);
}

	void
CFingerprintField::BeTarget()
{
	LCommander::BeTarget();
	Refresh();	
}

	void
CFingerprintField::DontBeTarget()
{
	LCommander::DontBeTarget();
	Refresh();
}

	void
CFingerprintField::DrawSelf()
{
	// background color is white for all drawing in this pane
	StColorPenState	theColorPenState;
	::RGBBackColor (&(UGAColorRamp::GetWhiteColor()));
	CRecessedCaption::DrawSelf();
}

	void
CFingerprintField::DrawBackground(
	const Rect & localFrame)
{
	Rect frameCopy = localFrame;
	::InsetRect(&frameCopy, 2, 2);
	::EraseRect(&frameCopy);
}

	void
CFingerprintField::DrawBox(
	const Rect & localFrame)
{
	StColorPenState	theColorPenState;
	Rect frameCopy = localFrame;
	::PenNormal();

	/*// draw the surrounding shadow if on a color screen
	{
		StDeviceLoop	theLoop (localFrame);

		Int16				depth;
		while (theLoop.NextDepth (depth)) 
		{
			if (depth >= 8)	// 256 colors
			{
				DrawGrayBox(localFrame);
			}
		}
	}
	
	// always draw the black box regardless of depth
	::PenNormal();
	::InsetRect(&frameCopy, 1, 1);
	::RGBForeColor (&(UGAColorRamp::GetBlackColor()));
	::FrameRect(&frameCopy);*/
}

	void
CFingerprintField::DrawText(
	const Rect & localFrame)
{
	Rect frameCopy = localFrame;
	// three pixels around text are shadow, black box, white box.
	::InsetRect(&frameCopy, 3, 3);
	
	frameCopy.top--;	// needed to match spec appearance

	{
		StColorPenState	theColorPenState;	//	needed to restore before
											//	target-hiliting below
		Int16 just = UTextTraits::SetPortTextTraits(mTxtrID);
		
		RGBColor	textColor;
		::GetForeColor(&textColor);
		
		ApplyForeAndBackColors();
		::RGBForeColor(&textColor);

		UTextDrawing::DrawWithJustification((Ptr)&mText[1], mText[0],
											frameCopy, just);
	}
	
	if (IsTarget())
	{
		UDrawingUtils::SetHiliteModeOn();
		::InvertRect(&frameCopy);
	}
}
