/*____________________________________________________________________________
	CDecryptTranslator.cp
	
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CDecryptTranslator.cp,v 1.24.8.1 1998/11/12 03:06:30 heller Exp $
____________________________________________________________________________*/

#include <Script.h>
#include <TextUtils.h>
#include <string.h>

#include "pgpErrors.h"
#include "pgpMacMemory.h"
#include "MacFiles.h"
#include "CDecryptTranslator.h"
#include "TranslatorIDs.h"
#include "MyMIMEUtils.h"
#include "PluginLibUtils.h"
#include "TranslatorUtils.h"
#include "TranslatorStrings.h"
#include "PassphraseCache.h"
#include "SignatureStatusMessage.h"
#include "PGPSharedEncryptDecrypt.h"


	PluginError
CDecryptTranslator::CanTranslate(
	long				transContext,
	emsMIMETypeHandle	inMimeTypeHandle,
	const FSSpec *		inFSp,
	StringHandle**		addressesHandle,
	long *				aprox_len,
	StringHandle *		errorMessage,
	long *				result_code)
{
	PluginError	err	= EMSR_CANT_TRANS;
	
	(void)inFSp;
	(void)addressesHandle;
	(void)aprox_len;
	(void)result_code;
	InitPtrToNil( errorMessage );
	
	err	= CanTranslateMIMEType( transContext, inMimeTypeHandle,
			"\pmultipart", "\pencrypted", "\papplication/pgp-encrypted");
	

	return( err );
}


	PluginError
CDecryptTranslator::TranslateFile(
	long				transContext,
	ConstemsMIMETypeHandle	inMIMETypeHandle,
	const FSSpec *		inSpec,
	StringHandle**		addressesHandle,
	emsMIMETypeHandle*	outMIMETypeHandlePtr,
	const FSSpec *		outSpec,
	StringHandle*		returnedMessage,
	StringHandle*		errorMessage,
	long *				resultCode)
{
	CComboError		err;
	FInfo			fInfo;

	(void)transContext;
	(void)inMIMETypeHandle;
	(void)addressesHandle;
	
	DecryptVerifyEventHandlerData	eventData(this);
	
	InitPtrToNil( outMIMETypeHandlePtr );
	InitPtrToNil( returnedMessage );
	InitPtrToNil( errorMessage );
	if ( IsntNull( resultCode ) )
		*resultCode	= EMSR_OK;
	
	FSpGetFInfo( outSpec, &fInfo );
	(void)FSpDelete( outSpec );
	
	err.pgpErr	= LoadDefaultKeySet( FALSE );
	if ( err.IsntError() )
	{
		PGPContextRef	c	= mContext;
		PGPKeySetRef	newKeysSet;
		
		err.pgpErr = PGPNewKeySet( c, &newKeysSet );
		if( err.IsntError() )
		{	
			err.pgpErr	= PGPDecode( c,
				PGPOInputFileFSSpec( c, inSpec ),
				PGPOOutputFileFSSpec( c, outSpec ),
				PGPOEventHandler( c, sPGPDecodeEventHandler, &eventData ),
				PGPOSendNullEvents( c, TRUE ),
				PGPOKeySetRef( c, mKeySet ),
				PGPOImportKeysTo( c, newKeysSet ),
				PGPOLastOption(c)
				);
			if ( err.IsError() )
			{
				gDecryptionPassphraseCache->Forget();
			}
			
			if( err.IsntError() &&
				PGPKeySetRefIsValid( eventData.mClientHandlerData.newKeySet ) )
			{
				err.pgpErr = PGPAddKeys(eventData.mClientHandlerData.newKeySet,
									newKeysSet );
				if( err.IsntError() )
				{
					err.pgpErr = PGPCommitKeyRingChanges( newKeysSet );
				}
			}

			if( err.IsntError() )
			{
				PGPUInt32	numNewKeys;
				PGPError	tempErr;
				
				tempErr = PGPCountKeys( newKeysSet, &numNewKeys );
				if( IsntPGPError( tempErr ) && numNewKeys > 0 )
				{
					// Offer to import the keys
					PGPKeySetRef	importSet;
					char			prompt[256];
					
					GetIndCString( prompt, kTranslatorStringsRID,
							kSelectiveImportAfterSendPromptStrIndex );
					
					tempErr = PGPSelectKeysDialog( c,
									kPGPSelectKeysImportVariation, prompt,
									newKeysSet, mKeySet, &importSet );
					
					if( IsntPGPError( tempErr ) )
					{
						(void) PGPSharedAddKeysToDefaultKeyring( importSet );
						(void) PGPFreeKeySet( importSet );
					}
				}
			}

			PGPFreeKeySet( newKeysSet );
		}
	}
	
	// we deleted the resource fork.
	// This makes Eudora unhappy.  Recreate one.
	(void)FSpCreateResFile( outSpec,
		fInfo.fdCreator, fInfo.fdType, smSystemScript );

	DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), inSpec,
				"\pDecryptIn" );
	DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), outSpec,
				"\pDecryptOut" );
	
	if ( err.IsntError() )
	{
		pgpAssert( IsntNull( resultCode ) );
		pgpAssert( IsntNull( returnedMessage ) );
		
		if ( ! eventData.mHaveSignatureData )
		{
			*resultCode	= EMSR_OK;
		}
		else
		{
			PGPEventSignatureData const *	sigData;
			
			sigData	= &eventData.mSignatureData.sigData;
			*resultCode	= SignatureDataToEudoraResult( sigData );

			if ( IsntNull( returnedMessage ) )
			{
				Str255		statusMessage;
				
				GetSignatureStatusMessage( &eventData.mSignatureData,
					statusMessage );
				*returnedMessage	= NewString( statusMessage );
			}
		}
	}
	
	// parse the output to figure out what the MIME type is
	pgpAssertAddrValid( outMIMETypeHandlePtr, emsMIMETypeHandle );
	ParseFileForMIMEType( outSpec, outMIMETypeHandlePtr );
	
	
	if ( err.IsntError() )
	{
		RememberDecryptionPassBuffer( eventData.mClientHandlerData.passBuffer,
				eventData.mClientHandlerData.decryptionKey );
	}
	else
	{
		gDecryptionPassphraseCache->Forget();
		ReportError( err );
	}
		
	
	return( CComboErrorToEudoraError( err ) );
}











