/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: PGPDiskCastCFB.cp,v 1.3.8.1 1998/11/12 03:05:46 heller Exp $
____________________________________________________________________________*/

#include <string.h>
#include "pgpMem.h"
#include "PGPDiskCASTCFB.h"



	void
CASTCFB_Init(
	CASTCFBContext *	context,
	const byte *		keyToExpand)
{
	pgpAssertAddrValid( context, CASTCFBContext );
	pgpAssertAddrValid( keyToExpand, byte );
	
	CAST5schedule( context->expandedKey.keyWords, keyToExpand);
}



void CASTCFB_Destroy(CASTCFBContext *context)
{
	pgpAssertAddrValid( context, CASTCFBContext );
	
	pgpClearMemory( context, sizeof( *context ) );
}


// Note this version of CFB for CAST is optimized for
// blocks that are multiples of 8 bytes only.  It does not
// work on unevenly sized blocks.

	void
CASTCFB_Encrypt(
	const CASTCFBContext	*context,
	const UInt32 *			iv,
	const UInt32 *			src,
	UInt32 *				dest,
	UInt32					byteCount)
{
	const UInt32 *	src32	= (const UInt32 *)src;
	UInt32 *		dest32	= (UInt32 *)dest;
	UInt32			num8ByteChunks;
	UInt32			tempIV[ 2 ];
	
	// note: these UInt32 ptrs may actually be misaligned
	pgpAssert( IsntNull( src ) );
	pgpAssert( IsntNull( dest ) );
	
	pgpAssertAddrValid( context, CASTCFBContext );
	pgpAssert( ( byteCount % 8 ) == 0 );
	pgpAssert( sizeof( iv[ 0 ]  ) == sizeof( UInt32 ) );
	
	tempIV[ 0 ]	= iv[ 0 ];
	tempIV[ 1 ]	= iv[ 1 ];

	num8ByteChunks	= byteCount / 8;
	while ( num8ByteChunks-- != 0 )
	{
		CAST5encrypt( (const byte *)tempIV, (byte *)tempIV,
				context->expandedKey.keyWords );
		
		tempIV[ 0 ]		^=	*src32++;
		tempIV[ 1 ]		^=	*src32++;
		*dest32++		=	tempIV[ 0 ];
		*dest32++		=	tempIV[ 1 ];
	}
}



	void
CASTCFB_Decrypt(
	const CASTCFBContext *	context,
	const UInt32 *			iv,
	const UInt32 *			src,
	UInt32 *				dest,
	UInt32					byteCount)
{
	const UInt32 *	src32;
	UInt32 *		dest32;
	UInt32			blocks;
	UInt32			tempIV[ 2 ];
	
	// note: these UInt32 ptrs may actually be misaligned
	pgpAssert( IsntNull( src ) );
	pgpAssert( IsntNull( dest ) );
	
	pgpAssertAddrValid( context, CASTCFBContext );
	pgpAssert( ( byteCount % 8 ) == 0 );
	pgpAssert( sizeof( iv[ 0 ]  ) == sizeof( UInt32 ) );
	
	src32	= src;
	dest32	= (UInt32 *)dest;
	
	tempIV[ 0 ]	= iv[ 0 ];
	tempIV[ 1 ]	= iv[ 1 ];

	for( blocks = byteCount / 8 ; blocks; blocks--)
	{
		UInt32	niv32_1;	// these variables are required to
		UInt32	niv32_2;	// allow src & dest to overlap
		
		// yes, call CAST5encrypt, not CAST5decrypt
		CAST5encrypt( (const byte *)tempIV, (byte *)tempIV,
				context->expandedKey.keyWords);
		
		niv32_1			= *src32++;
		niv32_2			= *src32++;
		*dest32++		= tempIV[ 0 ] ^ niv32_1;
		*dest32++		= tempIV[ 1 ] ^ niv32_2;
		tempIV[ 0 ]		= niv32_1;
		tempIV[ 1 ]		= niv32_2;
	}
}









