/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: PGPDiskPreferences.h,v 1.2.8.1 1998/11/12 03:05:23 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "DriverPrefs.h"

const OSType	kPrefsFileType	= 'Pref';


#pragma options align=mac68k

typedef struct PGPDiskPrefs
{
	OSType		magic;
	ushort		version;
	
	PGPDiskDriverPrefs	driverPrefs;

	UInt32		newDiskDefaultSize;
	Boolean		newDiskDefaultIsMB;
	Boolean		reserved;
	Point		mainWindowLocation;
	UInt32		lastSplashShowTime;
	UInt32		reservedLongs[10];

} PGPDiskPrefs;

#pragma options align=reset

OSStatus	GetPrefsFileSpec(FSSpec *fileSpec);
void		ReadPreferences(PGPDiskPrefs *prefs);
OSStatus	SendPreferencesToAllDrivers(const PGPDiskDriverPrefs *driverPrefs);
void		WritePreferences(const PGPDiskPrefs *prefs);

extern	PGPDiskPrefs gPGPDiskPrefs;

