import java.net.*;
import java.io.*;
import java.awt.*;

public class PGPKeyClient implements Runnable {
static final int INIT = 0;
static final int WAITING = 1;
static final int GOTKEY = 2;
static final int ERROR = 3;
protected int state;

StringBuffer keydata;
PGPPublicKey pk;

String urlname;
String name;

Thread t;

//PGPKCFrame fr;
TextComponent tStat;

public PGPKeyClient(String urlname, TextComponent tStat) {
    this.urlname = urlname;
    this.tStat = tStat;
    state = INIT;
}

public boolean gotKey() {
    return (state==GOTKEY);
}

public boolean ready() {
    return (state==INIT) || (state==GOTKEY) || (state==ERROR);
}

public byte[] toByteArray() {
    String ks = keydata.toString();
    int len = ks.length();
    byte b[] = new byte[len];
    ks.getBytes(0,len,b,0);
    return b;
}

public PGPPublicKey toPGPKey()
{
    return pk;
}

public void getKey(String name)
{
    t = new Thread(this);
    keydata = new StringBuffer();
    this.name = name.replace(' ', '+'); // spaces to + for CGI search
    state = WAITING;
    t.start();
}

public void run()
{
//    dispose();
//    fr = new PGPKCFrame("Key Fetch Status");
//    fr.resize(fr.preferredSize());
//    fr.show();
    tStat.setText ("Connecting to key server");
    InputStream in = null;
    try  {
        in = new URL(urlname+"?op=get&search="+name).openStream();
    } catch (Exception e) {
        tStat.setText("Unable to open URL: "+e.toString());
        state = ERROR;
        return;
    }
    tStat.setText("Connected, requesting key data");
    DataInputStream din = new DataInputStream(in);
    boolean firstline = true;
    for ( ; ; ) {
        String l = null;
        try {
            l = din.readLine();
        } catch (IOException e) {
            state = ERROR;
            break;
        }
        if (firstline) {
            tStat.setText("Receiving key data");
            firstline = false;
        }
        if (l==null)
            break;
        // Remove html tags
        int llen = l.length();
//System.out.println("Line: "+l);
        StringBuffer lb = new StringBuffer(llen);
        for (int i=0; ; ) {
            int nexttag = l.indexOf('<', i);
            nexttag = (nexttag<0)?llen:nexttag;
            int nextlt = l.indexOf("&lt;", i);
            nextlt = (nextlt<0)?llen:nextlt;
            int nexti = Math.min(nexttag, nextlt);
            lb.append(l.substring(i, nexti));
            if (nexti==llen)
                break;
            i = nexti;
            if (nextlt < nexttag) {
                lb.append ('<');
                i += 4;
            } else {
                i = l.indexOf('>', i) + 1;
                if (i==0)
                    break;
            }
        }
        keydata.append(lb.toString());
        keydata.append("\n");
    }
    tStat.setText("Got data from server");
    pk = null;
    try {
        DataInputStream dis = new DataInputStream (
                new PGPBase64InputStream(
                    new ByteArrayInputStream(toByteArray())));
        pk = new PGPPublicKey(dis.read(), dis);
        dis.close();
    } catch (IOException ex) {
        tStat.setText("No valid key found from server");
        state = ERROR;
        return;
    }
    if (pk.numids > 0) {
        tStat.setText("Got key for: "+pk.userids[0]);
    } else {
        tStat.setText("Key from server is missing userid");
        state = ERROR;
        return;
    }
    state = GOTKEY;
}

public void join()
{
    while (t.isAlive()) {
        try {t.join(100);} catch (InterruptedException e) {}
    }
}

/*
public void dispose()
{
    if (fr!=null)
        fr.dispose();
}
*/

}

/*
class PGPKCFrame extends Frame {
static final Dimension MYSIZE = new Dimension(220,80);
String text;

public PGPKCFrame(String title)
{
    super(title);
}

public void setText(String s)
{
    text = s;
    Dimension size = size();
    int textwidth = this.getGraphics().getFontMetrics().stringWidth(text);
    if (textwidth+20 > size.width)
        resize(textwidth+20, size.height);
    else
        repaint();
}

public void paint(Graphics g)
{
    FontMetrics fm = g.getFontMetrics();
    int width = fm.stringWidth(text);
    int height = fm.getHeight() + fm.getLeading();
    Dimension size = this.size();
    g.drawString (text, (size.width-width)/2 - 5, (size.height-height)/2);
}

public boolean handleEvent (Event e)
{
    if (e.id==e.WINDOW_DESTROY)
        this.dispose();
    return super.handleEvent(e);
}

public Dimension minimumSize()
{
    return MYSIZE;
}

public Dimension preferredSize()
{
    return MYSIZE;
}



}

*/
