
import java.io.*;

public class PGPCTB {

public static int PKE = 1;               // public key encrypted packet
public static int SKE = 2;               // secret key encrypted (signature)
public static int SKC = 5;               // secret key certificate
public static int PKC = 6;               // public key certificate
public static int COMP = 8;              // compressed data
public static int CKE = 9;               // conventional key encrypted
public static int LIT = 11;              // literal plaintext data
public static int KT = 12;               // keyring trust packet
public static int UID = 13;              // user id
public static int COMM = 14;             // comment
public static int ERROR = -1;            // invalid CTB

public static int ctbType (int ctb)
{
    if ((ctb & 0xc0) != 0x80)
        return ERROR;
    return (ctb>>2) & 0xf;
}

public static int ctblenlen (int ctb)
{
    switch (ctb & 3) {
        case 0: return 1;
        case 1: return 2;
        case 2: return 4;
    }
    return 0;
}

public static String ctbString (int ctb)
{
    int ctbt = ctbType(ctb);
    if (ctbt==PKE)
        return "Public key encrypted packet";
    if (ctbt==SKE)
        return "Signature packet";
    if (ctbt==PKC)
        return "Public key packet";
    if (ctbt==SKC)
        return "Secret key packet";
    if (ctbt==CKE)
        return "Conventional key encrypted packet";
    if (ctbt==LIT)
        return "Literal plaintext packet";
    if (ctbt==COMP)
        return "Compressed packet";
    if (ctbt==UID)
        return "User ID packet";
    if (ctbt==COMM)
        return "Comment packet";
    if (ctbt==KT)
        return "Key Trust byte";
    return ("Bad CTB value: 0x"+Integer.toString(ctb, 16));
}

public static int ctbLength(int ctb, InputStream is) throws IOException
{
    int cl = ctblenlen(ctb);
    if (cl == 0)
        return -1;
    byte b[] = new byte[cl];
    is.read(b);
    int l = 0;
    for (int i=0; i<cl; ++i)
        l = (l<<8) | (b[i]&0xff);
    return l;
}

public static void writectbLength(int ctbtype, int length, OutputStream os)
                                throws IOException
{
    int ctb = (ctbtype<<2) | 0x80;
    if (length < 256) {
        os.write (ctb | 0);
        os.write (length);
    } else if (length < 65535) {
        os.write (ctb | 1);
        os.write((length>>8) & 0xff);
        os.write(length & 0xff);
    } else {
        os.write (ctb | 2);
        os.write ((length>>24) & 0xff);
        os.write((length>>16) & 0xff);
        os.write ((length>>8) & 0xff);
        os.write (length & 0xff);
    }
}



}
