/*
 * Copyright (c) 1995, 1996, 1997, 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <xfs/xfs_locl.h>

RCSID("$Id: xfs_load.c,v 1.16 1999/03/02 23:50:08 mackan Exp $");

#define XFS_MAJOR 103
#include <xfs/xfs_message.h>
#include <xfs/xfs_dev.h>
#include <xfs/xfs_cache.h>
#include <xfs/xfs_syscalls.h>

#ifndef HAVE_READ_SUPER_FOUR_ARGS
extern struct super_block * xfs_read_super (struct super_block * sb,
					    void * data,
					    int silent);
#else
extern struct super_block * xfs_read_super (struct super_block * sb,
					    void * data,
					    int silent,
					    struct dentry *dir_d);
#endif

extern struct file_operations xfs_fops;

static struct file_system_type xfs_fs_type = {
#ifndef LINUX2_1
    xfs_read_super, "xfs", 0, NULL
#else
    "xfs", 0, xfs_read_super, NULL
#endif /* LINUX2_1 */
};

#ifdef DEVFS_SUPPORT
static devfs_handle_t xfs_devfs_handle;
#endif

int init_xfs_fs(void)
{
    XFSDEB(XDEBVFOPS, ("init_xfs_fs\n"));
    XFSDEB(XDEBVFOPS, ("xfs_fs_type: %p\n",&xfs_fs_type));
    return register_filesystem(&xfs_fs_type);
    xfs[0].status = 0;
    XFSDEB(XDEBVFOPS, ("init_xfs_fs exit\n"));
}

int init_module(void)
{
    int status;
    
    XFSDEB(XDEBVFOPS, ("init_module\n"));
#ifndef LINUX2_1
    XFSDEB(XDEBVFOPS, ("offset xfs_cache_init: %p",xfs_cache_init));
    XFSDEB(XDEBVFOPS, ("offset xfs_cache_lookup: %p",xfs_cache_lookup));
    XFSDEB(XDEBVFOPS, ("offset xfs_cache_add: %p",xfs_cache_add));
    XFSDEB(XDEBVFOPS, ("offset xfs_cache_delete: %p",xfs_cache_delete));
    xfs_cache_init();
#endif /* LINUX2_1 */
    install_afs_syscall();
#ifndef LINUX2_1
    if ((status = init_xfs_fs()) == 0)
	register_symtab(0);
    else {
	XFSDEB(XDEBVFOPS, ("init_module: init_xfs_fs failed\n"));
	return status;
    }
#else
    if ((status = init_xfs_fs()) != 0) {
	XFSDEB(XDEBVFOPS, ("init_module: init_xfs_fs failed\n"));
	return status;
    }
#endif /* LINUX2_1 */
#ifdef DEVFS_SUPPORT
    xfs_devfs_handle = devfs_register("xfs0", 0, DEVFS_FL_NONE, XFS_MAJOR, 0,
				      S_IRUSR | S_IWUSR | S_IFCHR,
				      0, 0, &xfs_fops, NULL);
    if (xfs_devfs_handle == NULL) {
	XFSDEB(XDEBVFOPS, ("xfs: unable to get major %d\n", XFS_MAJOR));
	return -EIO;
    }
#else
    if (register_chrdev(XFS_MAJOR,"xfs",&xfs_fops)) {
	XFSDEB(XDEBVFOPS, ("xfs: unable to get major %d\n", XFS_MAJOR));
	return -EIO;
    }
#endif
    xfs_init_device();
    XFSDEB(XDEBVFOPS, ("init_module exit\n"));
    return status;
}

void cleanup_module(void)
{
    unregister_filesystem(&xfs_fs_type);
#ifdef DEVFS_SUPPORT
    devfs_unregister(xfs_devfs_handle);
#else
    unregister_chrdev(XFS_MAJOR,"xfs");
#endif
    restore_afs_syscall();
}

