/*
This code is copyright (C) 1998 Robert O'Callahan.
This code is free for non-commercial use. Modification in all forms is permitted.
This license continues to apply to any modified versions. This license text must be
reproduced and distributed with any modified versions.
As a matter of courtesy I (Robert O'Callahan) would like to be informed of
any potentially useful modifications.
*/

#ifndef __HOSTS_H
#define __HOSTS_H

typedef struct {
  char FAR * prefetched_hostname;
  int key_bits;
  /* The key exponent and modulus, in SSH mp_int format */
  unsigned char FAR * key_exp;
  unsigned char FAR * key_mod;

  int file_num;
  char FAR * FAR * file_names;
  int file_data_index;
  char FAR * file_data;

  HWND hosts_dialog;
} HOSTSState;

void HOSTS_init(struct _TInstVar FAR * pvar);
void HOSTS_prefetch_host_key(struct _TInstVar FAR * pvar, char FAR * hostname);
int HOSTS_check_host_key(struct _TInstVar FAR * pvar, char FAR * hostname,
                         int bits, unsigned char FAR * exp, unsigned char FAR * mod);
void HOSTS_do_unknown_host_dialog(HWND wnd, struct _TInstVar FAR * pvar);
void HOSTS_do_different_host_dialog(HWND wnd, struct _TInstVar FAR * pvar);
void HOSTS_notify_disconnecting(struct _TInstVar FAR * pvar);
void HOSTS_end(struct _TInstVar FAR * pvar);

#endif
