/*
This code is copyright (C) 1998 Robert O'Callahan.
This code is free for non-commercial use. Modification in all forms is permitted.
This license continues to apply to any modified versions. This license text must be
reproduced and distributed with any modified versions.
As a matter of courtesy I (Robert O'Callahan) would like to be informed of
any potentially useful modifications.
*/

#ifndef __CRYPT_H
#define __CRYPT_H

#include "rsa.h"
#include "des.h"
#include "idea.h"
#include "rc4.h"
#include "blowfish.h"

#define SESSION_KEY_LENGTH 32
#define RSA_CHALLENGE_LENGTH 32

typedef struct {
  des_key_schedule k1;
  des_key_schedule k2;
  des_key_schedule k3;
  des_cblock ivec1;
  des_cblock ivec2;
  des_cblock ivec3;
} Cipher3DESState;

typedef struct {
  IDEA_KEY_SCHEDULE k;
  unsigned char ivec[8];
} CipherIDEAState;

typedef struct {
  des_key_schedule k;
  des_cblock ivec;
} CipherDESState;

typedef struct {
  RC4_KEY k;
} CipherRC4State;

typedef struct {
  BF_KEY k;
  unsigned char ivec[8];
} CipherBlowfishState;

typedef struct {
  void (* encrypt)(struct _TInstVar FAR * pvar, unsigned char FAR * buf, int bytes);
  void (* decrypt)(struct _TInstVar FAR * pvar, unsigned char FAR * buf, int bytes);
  int supported_ciphers;
  int cipher;
  RSA FAR * server_key;
  RSA FAR * host_key;
  char cookie[8];
  char session_key[SESSION_KEY_LENGTH];
  union {
    Cipher3DESState c3DES;
    CipherIDEAState cIDEA;
    CipherDESState cDES;
    CipherRC4State cRC4;
    CipherBlowfishState cBlowfish;
  } enc;
  union {
    Cipher3DESState c3DES;
    CipherIDEAState cIDEA;
    CipherDESState cDES;
    CipherRC4State cRC4;
    CipherBlowfishState cBlowfish;
  } dec;
} CRYPTState;

void CRYPT_init(struct _TInstVar FAR * pvar);
/* this function is called during 'slack time' while we wait for a response
   from the server. Therefore we have some time available to do some
   moderately expensive computations. */
void CRYPT_initialize_random_numbers(struct _TInstVar FAR * pvar);
void CRYPT_set_random_data(struct _TInstVar FAR * pvar, unsigned char FAR * buf, int bytes);
int CRYPT_set_cookie(struct _TInstVar FAR * pvar, unsigned char FAR * cookie);
int CRYPT_set_server_key(struct _TInstVar FAR * pvar,
                         int bits, unsigned char FAR * exp, unsigned char FAR * mod);
int CRYPT_set_host_key(struct _TInstVar FAR * pvar,
                       int bits, unsigned char FAR * exp, unsigned char FAR * mod);
int CRYPT_set_supported_ciphers(struct _TInstVar FAR * pvar, int ciphers);
int CRYPT_choose_cipher(struct _TInstVar FAR * pvar);
int CRYPT_get_encrypted_session_key_len(struct _TInstVar FAR * pvar);
int CRYPT_choose_session_key(struct _TInstVar FAR * pvar, unsigned char FAR * encrypted_key_buf);
int CRYPT_start_encryption(struct _TInstVar FAR * pvar);
int CRYPT_generate_RSA_challenge_response(struct _TInstVar FAR * pvar, unsigned char FAR * challenge,
                                           int challenge_len, unsigned char FAR * response);
void CRYPT_get_cipher_info(struct _TInstVar FAR * pvar, char FAR * dest, int len);
void CRYPT_get_server_key_info(struct _TInstVar FAR * pvar, char FAR * dest, int len);
void CRYPT_end(struct _TInstVar FAR * pvar);

int CRYPT_passphrase_decrypt(int cipher, char FAR * passphrase, char FAR * buf, int len);

#define CRYPT_encrypt(pvar, buf, bytes) \
    ((pvar)->crypt_state.encrypt((pvar), (buf), (bytes)))
#define CRYPT_decrypt(pvar, buf, bytes) \
    ((pvar)->crypt_state.decrypt((pvar), (buf), (bytes)))
#define CRYPT_get_cookie(pvar) ((pvar)->crypt_state.cookie)

#endif
