/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident	"@(#)print_cert.C	1.11 96/10/03 Sun Microsystems"

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <iostream.h>

#include <Bstream.h>
#include <Bigint.h>
#include <SkipCert.h>

void usage(char *argv){
	fprintf(stderr,
		"%s [-V] [-t type] certificate-file-name\n", argv);
	exit(1);
}
	
extern char *optarg;
extern int  optind;

main(int argc, char *argv[])
{
	int c;
	SkipCert *cert;
	Bstream x;
	int type = SKIP_CERT_X509;
	int mach = 0;

	while ((c = getopt(argc, argv, "Vt:")) != EOF) 
	switch(c) {
		case 't':
			type=atoi(optarg);
			if (type == 0)
				type=Certname_to_num(optarg);
			if (type == 0){
				fprintf(stderr,
				"unsupported certificate type\n");
				exit(1);
			}
			break;
		case 'V':
			mach = 1;
			break;
		default:
			usage(argv[0]);
	}
	if (optind >= argc) 
		usage(argv[0]);
	x=File_to_Bstr(argv[optind]);
	if (x.getlength() == 0) {
		fprintf(stderr,
			"Certificate %s not found\n",
			argv[optind]);
		exit(1);
	}
	if (SkipCert::decode(type, x, cert)) {
		fprintf(stderr, "can't decode certificate\n");
		exit(1);
	}
	if (mach)
		cert->machprint();
	else
		cert->print();
}
