#ifndef GABA_DEFINE
struct backend_command
{
  struct command super;
  struct io_backend *backend;
};
extern struct lsh_class backend_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_backend_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct backend_command *i = (struct backend_command *) o;
  mark((struct lsh_object *) i->backend);
}

struct lsh_class backend_command_class =
{ STATIC_HEADER,
  &command_class, "backend_command", sizeof(struct backend_command),
  do_backend_command_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct listen_command_callback
{
  struct fd_listen_callback super;
  struct io_backend *backend;
  struct command_continuation *c;
  struct exception_handler *e;
};
extern struct lsh_class listen_command_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_listen_command_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct listen_command_callback *i = (struct listen_command_callback *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->c);
  mark((struct lsh_object *) i->e);
}

struct lsh_class listen_command_callback_class =
{ STATIC_HEADER,
  &fd_listen_callback_class, "listen_command_callback", sizeof(struct listen_command_callback),
  do_listen_command_callback_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct listen_connection
{
  struct command super;
  struct command *callback;
  struct io_backend *backend;
};
extern struct lsh_class listen_connection_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_listen_connection_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct listen_connection *i = (struct listen_connection *) o;
  mark((struct lsh_object *) i->callback);
  mark((struct lsh_object *) i->backend);
}

struct lsh_class listen_connection_class =
{ STATIC_HEADER,
  &command_class, "listen_connection", sizeof(struct listen_connection),
  do_listen_connection_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct connect_command_callback
{
  struct fd_callback super;
  struct io_backend *backend;
  struct command_continuation *c;
  struct exception_handler *e;
};
extern struct lsh_class connect_command_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_connect_command_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connect_command_callback *i = (struct connect_command_callback *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->c);
  mark((struct lsh_object *) i->e);
}

struct lsh_class connect_command_callback_class =
{ STATIC_HEADER,
  &fd_callback_class, "connect_command_callback", sizeof(struct connect_command_callback),
  do_connect_command_callback_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct connect_port
{
  struct command super;
  struct io_backend *backend;
  struct address_info *target;
};
extern struct lsh_class connect_port_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_connect_port_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connect_port *i = (struct connect_port *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->target);
}

struct lsh_class connect_port_class =
{ STATIC_HEADER,
  &command_class, "connect_port", sizeof(struct connect_port),
  do_connect_port_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct simple_io_command
{
  struct command super;
  struct io_backend *backend;
  struct resource_list *resources;
};
extern struct lsh_class simple_io_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_simple_io_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct simple_io_command *i = (struct simple_io_command *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->resources);
}

struct lsh_class simple_io_command_class =
{ STATIC_HEADER,
  &command_class, "simple_io_command", sizeof(struct simple_io_command),
  do_simple_io_command_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct connect_connection
{
  struct command super;
  struct io_backend *backend;
};
extern struct lsh_class connect_connection_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_connect_connection_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connect_connection *i = (struct connect_connection *) o;
  mark((struct lsh_object *) i->backend);
}

struct lsh_class connect_connection_class =
{ STATIC_HEADER,
  &command_class, "connect_connection", sizeof(struct connect_connection),
  do_connect_connection_mark,
  NULL
};
#endif /* !GABA_DECLARE */

