#ifndef GABA_DEFINE
struct keyexchange_algorithm
{
  struct lsh_object super;
  void (*(init))(struct keyexchange_algorithm *self, struct ssh_connection *connection, int hostkey_algorithm_atom, struct signature_algorithm *hostkey_algorithm, struct object_list *algorithms);
};
extern struct lsh_class keyexchange_algorithm_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class keyexchange_algorithm_class =
{ STATIC_HEADER,
  0, "keyexchange_algorithm", sizeof(struct keyexchange_algorithm),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct kexinit
{
  struct lsh_object super;
  UINT8 ((cookie)[16]);
  struct int_list *kex_algorithms;
  struct int_list *server_hostkey_algorithms;
  struct int_list *((parameters)[KEX_PARAMETERS]);
  struct int_list *languages_client_to_server;
  struct int_list *languages_server_to_client;
  int first_kex_packet_follows;
  struct lsh_string *first_kex_packet;
};
extern struct lsh_class kexinit_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_kexinit_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct kexinit *i = (struct kexinit *) o;
  mark((struct lsh_object *) i->kex_algorithms);
  mark((struct lsh_object *) i->server_hostkey_algorithms);
  {
  unsigned k;
  for (k=0; k<KEX_PARAMETERS; k++)
    mark((struct lsh_object *) (i->parameters)[k]);
}
  mark((struct lsh_object *) i->languages_client_to_server);
  mark((struct lsh_object *) i->languages_server_to_client);
}

static void do_kexinit_free(struct lsh_object *o)
{
  struct kexinit *i = (struct kexinit *) o;
  lsh_string_free(i->first_kex_packet);
}

struct lsh_class kexinit_class =
{ STATIC_HEADER,
  0, "kexinit", sizeof(struct kexinit),
  do_kexinit_mark,
  do_kexinit_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct make_kexinit
{
  struct lsh_object super;
  struct kexinit *(*(make))(struct make_kexinit *self);
};
extern struct lsh_class make_kexinit_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class make_kexinit_class =
{ STATIC_HEADER,
  0, "make_kexinit", sizeof(struct make_kexinit),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct install_keys
{
  struct lsh_object super;
  int (*(install))(struct install_keys *self, struct ssh_connection *connection, struct hash_instance *secret);
};
extern struct lsh_class install_keys_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class install_keys_class =
{ STATIC_HEADER,
  0, "install_keys", sizeof(struct install_keys),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct newkeys_info
{
  struct lsh_object super;
  struct crypto_algorithm *encryption_client_to_server;
  struct crypto_algorithm *encryption_server_to_client;
  struct mac_algorithm *mac_client_to_server;
  struct mac_algorithm *mac_server_to_client;
};
extern struct lsh_class newkeys_info_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_newkeys_info_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct newkeys_info *i = (struct newkeys_info *) o;
  mark((struct lsh_object *) i->encryption_client_to_server);
  mark((struct lsh_object *) i->encryption_server_to_client);
  mark((struct lsh_object *) i->mac_client_to_server);
  mark((struct lsh_object *) i->mac_server_to_client);
}

struct lsh_class newkeys_info_class =
{ STATIC_HEADER,
  0, "newkeys_info", sizeof(struct newkeys_info),
  do_newkeys_info_mark,
  NULL
};
#endif /* !GABA_DECLARE */

