/*
 * $Source: /mit/kerberos/src/lib/des/RCS/destest.c,v $
 * $Author: jtkohl $
 *
 * Copyright 1988 by the Massachusetts Institute of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 */

#ifndef	lint
static char rcsid_destest_c[] =
"$Header: destest.c,v 4.0 89/01/23 10:03:38 jtkohl Exp $";
#endif	lint

#include <mit-copyright.h>
#include <stdio.h>
#include <des.h>

char clear[] = "eight bytes";
char cipher[8];
char key[8];
Key_schedule schedule;

main()
{
    int i;
    string_to_key("good morning!", key);
    i = key_sched(key, schedule);
    if (i) {
	printf("bad schedule (%d)\n", i);
	exit(1);
    }
    for (i = 0; i < 10000; i++)
	ecb_encrypt(clear, cipher, i&1, schedule);
}

/*
 * gcc optimized, old e: 34.6
 * gcc optimized, new e: 23.9
 *
 * gcc unopt,     old e: 73.9
 * gcc unopt,     new e: 46.6
 *
 * pcc optimized, old e: 40.8
 * pcc optimized, asm e: 26.5
 * pcc optimized, new e: 31.1
 *
 * pcc unopt,     old e: 34.1
 * pcc unopt,     asm e: 21.3
 * pcc unopt,     new e: 25.8
 */
