/*
 * $Source: /mit/kerberos/src/kadmin/RCS/old_as.c,v $
 * $Author: qjb $ 
 *
 * Copyright 1987, 1988 by the Massachusetts Institute of Technology. 
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>. 
 *
 * This is the server side of the Kerberos network administration
 * program.
 *
 *	-i		(interactive)
 *	-m		(manual)
 *	-s service_name	(given service)
 *
 * "passwd_server" is used as a default service.  A log file is
 * created for the server called KRB_DIR/service_name.log.
 *
 * If the arguments "-s atest3" are given, that's the admin server.
 * A more reasonable name should be given.
 * The admin_server and passwd_server should be merged into one.
 */

#ifndef	lint
static char rcsid_admin_server_c[] =
"$Header: old_as.c,v 4.0 89/07/17 18:10:58 qjb Exp $";
#endif	lint

#include <mit-copyright.h>

/* System include files */
#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <arpa/inet.h>

/* Application include files */
#include <krb.h>
#include <des.h>
#include <prot.h>
#include <krb_db.h>
#include <admin_server.h>
#include <kdc.h>

/* Globals */

#define KRB_DIR	"/kerberos/"

Key_schedule sess_sched;
struct timeval timeout = {
			  TIME_OUT, 0};
int     mask, readfds, writefds, execptfds, found, cc, fromlen;
int     ret_status;
u_char  buf[1024];

struct sockaddr_in my_addr, from_addr;
char    progname[] = "admin_server";	/* library needs this */
char    err_msg[] = "password modification error";
int     s, size;
u_char *msg;
int     msg_size;
struct hostent *hp;
int     debug;
int     s_kvno;
Principal s_name_data;
u_char  master_key_version;
Key_schedule master_key_schedule;
C_Block master_key;
C_Block princ_key;
char    msgbuf[256];

static KTEXT_ST auth_st;	/* Authenticator */
static KTEXT authent = &auth_st;
static AUTH_DAT ad;
static AUTH_DAT *adp = &ad;
static MSG_DAT msg_data;

static FILE *flog;
extern int errno;
extern char *sys_errlist[];

main(argc, argv)
    int     argc;
    char  **argv;
{
    struct servent *sp;
    register int i;
    int     mflag = 0;
    int     iflag = 0;
    char    serv_name[100];
    char    log_name[200];
    register char *p;

    strcpy(serv_name, "passwd_server");	/* default service to use */
    for (i = 1; i < argc; i++) {
	p = argv[i];
	if (*p++ == '-') {
	    switch (*p) {
	    case 'i':
		iflag++;
		break;
	    case 'm':
		mflag++;
		break;
	    case 's':
		if (i + 1 == argc) {
		    fprintf(stderr,
		"Usage: admin_server [-m] [-i] [-s service_name]\n");
		    exit(1);
		}
		strcpy(serv_name, argv[i + 1]);
		i++;
		break;
	    default:
		fprintf(stderr, "Unknown flag: -%c\n", *p);
		fprintf(stderr,
		 "Usage: admin_server [-m] [-i] [-s service_name]\n");
		exit(1);
	    }
	} else {
	    fprintf(stderr,
		 "Usage: admin_server [-m] [-i] [-s service_name]\n");
	    exit(1);
	}
    }

    sp = getservbyname(serv_name, "udp");
    if (sp == NULL) {
	fprintf(stderr, "Unknown service: %s/udp\n", serv_name);
	exit(1);
    }
    flog = stderr;
    bzero(&my_addr, sizeof(my_addr));
    my_addr.sin_family = AF_INET;
    my_addr.sin_addr.s_addr = gethostid();	/* already net order */
    my_addr.sin_port = sp->s_port;

    s = socket(AF_INET, SOCK_DGRAM, 0);
    if (s < 0) {
	syserror("socket");
	exit(1);
    }
    mask = 1 << s;

    if (ioctl(s, FIONBIO)) {
	syserror("ioctl");
	exit(1);
    }
    if (bind(s, &my_addr, sizeof(my_addr)) < 0) {
	syserror("bind");
	exit(1);
    }
    init_service(mflag ? 0 : 1);

    if (iflag) {		/* interactive -- no fork */
	flog = stderr;
	printf(
	"\007\nDON'T USE KILL -9, ONLY REGULAR KILLS TO STOP ME.\n\n");
    } else {			/* background -- fork and */
	/* ignore signals, etc. */
	strcpy(log_name, KRB_DIR);
	strcat(log_name, serv_name);
	strcat(log_name, ".log");
	flog = fopen(log_name, "a+");
	if (flog == NULL) {
	    fprintf(stderr, "%s: can't open log file \"%s\".\n",
		    progname, log_name);
	    exit(1);
	}
	if (fork() != 0) {
	    exit(0);
	}
	setup_disc();
	timestamp_msg("*** starting up ***");
    }

    for (;;) {
	readfds = mask;
	execptfds = mask;
	found = select(s + 1, &readfds, &writefds, &execptfds,
	    &timeout);
	if (found == 0) {
	    continue;		/* timeout */
	}
	if (found < 0) {
	    timestamp_msg("*** select error ***");
	    syserror("select");
	    break;
	}
	if (execptfds & (1 << s)) {
	    timestamp_msg("");
	    fprintf(flog,
		    "\texception on descriptors %X\n", execptfds);
	    fflush(flog);
	    syserror("select");
	    continue;
	}
	if (!(mask & readfds)) {
	    timestamp_msg("select on wrong descriptor");
	    syserror("select mask");
	    break;
	}
	fromlen = sizeof(from_addr);

	if (1 << s & readfds) {
	    if ((cc = recvfrom(
			 s, authent->dat, MAX_KTXT_LEN, 0, &from_addr,
			       &fromlen)) <= 0) {
		if (cc < 0) {
		    timestamp_msg("bad recvfrom");
		    syserror("recvfrom");
		}
	    } else {
		sprintf(msgbuf, "recvfrom host %s, bytes %d",
			inet_ntoa(from_addr.sin_addr), cc);
		timestamp_msg(msgbuf);
		authent->length = cc;
		authent->mbz = 0;
		/* force nulls to stop string ops */
		do_service(&from_addr);
		if (sendto(
		   s, buf, cc, 0, &from_addr, sizeof from_addr) < 0) {
		    syserror("sendto");
		}
	    }
	}
    }
}

timestamp_msg(msg)
    char   *msg;
{
    long    time();
    long    time_buf;
    struct tm *localtime();
    char   *asctime();
    char   *cp;

    time(&time_buf);
    cp = asctime(localtime(&time_buf));
    cp[strlen(cp) - 1] = '\0';	/* zotz the newline asctime gave us */
    fprintf(flog, "%s: %s\n", cp, msg);
    fflush(flog);
}

syserror(arg)
    char   *arg;
{
    fprintf(flog, "\t%s: %s\n\n", arg, sys_errlist[errno]);
    fflush(flog);
}


char    service[SNAME_SZ];
char    instance[INST_SZ];
char    realm[REALM_SZ];
char    key[KKEY_SZ];		/* text of key */
u_long  calc_checksum;
C_Block seed;
u_short time_ms;
u_long  time_sec;
u_long  address;
int     rd_req_ret;

init_service(use_key)
    int     use_key;
{
    int     n, more;

    int     key_file;
    /* do all the database and cache inits */
    printf("\nOpening database...");
    fflush(stdout);
    if (n = kerb_init()) {
	printf("Kerberos db and cache init");
	printf(" failed = %d ...exiting\n", n);
	exit(1);
    }
    /* lookup the master key version */
    n = kerb_get_principal(KERB_M_NAME, KERB_M_INST, &s_name_data, 1,
	&more);
    if (n != 1) {
	fprintf(stderr,
	"\07error on master key version lookup, %d found, more = %d\n",
		n, more);
	exit(-1);
    }
    /* set up the master key */
    master_key_version = s_name_data.kdc_key_ver;
    fprintf(stdout, "\nCurrent Kerberos master key version is %d",
	    master_key_version);
    if (use_key) {
	key_file = open(MKEYFILE, O_RDONLY, 0600);
	if (key_file < 0) {
	    fprintf(stderr, "Cannot open key file.\n");
	    exit(1);
	}
	if (read(key_file, (char *) master_key, 8) != 8) {
	    fprintf(stderr, "Key file wrong length.\n");
	    exit(1);
	}
	close(key_file);
    } else {
	des_read_password(master_key,
			  "\nEnter current Kerberos master key: ", 1);
    }
    key_sched(master_key, master_key_schedule);

    /*
     * now use the master key to decrypt the key in the db, had better
     * be the same! 
     */
    bcopy(&s_name_data.key_low, princ_key, 4);
    bcopy(&s_name_data.key_high, ((long *) princ_key) + 1, 4);
    pcbc_encrypt(princ_key, princ_key, (long) sizeof(princ_key),
		 master_key_schedule, master_key, DECRYPT);
    /* the decrypted database key had better equal the master key */
    n = bcmp((char *) master_key, (char *) princ_key,
	sizeof(master_key));
    if (n) {
	bzero(master_key_schedule, sizeof(master_key_schedule));
	fprintf(stderr,
		"\07\07Invalid master key, does not match database\n");
	exit(-1);
    }
    fprintf(stdout, "\nmaster key entered.  BEWARE!\07\07\n");
    fflush(stdout);

}

do_service(client)
    struct sockaddr_in *client;
{
    register u_char *px;
    static int status;

    px = (u_char *) authent->dat + 3;
    px += strlen(px) + 1;

    /* key was pre-set */
    if (rd_req_ret = krb_rd_req(authent, KADM, KRB_MASTER,
			      client->sin_addr.s_addr, adp, "")) {
	fprintf(flog, "\tkrb_rd_req failure.\n");
	fflush(flog);
	build_err_ret(0, "");
	return;
    }
    /* here is the user data */
    msg = px;
    msg += *px++;		/* add ticket length */
    msg += *px++;		/* add request length */
    msg += 2;			/* add the length array */

    msg_size = authent->length - (int) (msg - (u_char *) authent->dat);
    if (!msg_size) {
	fprintf(flog, "\tmsg_size failure.\n");
	fflush(flog);
	build_err_ret(0, "");
	return;
    }
    calc_checksum = quad_cksum(msg, NULL, msg_size, 0, adp->session);
    if (calc_checksum != adp->checksum) {
	fprintf(flog, "\tcalc_checksum failure.\n");
	fflush(flog);
	build_err_ret(0, "");
	return;
    }
    key_sched(adp->session, sess_sched);
    status = krb_rd_priv(msg, msg_size, sess_sched,
			    adp->session, client, &my_addr, &msg_data);
    if (status) {
	fprintf(flog,
		"\tkrb_rd_priv failure, status %d.\n", status);
	fflush(flog);
	build_err_ret(0, "");
	return;
    }
    kpw_rd_req(client, adp, &msg_data);
}

build_err_ret(msgp, msg)
    int     msgp;
    char   *msg;
{
    u_char *pb = buf;
    *pb++ = KRB_PROT_VERSION;
    *pb++ = AUTH_MSG_ERR_REPLY;
    *pb++ = '\0';		/* name - what if we can't tell? */
    *pb++ = '\0';		/* instance */
    *pb++ = '\0';		/* realm */
    *pb++ = msgp ? 126 : 127;	/* Barfo error codes */
    if (msgp) {
	strcpy(pb, msg);
    } else
	strcpy(pb, "Can't install/restore password.");
    pb += strlen(pb) + 1;
    cc = (int) (pb - buf);
}

graceful_death()
{
    kerb_fini();
}

/*
 * setup_disc 
 *
 * disconnect all descriptors, remove ourself from the process
 * group that * spawned us, die gracefully on everything imaginable 
 */

setup_disc()
{
    int     s;

    signal(SIGPIPE, graceful_death);
    signal(SIGINT, graceful_death);
    signal(SIGQUIT, graceful_death);
    signal(SIGALRM, graceful_death);
    signal(SIGHUP, graceful_death);
    signal(SIGTERM, graceful_death);

    for (s = 0; s < 3; s++) {
	(void) close(s);
    }

    (void) open("/dev/null", 0);
    (void) dup2(0, 1);
    (void) dup2(0, 2);

    s = open("/dev/tty", 2);

    if (s >= 0) {
	ioctl(s, TIOCNOTTY, (struct sgttyb *) 0);
	(void) close(s);
    }
    (void) chdir("/dev");
    return;
}

reset_signals()
{
    signal(SIGPIPE, graceful_death);
    signal(SIGINT, graceful_death);
    signal(SIGQUIT, graceful_death);
    signal(SIGALRM, graceful_death);
    signal(SIGHUP, graceful_death);
    signal(SIGTERM, graceful_death);
}

ignore_signals()
{
    signal(SIGPIPE, SIG_IGN);
    signal(SIGINT, SIG_IGN);
    signal(SIGQUIT, SIG_IGN);
    signal(SIGALRM, SIG_IGN);
    signal(SIGHUP, SIG_IGN);
    signal(SIGTERM, SIG_IGN);
}

kpw_rd_req(client, auth, m_d)
    struct sockaddr_in *client;
    AUTH_DAT *auth;
    MSG_DAT *m_d;
{
    static u_char reply[512];
    static int n;
    static u_char m_type;
    static Principal princ_data;
    static Principal old_princ_data;
    register u_char *p;
    char   *edit_name;
    char   *edit_inst = "";
    char   *edit_pw_new;
    char   *edit_pw_old;
    char   *edit_pw_crypt;
    int     edit_uid;
    int     more;
    int     error;
    extern int mk_pv_ver;

    /* This is now the kerberos password database manipulation code */

    p = m_d->app_data;

    if (*p++ != PW_SRV_VERSION) {
	fprintf(flog, "\tPW_SRV_VERSION failure.\n");
	fflush(flog);
	build_err_ret(0, "");
	return;
    }
    m_type = *p++;		/* request type */

    if (strlen(p) > 8) {	/* can't be a UNIX login name */
	p[9] = '\0';
	fprintf(flog, "\tUNIX login name failure.  name '%s'.\n", p);
	fflush(flog);
	build_err_ret(0, "");
	return;
    }
    edit_name = (char *) p;
    p += strlen(edit_name) + 1;

    if (strlen(p) >= MAX_KPW_LEN) {	/* can't be a UNIX password */
	p[MAX_KPW_LEN] = '\0';
	fprintf(flog,
	     "\tUNIX new password failure.  name '%s', passwd '%s'\n",
		edit_name, p);
	fflush(flog);
	build_err_ret(1,
	"New password is too long (> 8 chars), password not changed.");
	return;
    }
    edit_pw_new = (char *) p;
    p += strlen(edit_pw_new) + 1;

    if (strlen(p) > 8) {	/* can't be a UNIX password */
	p[9] = '\0';
	fprintf(flog,
	     "\tUNIX old password failure.  name '%s', passwd '%s'\n",
		edit_name, p);
	fflush(flog);
	build_err_ret(0, "");
	return;
    }
    edit_pw_old = (char *) p;
    p += strlen(edit_pw_old) + 1;

    if (strlen(p) != 13) { /* can't be an encrypted UNIX password */
	p[14] = '\0';
	fprintf(flog,
	   "\tUNIX crypt password failure.  name '%s', passwd '%s'\n",
		edit_name, p);
	fflush(flog);
	build_err_ret(0, "");
	return;
    }
    edit_pw_crypt = (char *) p;
    p += strlen(edit_pw_crypt) + 1;

    edit_uid = *p++ * 256;	/* "high order" byte */
    edit_uid += *p++;		/* "low order" byte */
    if (edit_uid < 0 || edit_uid > 32767) { /* can't be a UNIX uid */
	fprintf(flog, "\tUNIX uid failure. name '%s', uid %d\n",
		edit_name, edit_uid);
	fflush(flog);
	build_err_ret(0, "");
	return;
    }
    more = 0;
    switch (m_type) {
    case INSTALL_NEW_PW:
	if ((strcmp(edit_name, auth->pname) ||
	     strcmp(edit_inst, auth->pinst))
	    && (strcmp("default", auth->pname) ||
		strcmp(KADM, auth->pinst))) {
	    fprintf(flog,
    "\tname or instance match failure.  name '%s', instance '%s'.\n",
		    edit_name, edit_inst);
	    fflush(flog);
	    build_err_ret(0, "");
	    return;
	}
	n = kerb_get_principal(
			 edit_name, edit_inst, &princ_data, 1, &more);
	if (more || n != 1) {
	    fprintf(flog, "\tunique principal failure.\n");
	    fflush(flog);
	    build_err_ret(0, "");	/* not unique */
	    return;
	}
	if (!strcmp("default", auth->pname) &&
	    !strcmp(KADM, auth->pinst)
	    && (princ_data.key_low != 0 ||
		princ_data.key_high != 0)) {
	    fprintf(flog,
		  "\tALERT: {default,changepw} with non-NULL key.\n");
	    fflush(flog);
	    build_err_ret(0, "");
	    return;
	}
	/* save the old values for the replace */
	princ_data.old = (char *) &old_princ_data;
	bcopy(&princ_data, &old_princ_data, sizeof(old_princ_data));
	strcpy(princ_data.mod_name, auth->pname); /* modified by */
	strcpy(princ_data.mod_instance, auth->pinst);
	/* change the passwd, stuff status into the reply */
	if (!strcmp("default", auth->pname)) {
	    error = write_pw(
		   edit_pw_new, edit_pw_old, edit_pw_crypt, edit_name,
			     &princ_data, 1);
	} else {
	    error = write_pw(
		   edit_pw_new, edit_pw_old, edit_pw_crypt, edit_name,
			     &princ_data, 0);
	}
	if (error) {
	    fprintf(flog, "\twrite_pw failure.\n");
	    fflush(flog);
	    if (error == 2) {	/* Bad password */
		build_err_ret(1,

	      "Incorrect old password supplied, password not changed.");
	    } else
		build_err_ret(0, "");
	    return;
	}
	break;
    case ADMIN_NEW_PW:
	if (!check_access(auth->pname, auth->pinst)) {
	    /* Check if allowed */
	    fprintf(flog,
		"\tADMIN: ALERT: %s.%s attempted to set PW for %s.\n",
		    auth->pname, auth->pinst, edit_name);
	    fflush(flog);
	    build_err_ret(1,
  "Illegal password change request, authorities have been notified!");
	    return;
	}
	n = kerb_get_principal(
			 edit_name, edit_inst, &princ_data, 1, &more);
	if (n == 0) {
	    fprintf(flog, "\tPrincipal not found %s.%s\n",
		    edit_name, edit_inst);
	    fflush(flog);
	    build_err_ret(1,
			  "User not found in kerberos database.");
	    return;
	}
	if (more || n != 1) {
	    fprintf(flog, "\tunique principal failure.\n");
	    fflush(flog);
	    build_err_ret(0, "");	/* not unique */
	    return;
	}
	/* save the old values for the replace */
	princ_data.old = (char *) &old_princ_data;
	bcopy(&princ_data, &old_princ_data, sizeof(old_princ_data));
	strcpy(princ_data.mod_name, auth->pname); /* modified by */
	strcpy(princ_data.mod_instance, auth->pinst);
	fprintf(flog, "\tADMIN: %s.%s is setting %s's password.\n",
		auth->pname, auth->pinst, edit_name);
	fflush(flog);
	error =
	    write_pw(edit_pw_new, edit_pw_old, edit_pw_crypt, edit_name,
		     &princ_data, 0);
	if (error) {
	    fprintf(flog, "\twrite_pw failure.\n");
	    fflush(flog);
	    if (error == 2) {	/* Bad password */
		build_err_ret(1,
      "Incorrect old password supplied, password not changed.");
	    } else
		build_err_ret(0, "");
	    return;
	}
	break;
    case ADMIN_SET_KDC_PASSWORD:
	edit_inst = edit_pw_old;/* This is GROSS */
	if ((strcmp(edit_name, auth->pname) ||
	     strcmp(edit_inst, auth->pinst))
	    && !check_access(auth->pname, auth->pinst)) {
	    /* Check if allowed */
	    fprintf(flog,
	    "\tADMIN: ALERT: %s.%s attempted to set KDC for %s.%s.\n",
		    auth->pname, auth->pinst, edit_name, edit_inst);
	    fflush(flog);
	    build_err_ret(1,
  "Illegal password change request, authorities have been notified!");
	    return;
	}
	n = kerb_get_principal(
			 edit_name, edit_inst, &princ_data, 1, &more);
	if (n == 0) {
	    fprintf(flog, "\tPrincipal not found %s.%s\n",
		    edit_name, edit_inst);
	    fflush(flog);
	    build_err_ret(1,
			  "Principal not found in kerberos database.");
	    return;
	}
	if (more || n != 1) {
	    fprintf(flog, "\tunique principal failure.\n");
	    fflush(flog);
	    build_err_ret(0, "");	/* not unique */
	    return;
	}
	fprintf(flog, "\tADMIN: %s.%s is setting KDC key for %s.%s\n",
		auth->pname, auth->pinst, edit_name, edit_inst);
	fflush(flog);
	/* save the old values for the replace */
	princ_data.old = (char *) &old_princ_data;
	bcopy(&princ_data, &old_princ_data, sizeof(old_princ_data));
	strcpy(princ_data.mod_name, auth->pname); /* modified by */
	strcpy(princ_data.mod_instance, auth->pinst);

	/* Actually set new key in principal data */

	/* First turn into DES key */
	string_to_key(edit_pw_new, princ_key);
	/* Then seal it in the master key */
	pcbc_encrypt(princ_key, princ_key, (long) sizeof(princ_key),
		     master_key_schedule, master_key, 1);
	/* Stuff it in the princ structure */
	bcopy(princ_key, &princ_data.key_low, 4);
	bcopy(((long *) princ_key) + 1, &princ_data.key_high, 4);
	/* Zero out no longer needed variable */
	/* To the best of my recollection Senator... */
	bzero(princ_key, sizeof(princ_key));
	/* Set master key version used to seal key */
	princ_data.kdc_key_ver = master_key_version;
	/* Increment key version */
	princ_data.key_version++;
	/* Ignore signals while messing with the database */
	ignore_signals();
	n = kerb_put_principal(&princ_data, 1);
	/* Ok to accept signals now */
	reset_signals();
	if (n == 0)
	    break;
	build_err_ret(1,
		      "Error putting principal in database!");
	fprintf(flog, "\tError putting principal in database!\n");
	fflush(flog);
	return;
    case ADMIN_ADD_NEW_KEY:
    case ADMIN_ADD_NEW_KEY_ATTR:
	edit_inst = edit_pw_old;/* This is GROSS */
	if (!check_access(auth->pname, auth->pinst)) {
	    /* Check if allowed */
	    fprintf(flog,
	    "\tADMIN: ALERT: %s.%s attempted to set KDC for %s.%s.\n",
		    auth->pname, auth->pinst, edit_name, edit_inst);
	    fflush(flog);
	    build_err_ret(1,
  "Illegal password change request, authorities have been notified!");
	    return;
	}
	n = kerb_get_principal(
			 edit_name, edit_inst, &princ_data, 1, &more);
	if (n != 0) {
	    if (m_type == ADMIN_ADD_NEW_KEY ||
		princ_data.attributes != atoi(edit_pw_crypt)) {
		fprintf(flog,"\tPrincipal already exists %s.%s\n",
		    edit_name, edit_inst);
		fflush(flog);
		build_err_ret(1,
			 "Principal already in kerberos database.");
		return;
	    }
	}
	fprintf(flog, "\tADMIN: %s.%s is adding KDC key for %s.%s\n",
		auth->pname, auth->pinst, edit_name, edit_inst);
	fflush(flog);

	/* Cobble up new principal. */

	strcpy(princ_data.name, edit_name);
	strcpy(princ_data.instance, edit_inst);
	princ_data.old = NULL;
	princ_data.exp_date = 946702799;	/* happy new century */
	strcpy(princ_data.exp_date_txt, "31-dec-1999");
	if (m_type == ADMIN_ADD_NEW_KEY)
	    princ_data.attributes = 0;
	else
	    princ_data.attributes = atoi(edit_pw_crypt);
	princ_data.max_life = 255;
	princ_data.key_version = 1;
	strcpy(princ_data.mod_name, auth->pname); /* modified by */
	strcpy(princ_data.mod_instance, auth->pinst);

	/* Actually set new key in principal data */

	/* First turn into DES key */
	string_to_key(edit_pw_new, princ_key);

	/* Then seal it in the master key */
	pcbc_encrypt(princ_key, princ_key, (long) sizeof(princ_key),
		     master_key_schedule, master_key, 1);

	/* Stuff it in the princ structure */
	bcopy(princ_key, &princ_data.key_low, 4);
	bcopy(((long *) princ_key) + 1, &princ_data.key_high, 4);
	/* Zero out no longer needed variable */
	/* To the best of my recollection Senator... */
	bzero(princ_key, sizeof(princ_key));
	/* Set master key version used to seal key */
	princ_data.kdc_key_ver = master_key_version;
	/* Ignore signals while messing with the database */
	ignore_signals();
	n = kerb_put_principal(&princ_data, 1);
	/* Ok to accept signals now */
	reset_signals();
	if (n == 0)
	    break;
	build_err_ret(1,
		      "Error putting principal in database!");
	fprintf(flog, "\tError putting principal in database!\n");
	fflush(flog);
	return;
    default:
	fprintf(flog,
		"\tdatabase modification command type failure.\n");
	fflush(flog);
	build_err_ret(0, "");
	return;
	break;
    }

    /* evidently, we've replaced the password */
    /* so construct a reply to send back */

    fprintf(flog, "\tSuccess: changed password for '%s'.\n", edit_name);
    fflush(flog);

    p = reply;
    *p++ = PW_SRV_VERSION;
    *p++ = INSTALL_REPLY;
    strcpy(p, edit_name);
    p += strlen(p) + 1;
    strcpy(p, edit_pw_new);
    p += strlen(p) + 1;
    cc = krb_mk_priv(
	   reply, buf, p - reply, sess_sched, auth->session, &my_addr,
			client);
    if (cc < 0) {
	fprintf(flog, "\tkrb_mk_priv failure.\n");
	fflush(flog);
	build_err_ret(0, "");
	return;
    }
    return;
}

write_pw(p, op, cp, name, princ, check)
    u_char *p;
    char   *op;			/* old cleartext password */
    char   *cp;			/* new UNIX encrypted string */
    char   *name;		/* UNIX login name */
    Principal *princ;
    int     check;		/* 1 if we should verify the password */
{
    int     n;
    char   *crypt();

    string_to_key(p, princ_key);

    /* seal in master key */
    pcbc_encrypt(princ_key, princ_key, (long) sizeof(princ_key),
		 master_key_schedule, master_key, 1);

    /* stuff in struct */
    bcopy(princ_key, &princ->key_low, 4);
    bcopy(((long *) princ_key) + 1, &princ->key_high, 4);
    bzero(princ_key, sizeof(princ_key));
    /* set master key version */
    princ->kdc_key_ver = master_key_version;
    /* bump key version # */
    princ->key_version++;

    ignore_signals();

#ifdef athenareg

    /* hack on athenareg database before kerberos */
    if (initialize_database(PRIVILEGED, NULL) != SUCCESS) {
	fprintf(flog, "\tinitialize_database (athenareg) failure.\n");
	fflush(flog);
	n = 1;
	goto error_return;
    }
    if (get_user_by_login(&user, name) != SUCCESS) {
	fprintf(flog, "\tget_user_by_name (athenareg) failed.\n");
	fflush(flog);
	n = 1;
	goto error_return;
    }
    uid = user.u_uid;
    pw = crypt(op, user.u_password);
    /* DEBUG */
    fprintf(flog,
     "\tDEBUG: name=%s, user.u_password=%s\n", name, user.u_password);
    fprintf(flog, "\tDEBUG: uid=%d, pw=%s\n", uid, pw);
    fprintf(flog, "\tDEBUG: check=%d\n", check);
    fflush(flog);
    /* DEBUG */
    if (check) {
	if (strcmp(pw, user.u_password)) { /* Incorrect Password */
	    fprintf(flog,
		    "\tIncorrect old password supplied by user\n");
	    fflush(flog);
	    n = 2;
	    goto error_return;
	}
    }
    if (replace_password(uid, cp, op) != SUCCESS) {
	fprintf(flog, "\treplace_password (athenareg) failure.\n");
	fflush(flog);
	n = 1;
	goto error_return;
    }
    finalize_database();

#endif	athenareg

    /* then into kerberos database */
    n = kerb_put_principal(princ, 1);

    reset_signals();

    /* Is everybody happy? */
    return ((n == 0) ? 0 : 1);

#ifdef	athenareg
error_return:

    finalize_database();
    reset_signals();
    return (n);
#endif	athenareg
}

char   *index();
check_access(pname, pinst)
    char   *pname;
    char   *pinst;
{
    char    file_pname[ANAME_SZ];
    char    file_pinst[INST_SZ];
    char    line[200];
    register char *cp;
    FILE   *fp;
    fp = fopen(KRB_ACL, "r");
    if (fp == NULL) {
	fprintf(flog,
		"\tcheck_access: Unable to open acl file %s\n",
		KRB_ACL);
	fflush(flog);
	return (0);
    }
    while (fgets(line, 200, fp) != NULL) {
	line[199] = '\0';	/* Backstop! */
	cp = index(line, '\n');	/* Flush newline at end */
	if (cp != NULL)
	    *cp = '\0';
	cp = index(line, '.');
	if (cp == NULL) {
	    file_pinst[0] = '\0';
	    strncpy(file_pname, line, ANAME_SZ);
	} else {
	    *cp++ = '\0';
	    strncpy(file_pinst, cp, INST_SZ);
	    strncpy(file_pname, line, ANAME_SZ);
	}
	fprintf(flog, "\tcheck_access: Principal list: %s.%s\n",
		file_pname, file_pinst);
	fflush(flog);
	if (!strcmp(file_pname, pname) && !strcmp(file_pinst, pinst)) {
	    fclose(fp);
	    fprintf(flog,
		  "\tcheck_access: Granted to %s.%s\n", pname, pinst);
	    fflush(flog);
	    return (1);
	}
    }
    fclose(fp);
    return (0);
}
