#define _POSIX_SOURCE
#include <sys/types.h>	/* pid_t */
#include <unistd.h>	/* write getpid */
#include <stdio.h>
#include <string.h>	/* memset memcmp */
#include <ctype.h>	/* isspace */
#include <stdlib.h>	/* exit free (after ctype.h for BSDI BSD/386) */
#include <time.h>
#include <fcntl.h>
#include <ndbm.h>
#include "deslogin.h"
#include "dladduser.h"

char* progName;
int debug = 0;
int verbose = 0;
extern int optind;
extern char* optarg;

typedef struct {
   char     iv[DES_BLOCKSIZE];
   unsigned ivlen;
   keyType  key;
   int 	    mode;
} cipherState;

cipherKey mkCipherKey(key, mode)
   keyType key;
   int mode;
{
   cipherState *cs =(cipherState *)malloc(sizeof (cipherState));

   if (cs != (cipherState *) 0) {
      memset(cs->iv, '\0', DES_BLOCKSIZE);
      cs->ivlen = DES_BLOCKSIZE;
      cs->key   = key;
      cs->mode  = mode;
   }
   return (cipherKey) cs;
}

void destroyCipherKey(c)
   cipherKey *c;
{
   register cipherState *cs = * (cipherState **) c;

   if (cs != (cipherState *) 0) {
      memset(cs->iv, '\0', DES_BLOCKSIZE);
      cs->ivlen = 0;
      cs->key   = (keyType) 0;
      cs->mode  = 0;
      free(cs);
      *c = (cipherKey) 0;
   }
}

void cipherData(dst, src, size, c)
   char *dst, *src;
   unsigned size;
   cipherKey c;
{
   register cipherState *cs = (cipherState *) c;

   if (cs->key != (keyType) 0) {
      cs->ivlen = desCFB(dst, src, size, cs->iv, cs->ivlen, cs->key, cs->mode);
   } else {
      memcpy(dst, src, size);
   }
}

/*
 * Convert a string of bytes to their hex representation
 */
char *hexData(dst, src, size)
   register char *dst, *src;
   register unsigned size;
{
   register char *chp = dst;
   if (size != 0) do {
      sprintf(chp, "%.2x", * (unsigned char *) src++);
      chp += 2;
   } while (--size != 0);
   return dst;
}

/*
 * Create a key from a keyString
 *
 * Mode: 0 = encrypt, 1 = decrypt
 */
keyType mkKey(keyString) 		
   char *keyString;
{
   char 	keybits[DES_BLOCKSIZE];
   keyType key = (keyType) 0;

   desKey(keybits, keyString, ' ');		/* hash string into 64-bits */
   desMakeKey(&key, keybits, DES_BLOCKSIZE, 0);	/* always encrypt for CFB */
   memset(keybits, '\0', DES_BLOCKSIZE);
   return key;
}

/*
 * Perform one DES encryption(decryption if mode nonzero) (ECB mode)
 *
 * Dst and src must be exactly DES_BLOCKSIZE bytes long.
 */
void cipherKeyString(dst, src, keyString, mode)
   char *dst, *src, *keyString;
   int mode;			/* 0 = encipher, 1 = decipher */
{
   char 	keybits[DES_BLOCKSIZE];
   keyType key = (keyType) 0;

   desKey(keybits, keyString, ' ');		/* hash string into 64-bits */

   desMakeKey(&key, keybits, DES_BLOCKSIZE, mode);
   memset(keybits, '\0', DES_BLOCKSIZE);

   des(dst, src, key);
   desDestroyKey(&key);
}

int main(argc,argv)
int argc;
char *argv[];
{
 char dbmFile[128],dbmFilePhrase[PHRASE_SIZE+1];
 char username[32+1];  
 keyType dbmFileKey = 0;
 int res = 0,chopt;
 char dbmkey[32+1];
 cipherKey ck = (cipherKey) 0;
 DBM* dbmf;
 datum k,d;
 int df = 0,dn = 0;

 while ((chopt = getopt(argc, argv, "hf:n:")) != EOF) switch (chopt) {
   case 'n':
      strcpy(username,optarg);
      break;
   case 'f':
      strcpy(dbmFile,optarg);
      df = 1;
      break;
   case 'h':
      fprintf(stderr,"Usage: dlrmuser -f dbmfile -n username\n");
      exit(0);
   }

 if ( !df)
 {
  fprintf(stderr,"Insert NDBM file name: ");
  gets(dbmFile);
 }
 res = askTty("Insert NDBM file passphrase: ",dbmFilePhrase,PHRASE_SIZE-1,0);
 if (res)
 {
  dbmFileKey = mkKey(dbmFilePhrase);
  memset(dbmFilePhrase,'\0',strlen(dbmFilePhrase));
  if (dbmFileKey == (keyType) 0)
  {
   fprintf(stderr,"NDBM key error.\n");
   return(-1);
  }
 }
 else
  fprintf(stderr,"Plain NDBM file.\n");


 if( !dn )
 {
  fprintf(stderr,"Username: ");
  gets(username);
 }

 dbmf = dbm_open(dbmFile,O_RDWR,0600);
 if (dbmf == (DBM*) NULL)
 {
  fprintf(stderr,"ERROR: can't open NDBM file.\n");
  return(-1);
 } 

 ndbm_cipherstring(dbmkey,username,32,dbmFileKey,0);
 k.dptr = dbmkey;
 k.dsize = 32;
 res = dbm_delete(dbmf,k);
 if (res < 0)
 {
  fprintf(stderr,"Database error.\n");
  dbm_close(dbmf);
  destroyCipherKey(&ck);
  return(-1);
 }
 
 fprintf(stderr,"Ok, deleted.\n");
 
 destroyCipherKey(&ck);
 dbm_close(dbmf);
}


int ndbm_cipherstring(dest, src, len, key, mode)
   char *dest;
   char *src;
   int len;
   keyType key;
   int mode;
{
 cipherKey ck;

 ck = mkCipherKey(key,mode);
 cipherData(dest,src,len,ck);
 destroyCipherKey(&ck);
}
