.NH 1
SOFTWARE FOR IMPROVING SECURITY
.PP
Because security is of great concern to many sites,
a wealth of software has been developed for improving the security of
.SM UNIX
systems.
Much of this software has been developed at universities and other public
institutions,
and is available free for the asking.
This section describes how this software can be obtained,
and mentions some of the more important programs available.
.NH 2
OBTAINING FIXES AND NEW VERSIONS
.PP
Several sites on the Internet maintain large repositories of public-domain
and freely distributable software,
and make this material available for anonymous
.SM FTP .
This section describes some of the larger repositories.
.NH 3
Sun Fixes on UUNET
.PP
Sun Microsystems has contracted with
.SM UUNET
Communications Services,
Inc. to make fixes for bugs in Sun software available via anonymous
.SM FTP .
You can access these fixes by using the
.I ftp
command [Sun88a, 195-201] to connect to the host
.I ftp.uu.net .
Then change into the directory
.I sun-fixes ,
and obtain a directory listing,
as shown in the example on the following page.
.DS L
.ft C
.ps -2
.vs -2
% \f(CBftp ftp.uu.net\fP
Connected to uunet.UU.NET.
220 uunet FTP server (Version 5.93 Tue Mar 20 11:01:52 EST 1990) ready.
Name (ftp.uu.net:davy): \f(CBanonymous\fP
331 Guest login ok, send ident as password.
Password:               \fIenter your mail address yourname@yourhost here\fP
230 Guest login ok, access restrictions apply.
ftp> \f(CBcd sun-fixes\fP
250 CWD command successful.
ftp> \f(CBdir\fP
200 PORT command successful.
150 Opening ASCII mode data connection for /bin/ls.
total 2258
-rw-r--r--  1 38       22           4558 Aug 31  1989 README
-rw-r--r--  1 38       22         484687 Dec 14  1988 ddn.tar.Z
-rw-r--r--  1 38       22         140124 Jan 13  1989 gated.sun3.Z
-rwxr-xr-x  1 38       22          22646 Dec 14  1988 in.ftpd.sun3.Z
\&.....
\&.....
-rw-r--r--  1 38       22          72119 Aug 31  1989 sendmail.sun3.Z
-rwxr-xr-x  1 38       22          99147 Aug 31  1989 sendmail.sun4.Z
-rw-r--r--  1 38       22           3673 Jul 11  1989 wall.sun3.Z
-rw-r--r--  1 38       22           4099 Jul 11  1989 wall.sun4.Z
-rwxr-xr-x  1 38       22           7955 Jan 18  1989 ypbind.sun3.Z
-rwxr-xr-x  1 38       22           9237 Jan 18  1989 ypbind.sun4.Z
226 Transfer complete.
1694 bytes received in 0.39 seconds (4.2 Kbytes/s)
ftp> \f(CBquit\fP
221 Goodbye.
%
.vs +2
.ps +2
.ft R
.DE
The file
.I README
contains a brief description of what each file in this directory contains,
and what is required to install the fix.
.NH 3
Berkeley Fixes
.PP
The University of California at Berkeley also makes fixes available via
anonymous
.SM FTP ;
these fixes pertain primarily to the current release of
.SM "BSD UNIX"
(currently release 4.3).
However,
even if you are not running their software,
these fixes are still important,
since many vendors (Sun,
.SM DEC ,
Sequent ,
etc.) base their software on the Berkeley releases.
.PP
The Berkeley fixes are available for anonymous
.SM FTP
from the host
.I ucbarpa.berkeley.edu
in the directory
.I 4.3/ucb-fixes .
The file
.I INDEX
in this directory describes what each file contains.
.PP
Berkeley also distributes new versions of
.I sendmail
and
.I named
[Sun88a, 1758-1760, 1691-1692] from this machine.
New versions of these commands are stored in the
.I 4.3
directory,
usually in the files
.I sendmail.tar.Z
and
.I bind.tar.Z ,
respectively.
.NH 3
Simtel-20 and UUNET
.PP
The two largest general-purpose software repositories on the Internet are
the hosts
.I wsmr-simtel20.army.mil
and
.I ftp.uu.net .
.PP
.I wsmr-simtel20.army.mil
is a
.SM TOPS -20
machine operated by the U. S. Army at White Sands Missile Range,
New Mexico.
The directory
.I pd2:<unix-c>
contains a large amount of
.SM UNIX
software,
primarily taken from the
.I comp.sources
newsgroups.
The file
.I 000-master-index.txt
contains a master list and description of each piece of software available
in the repository.
The file
.I 000-intro-unix-sw.txt
contains information on the mailing list used to announce new software,
and describes the procedures used for transferring files from the archive
with
.SM FTP .
.PP
.I ftp.uu.net
is operated by
.SM UUNET
Communications Services,
Inc. in Falls Church,
Virginia.
This company sells Internet and
.SM USENET
access to sites all over the country (and internationally).
The software posted to the following
.SM USENET
source newsgroups is stored here,
in directories of the same name:
.DS
comp.sources.games
comp.sources.misc
comp.sources.sun
comp.sources.unix
comp.sources.x
.DE
Numerous other distributions,
such as all the freely distributable Berkeley
.SM UNIX
source code,
Internet Request for Comments
.SM RFC s), (
and so on are also stored on this machine.
.NH 3
Vendors
.PP
Many vendors make fixes for bugs in their software available electronically,
either via mailing lists or via anonymous
.SM FTP .
You should contact your vendor to find out if they offer this service,
and if so,
how to access it.
Some vendors that offer these services include Sun Microsystems (see above),
Digital Equipment Corp.,
the University of California at Berkeley (see above),
and Apple Computer.
.NH 2
THE NPASSWD COMMAND
.PP
The
.I npasswd
command,
developed by Clyde Hoover at the University of Texas at Austin,
is intended to be a replacement for the standard
.SM UNIX
.I passwd
command [Sun88a, 379],
as well as the Sun
.I yppasswd
command [Sun88a, 611].
.I npasswd
makes passwords more secure by refusing to allow users to select insecure
passwords.
The following capabilities are provided by
.I npasswd :
.RS
.IP \(bu
Configurable minimum password length
.IP \(bu
Configurable to force users to use mixed case or digits and punctuation
.IP \(bu
Checking for ``simple'' passwords such as a repeated letter
.IP \(bu
Checking against the host name and other host-specific information
.IP \(bu
Checking against the login name,
first and last names,
and so on
.IP \(bu
Checking for words in various dictionaries,
including the system dictionary.
.RE
.PP
The
.I npasswd
distribution is available for anonymous
.SM FTP
from
.I emx.utexas.edu
in the directory
.I pub/npasswd .
.NH 2
THE COPS PACKAGE
.PP
.SM
COPS
is a security tool for system administrators that checks for numerous
common security problems on
.SM UNIX
systems,
including many of the things described in this document.
.SM COPS
is a collection of shell scripts and C programs that can easily be run on
almost any
.SM UNIX
variant.
Among other things,
it checks the following items and sends the results to the system
administrator:
.RS
.IP \(bu
Checks
.I /dev/kmem
and other devices for world read/writability.
.IP \(bu
Checks special/important files and directories for ``bad'' modes (world
writable,
etc.).
.IP \(bu
Checks for easily guessed passwords.
.IP \(bu
Checks for duplicate user ids,
invalid fields in the password file,
etc.
.IP \(bu
Checks for duplicate group ids,
invalid fields in the group file,
etc.
.IP \(bu
Checks all users' home directories and their
.I \&.cshrc ,
.I \&.login ,
.I \&.profile ,
and
.I \&.rhosts
files for security problems.
.IP \(bu
Checks all commands in the
.I /etc/rc
files [Sun88a, 1724-1725] and
.I cron
files [Sun88a, 1606-1607] for world writability.
.IP \(bu
Checks for bad ``root'' paths,
.SM NFS
file system exported to the world,
etc.
.IP \(bu
Includes an expert system that checks to see if a given user
(usually ``root'') can be compromised,
given that certain rules are true.
.IP \(bu
Checks for
.I changes
in the setuid status of programs on the system.
.RE
.PP
The
.SM COPS
package is available from the
.I comp.sources.unix
archive on
.I ftp.uu.net ,
and also from the repository on
.I wsmr-simtel20.army.mil .
.NH 2
SUN C2 SECURITY FEATURES
.PP
With the release of
.SM OS "" Sun
4.0,
Sun has included security features that allow the system to operate at
a higher level of security,
patterned after the C2* classification.
.FS *
C2 is one of several security classifications defined by the National
Computer Security Center,
and is described in [NCSC85],
the ``orange book.''
.FE
These features can be installed as one of the options when installing the
system from the distribution tapes.
The security features added by this option include
.RS
.IP \(bu
Audit trails that record all login and logout times,
the execution of administrative commands,
and the execution of privileged (setuid) operations.
.IP \(bu
A more secure password file mechanism (``shadow password
file'') that prevents crackers from obtaining a list of the encrypted
passwords.
.IP \(bu
.SM DES
encryption capability.
.IP \(bu
A (more) secure
.SM NFS
implementation that uses public-key encryption to authenticate the users
of the system and the hosts on the network,
to be sure they really are who they claim to be.
.RE
.LP
These security features are described in detail in [Sun88c].
.NH 2
KERBEROS
.PP
Kerberos [Stei88] is an authentication system developed by the Athena
Project at the Massachusetts Institute of Technology.
Kerberos is a third-party authentication service,
which is trusted by other network services.
When a user logs in,
Kerberos authenticates that user (using a password),
and provides the user with a way to prove her identity to other servers
and hosts scattered around the network.
.PP
This authentication is then used by programs such as
.I rlogin
[Sun88a, 418-419] to allow the user to log in to other hosts without a
password (in place of the
.I \&.rhosts
file).
The authentication is also used by the mail system in order to guarantee
that mail is delivered to the correct person,
as well as to guarantee that the sender is who he claims to be.
.SM NFS
has also been modified by M.I.T. to work with Kerberos,
thereby making the system much more secure.
.PP
The overall effect of installing Kerberos and the numerous other programs
that go with it is to virtually eliminate the ability of users to ``spoof''
the system into believing they are someone else.
Unfortunately,
installing Kerberos is very intrusive,
requiring the modification or replacement of numerous standard programs.
For this reason,
a source license is usually necessary.
There are plans to make Kerberos a part of 4.4\s-1BSD\s0,
to be released by the University of California at Berkeley sometime in 1990.
