/*
 * config-math.h
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>
 */

/*** CHANGELOG ***
 *
 * 18.1.1998    Vesa Karpijoki   Added #includes <u.h> and <libc.h>,
 *                               removed <math.h> and <limits.h>.
 *                               Cleaned up some #ifdefs.
 *
 * 27.1.1998    Teemu Ikonen     fixed some bugs made by Vesa
 *
 * 21.2.1998    Jari Kytojoki    isinf bug fix
 *
 */

#ifndef __config_math_h
#define __config_math_h

#define	remainder	fmod
#define	drem            fmod
#define	remainderf(a, b) (float)fmod((double)(a), (double)(b))

/* How about negative inf.? */
#define	isinf(x)	isInf((double)x,0)

#define	isnan(x)        isNaN((double)x)

#endif
