/*
 * gethostbyname.c
 *
 * Uses the dns to solve the name of the host internet address based on a
 * host name that is given as an argument to the function.
 * 
 * This function is a helper function for java.net.InetAddressImpl native
 * methods.
 */

#include <u.h>
#include <libc.h>
#include <stdio.h>
#include "dns.h"
#include "hostresolution.h"
#include "ip.h"

/**
  @title gethostbyname
  @desc This function is used to get the host address based on the host name.
  @funcidx
  @end
  */

/**
  @function    gethostbyname
  @description Returns the host address based on the host name as an integer.
  @parameter   The name of the desired host.
  @rvalue      The host address as an integer.
  @end
  */

int gethostbyname(char *name)
{
  int fd, n;
  int ent;
  char *line, *p1;
  char buf[1024];

  fd = open("/net/dns", ORDWR);
  
  if(fd < 0){
    
    fd = open("/srv/dns", ORDWR);
    
    if(fd < 0){
      print("can't open /srv/dns: %r\n");
      return 0;
    }
    
    if(mount(fd, "/net", MBEFORE, "") < 0){
      print("can't mount /srv/dns: %r\n");
      return 0;
    }
    
    fd = open("/net/dns", ORDWR);
    
    if(fd < 0){
      print("can't open /net/dns: %r\n");
      return 0;
    }
  }
  
  line = strcat(name, " ip");
  n = strlen(line);
  
  seek(fd, 0, 0);
  if(write(fd, line, n) < 0)
    return 0;
  
  seek(fd, 0, 0);
  while((n = read(fd, buf, sizeof(buf))) > 0) {
    buf[n] = 0;
    
    p1 = strstr(buf, " ip")+4;
    
    if (p1 != 0) {
      sscanf(p1, "%d.%d.%d.%d", &ent, (char *)&ent + 1, (char *)&ent + 2, 
	     (char *)&ent + 3);
    }
  }
  close(fd);
  
  return ent;
}

