/*
 * java.net.SocketOutputStream.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 * 12.1.1998   Olli-Pekka Auvinen   Rewrote socketWrite.
 *
 * 16.1.1998   Olli-Pekka Auvinen   Added seek to start of ctl file.
 *
 * 10.2.1998   Olli-Pekka Auvinen   Added the dokumatic documentation. 
 *
 */

#include <u.h>
#include <libc.h>

#include "config.h"
#include "config-std.h"
#include "config-mem.h"
#include "config-io.h"
#include <native.h>
#include "../../APIcore/java.io.stubs/FileDescriptor.h"
#include "../../APIcore/java.io.stubs/FileOutputStream.h"
#include "../java.net.stubs/SocketImpl.h"
#include "../java.net.stubs/SocketOutputStream.h"
#include "nets.h"
#include "kthread.h"

/**
  @title java_net_SocketOutputStream
  @desc Instances of this class represent socket output streams.
  @funcidx
  @end
  */

/**
  @function    java_net_SocketOutputStream_socketWrite
  @description Write bytes to socket output stream.
  @parameter   Reference to the current (this) object.
  @parameter   Byte array from which the bytes are being written.
  @parameter   Starting point in the buffer (offset).
  @parameter   The number of bytes to be written.
  @end
  */

void java_net_SocketOutputStream_socketWrite(struct Hjava_net_SocketOutputStream* this, HArrayOfByte* buf, jint offset, jint len)
{
  char connNumber[MAX_CNUM_LEN], dataFileName[30];
  int ctlFileFD, dataFileFD, r;
  
  /* Open the data file of the tcp device and write requested amount of
     bytes to the file. */
  
  ctlFileFD = unhand(unhand(unhand(this)->impl)->fd)->fd;
  if (ctlFileFD < 0) {
    SignalError(NULL, "java.net.SocketException", "Invalid ctl file fd");
  }

  if (seek(ctlFileFD, 0, 0)) {
    SignalError(NULL, "java.net.SocketException", "Ctl file seeking failed");
  }
  r = read(ctlFileFD, connNumber, MAX_CNUM_LEN);
  if (r <= 0) {
    SignalError(NULL, "java.net.SocketException", "Ctl file reading failed");
  }
  connNumber[r] = '\0';
  
  sprint(dataFileName, "/net/tcp/%d/data", atoi(connNumber));
  
  dataFileFD = open(dataFileName, OWRITE);
  if (dataFileFD < 0) {
    SignalError(NULL, "java.net.SocketException", "Data file opening failed");
  }
  
  if (write(dataFileFD, &unhand(buf)->body[offset], len) < len) {
    SignalError(NULL, "java.net.SocketException", "Writing to socket failed");
  }
  
  if (close(dataFileFD) < 0) {
    SignalError(NULL, "java.net.SocketException", "Data file closing failed");
  }
}


