/*
 * java.net.SocketInputStream.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 * 12.1.1998   Olli-Pekka Auvinen   Rewrote socketRead.
 *
 * 16.1.1998   Olli-Pekka Auvinen   Added seek to start of ctl file.
 *
 * 10.2.1998   Olli-Pekka Auvinen   Added the dokumatic documentation. 
 *
 */

#include <u.h>
#include <libc.h>

#include "config.h"
#include "config-std.h"
#include "config-io.h"
#include "config-mem.h"
#include <native.h>
#include "../../APIcore/java.io.stubs/FileDescriptor.h"
#include "../../APIcore/java.io.stubs/FileInputStream.h"
#include "../java.net.stubs/SocketImpl.h"
#include "../java.net.stubs/SocketInputStream.h"
#include "nets.h"
#include "kthread.h"
#include "../../support.h"

/**
  @title java_net_SocketInputStream
  @desc Instances of this class represent socket input streams.
  @funcidx
  @end
  */

/**
  @function    java_net_SocketInputStream_socketRead
  @description Read bytes from socket input stream.
  @parameter   Reference to the current (this) object.
  @parameter   Byte array to which the bytes are read.
  @parameter   Starting point in the buffer (offset).
  @parameter   The number of bytes to be read. 
  @rvalue      The number of bytes that was actually read as a jint.
  @end
  */

jint java_net_SocketInputStream_socketRead(struct Hjava_net_SocketInputStream* this, HArrayOfByte* buf, jint offset, jint len)
{
  char connNumber[MAX_CNUM_LEN], dataFileName[30];
  int ctlFileFD, dataFileFD, r;
  
  /* Open the data file of the tcp device and read requested amount of
     bytes from the file. */
  
  ctlFileFD = unhand(unhand(unhand(this)->impl)->fd)->fd;
  if (ctlFileFD < 0) {
    SignalError(NULL, "java.net.SocketException", "Invalid ctl file fd");
  }

  if (seek(ctlFileFD, 0, 0)) {
    SignalError(NULL, "java.net.SocketException", "Ctl file seeking failed");
  }
  r = read(ctlFileFD, connNumber, MAX_CNUM_LEN);
  if (r <= 0) {
    SignalError(NULL, "java.net.SocketException", "Ctl file reading failed");
  }
  connNumber[r] = '\0';
  
  sprint(dataFileName, "/net/tcp/%d/data", atoi(connNumber));
  
  dataFileFD = open(dataFileName, OREAD);
  if (dataFileFD < 0) {
    SignalError(NULL, "java.net.SocketException", "Data file opening failed");
  }
  
  r = read(dataFileFD, &unhand(buf)->body[offset], len);
  if (r < 0) {
    SignalError(NULL, "java.net.SocketException", "Data file reading failed");
  }
  else if (r == 0) {
    r = -1;	/* EOF */
  }
  
  if (close(dataFileFD) < 0) {
    SignalError(NULL, "java.net.SocketException", "Data file closing failed");
  }
  
  return (r);
}



