/*
 * java.lang.Throwable.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 * 21.1.1998   Vesa Karpijoki   Added #includes <u.h> and <libc.h>.
 *                              Removed some #includes.
 *
 * 18.3.1998   Vesa Karpijoki   Added Dokumatic documentation.
 *                              Changed #include:s.
 */


#include <u.h>
#include <libc.h>

#include <stdio.h>
#include <native.h>
#include "../java.io.stubs/FileDescriptor.h"
#include "../java.io.stubs/FileOutputStream.h"
#include "../java.io.stubs/PrintStream.h"
#include "../java.lang.stubs/Throwable.h"

/**
  @title java_lang_Throwable
  @desc Native methods of the Java API class java.lang.Throwable.
  @funcidx
  @end
  */

extern Hjava_lang_Object* buildStackTrace(void*);

/**
  @function java_lang_Thread_currentThread
  @description Fill in stack trace information - don't know what thought.
  @parameter Reference to a Throwable object.
  @rvalue Reference to the Throwable object.
  @end
  */
struct Hjava_lang_Throwable* java_lang_Throwable_fillInStackTrace(struct Hjava_lang_Throwable* o)
{
	unhand(o)->backtrace = buildStackTrace(0);
	return (o);
}

/**
  @function java_lang_Thread_currentThread
  @description Dump the stack trace to the given stream.
  @parameter Reference to a Throwable object.
  @parameter Reference to the given stream (Object) used in printing the trace.
  @end
  */
void java_lang_Throwable_printStackTrace0(struct Hjava_lang_Throwable* o, struct Hjava_lang_Object* p)
{
	int i;
	HArrayOfArray* strarray;

	strarray = (HArrayOfArray*)unhand(o)->backtrace;
	if (strarray != 0) {
		for (i = 0; i < obj_length(strarray); i++) {
			Hjava_lang_Object* line = unhand(strarray)->body[i];
			if (line != 0) {
				do_execute_java_method(0, p, "println", "([C)V",
						       0, 0, line);
			}
		}
		do_execute_java_method(0, p, "flush", "()V", 0, 0);
	}
}
