/*
 * java.lang.Thread.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 * 2.2.1998    Vesa Karpijoki   Added some SET- and USED-calls and returns.
 *
 * 18.3.1998   Vesa Karpijoki   Added Dokumatic documentation.
 *                              Changed #include:s.
 */

#include "config.h"
#include "config-std.h"
#include "../../../src/gtypes.h"
#include <native.h>
#include "../../../src/thread.h"
#include "../../../src/support.h"

/**
  @title java_lang_Thread
  @desc Native methods of the Java API class java.lang.Thread.
  @funcidx
  @end
  */

/**
  @function java_lang_Thread_currentThread
  @description Returns the current thread.
  @rvalue Reference to the current Thread object.
  @end
  */
struct Hjava_lang_Thread* java_lang_Thread_currentThread(void)
{
	return (currentThread);
}

/**
  @function java_lang_Thread_yield
  @description Yield processor to another thread of the same priority.
  @end
  */
void java_lang_Thread_yield(void)
{
	yieldThread();
}

/**
  @function java_lang_Thread_sleep
  @description Put current thread to sleep for a time.
  @parameter The sleeping time of the Thread.
  @end
  */
void java_lang_Thread_sleep(jlong time)
{
	sleepThread(time);
}

/**
  @function java_lang_Thread_start
  @description Start this thread running.
  @parameter Reference to the current Thread (this).
  @end
  */
void java_lang_Thread_start(struct Hjava_lang_Thread* this)
{
	startThread(this);
}

/**
  @function java_lang_Thread_isAlive
  @description Is this thread alive?
  @parameter Reference to the current Thread (this).
  @rvalue True if the Thread is alive.
  @end
  */
jbool java_lang_Thread_isAlive(struct Hjava_lang_Thread* this)
{
	return (aliveThread(this));
}

/**
  @function java_lang_Thread_countStackFrames
  @description Returns the number of stack. One for the moment.
  @parameter Reference to the current Thread (this).
  @rvalue The number of stack frames.
  @end
  */
jint java_lang_Thread_countStackFrames(struct Hjava_lang_Thread* this)
{
	return (framesThread(this));
}

/**
  @function java_lang_Thread_setPriority0
  @description Change thread priority.
  @parameter Reference to the current Thread (this).
  @parameter The priority value.
  @end
  */
void java_lang_Thread_setPriority0(struct Hjava_lang_Thread* this, jint prio)
{
	setPriorityThread(this, prio);
}

/**
  @function java_lang_Thread_stop0
  @description Stop a thread in its tracks.
  @parameter Reference to the current Thread (this).
  @parameter Reference to an object.
  @end
  */
void java_lang_Thread_stop0(struct Hjava_lang_Thread* this, struct Hjava_lang_Object* obj)
{
    SET(obj);
    USED(obj);
    stopThread(this);
}

/**
  @function java_lang_Thread_suspend0
  @description Suspend a thread.
  @parameter Reference to the current Thread (this).
  @end
  */
void java_lang_Thread_suspend0(struct Hjava_lang_Thread* this)
{
	suspendThread(this);
}

/**
  @function java_lang_Thread_suspend0
  @description Resume a thread.
  @parameter Reference to the current Thread (this).
  @end
  */
void java_lang_Thread_resume0(struct Hjava_lang_Thread* this)
{
	resumeThread(this);
}

/**
  @function java_lang_Thread_isInterrupted
  @description Unimplemented!
  @parameter Reference to the current Thread (this).
  @parameter A value.
  @end
  */
jbool java_lang_Thread_isInterrupted(struct Hjava_lang_Thread* this, jbool val)
{
    SET(this);
    USED(this);
    SET(val);
    USED(val);

    unimp("java.lang.Thread:isInterrupted unimplemented");

    return false;
}

/**
  @function java_lang_Thread_interrupt0
  @description Unimplemented!
  @parameter Reference to the current Thread (this).
  @end
  */
void java_lang_Thread_interrupt0(struct Hjava_lang_Thread* this)
{
    SET(this);
    USED(this);

    unimp("java.lang.Thread:interrupt0 unimplemented");
}
