/*
 * java.lang.Runtime.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 * 21.1.1998   Vesa Karpijoki   Added #includes <u.h>, <libc.h> and
 *                              "plan9interface.h". Removed some #includes.
 *                              Changed all size_t variables to unsigned int.
 *
 * 2.2.1998    Vesa Karpijoki   Added some SET- and USED-calls. Fixed bugs.
 *
 * 18.3.1998   Vesa Karpijoki   Added Dokumatic documentation.
 *                              Changed #include:s.
 */

#include <u.h>
#include <libc.h>

#define	DBG(s)

#include "config.h"
#include "config-std.h"
#include "config-mem.h"
#include "config-io.h"
#include "../../../src/gtypes.h"
#include <native.h>
#include "files.h"
#include "defs.h"
#include "../java.lang.stubs/Runtime.h"
#include "../../../src/external.h"
#include "../../../src/gc.h"
#include "../../../src/support.h"
#include "plan9interface.h"

#define	LIBRARY_PREFIX	"/lib"

extern char* libraryPath;
extern unsigned int gc_heap_limit;
extern unsigned int gc_heap_total;

/**
  @title java_lang_Runtime
  @desc Native methods of the Java API class java.lang.Runtime.
  @funcidx
  @end
  */

/**
  @function java_lang_Runtime_initializeLinkerInternal
  @description Initialise the linker and return the search path for shared
  libraries.
  @parameter Reference to the Runtime object (this).
  @rvalue Reference to the search path as String.
  @end
  */
struct Hjava_lang_String* java_lang_Runtime_initializeLinkerInternal(struct Hjava_lang_Runtime* this)
{
    SET(this);
    USED(this);
    return (makeJavaString(libraryPath, strlen(libraryPath)));
}

/**
  @function java_lang_Runtime_buildLibNam
  @description Construct a library name.
  @parameter Reference to the Runtime object (this).
  @parameter Part of the library name as String.
  @parameter Part of the library name as String.
  @rvalue Reference to the library name String.
  @end
  */
struct Hjava_lang_String* java_lang_Runtime_buildLibName(struct Hjava_lang_Runtime* this, struct Hjava_lang_String* s1, struct Hjava_lang_String* s2)
{
    char lib[MAXLIBPATH];
    char str[MAXPATHLEN];

    SET(this);
    USED(this);

    /*
     * Note. Although the code below will build a library string, if
     * it doesn't fit into the buffer, it will truncate the path
     * silently.
     */
    javaString2CString(s1, str, sizeof(str));
    strncpy(lib, str, MAXLIBPATH-1);
    strncat(lib, LIBRARY_PREFIX, MAXLIBPATH-1);
    javaString2CString(s2, str, sizeof(str));
    strncat(lib, str, MAXLIBPATH-1);
    strncat(lib, LIBRARYSUFFIX, MAXLIBPATH-1);
    lib[MAXLIBPATH-1] = 0;

    return (makeJavaString(lib, strlen(lib)));
}

/**
  @function java_lang_Runtime_loadFileInternal
  @description Load in a library file.
  @parameter Reference to the Runtime object (this).
  @parameter Reference to the library file name String.
  @rvalue 1 if successful operation. Otherwise 0 is returned.
  @end
  */
jint java_lang_Runtime_loadFileInternal(struct Hjava_lang_Runtime* this, struct Hjava_lang_String* s1)
{
    char lib[MAXPATHLEN];
    int r;

    SET(this);
    USED(this);

    javaString2CString(s1, lib, sizeof(lib));
    r = loadNativeLibrary(lib);

    return (r == 0 ? 1 : 0);
}

/**
  @function java_lang_Runtime_exitInternal
  @description Exit the whole thing.
  @parameter Reference to a Runtime object.
  @parameter Return value given by exit.
  @end
  */
void java_lang_Runtime_exitInternal(struct Hjava_lang_Runtime* r, jint v)
{
    SET(r);
    USED(r);

    exit (v);
}

/**
  @function java_lang_Runtime_execInternal
  @description Execute another program.
  @parameter Reference to the Runtime object (this).
  @parameter Reference to the arguments array.
  @parameter Reference to the environment variables array
  (<b>NOTE:</b> user environment variables are unavailable in Plan9).
  @rvalue Reference to a new Process object (the program).
  @end
  */
struct Hjava_lang_Process* java_lang_Runtime_execInternal(struct Hjava_lang_Runtime* this, HArrayOfObject* argv, HArrayOfObject* arge)
{
    struct Hjava_lang_Process* child;

    SET(this);
    USED(this);

    child = (struct Hjava_lang_Process*)execute_java_constructor(0, "java.lang.UNIXProcess", 0, "([Ljava/lang/String;[Ljava/lang/String;)V", argv, arge);

    return (child);
}

/**
  @function java_lang_Runtime_freeMemory
  @description Exec another program.
  @parameter Reference to the Runtime object (this).
  @rvalue Value (just a guess) that tells how much memory we can claim from
  the heap.
  @end
  */
jlong java_lang_Runtime_freeMemory(struct Hjava_lang_Runtime* this)
{

    SET(this);
    USED(this);

    /* This is a particularly inaccurate guess - it's basically how
     * much more memory we can claim from the heap, and ignores any
     * free memory already within the GC system.
     * Well it'll do for now.
     */
    return (gc_heap_limit - gc_heap_total);
}

/**
  @function java_lang_Runtime_totalMemory
  @description Returns the amount of total memory.
  @parameter Reference to the Runtime object (this).
  @rvalue The amount of total memory.
  @end
  */
jlong java_lang_Runtime_totalMemory(struct Hjava_lang_Runtime* this)
{
    SET(this);
    USED(this);

    return (gc_heap_limit);
}

/**
  @function java_lang_Runtime_gc
  @description Runs the garbage collector.
  @parameter Reference to the Runtime object (this).
  @end
  */
void java_lang_Runtime_gc(struct Hjava_lang_Runtime* this)
{
    SET(this);
    USED(this);

    invokeGC();
}

/**
  @function java_lang_Runtime_runFinalization
  @description Runs any pending finalized methods. This is done by garbage
  collection system - so just run that. Runs the garbage collector.
  @parameter Reference to the Runtime object (this).
  @end
  */
void java_lang_Runtime_runFinalization(struct Hjava_lang_Runtime* this)
{
    SET(this);
    USED(this);

    invokeGC();
}

/**
  @function java_lang_Runtime_runFinalization
  @description Enables/disables tracing of instructions. Unimplemented!
  @parameter Reference to the Runtime object (this).
  @parameter Trace on / off.
  @end
  */
void java_lang_Runtime_traceInstructions(struct Hjava_lang_Runtime* this, jbool on)
{
    SET(this);
    USED(this);
    SET(on);
    USED(on);

    unimp("java.lang.Runtime:traceInstructions unimplemented");
}

/**
  @function java_lang_Runtime_traceMethodCalls
  @description Enables/disables tracing of method calls. Unimplemented!
  @parameter Reference to the Runtime object (this).
  @parameter Trace on / off.
  @end
  */
void java_lang_Runtime_traceMethodCalls(struct Hjava_lang_Runtime* this, jbool on)
{
    SET(this);
    USED(this);
    SET(on);
    USED(on);

    unimp("java.lang.Runtime:traceMethodCalls unimplemented");
}

/**
  @function java_lang_Runtime_runFinalizersOnExit0
  @description Unimplemented!
  @parameter ???
  @end
  */
void java_lang_Runtime_runFinalizersOnExit0(jbool on)
{
    SET(on);
    USED(on);

    unimp("java.lang.Runtime:runFinalizersOnExit0 unimplemented");
}
