/*
 * java.lang.Double.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 * 21.1.1998   Vesa Karpijoki   Added #includes <u.h> and <libc.h>.
 *                              Removed some #includes.
 *
 * 18.3.1998   Vesa Karpijoki   Added Dokumatic documentation.
 *                              Changed #include:s.
 */

#include <u.h>
#include <libc.h>

#include "config.h"
#include "config-std.h"
#include "config-mem.h"
#include "../../../src/gtypes.h"
#include "../../../src/locks.h"
#include "../../../src/classMethod.h"
#include "defs.h"
#include "../java.lang.stubs/Double.h"
#include <native.h>

/**
  @title java_lang_Double
  @desc Native methods of the Java API class java.lang.Double.
  @funcidx
  @end
  */

/**
  @function java_lang_Double_toString
  @description Convert double to a string.
  @parameter Double value to be converted.
  @rvalue Reference to the created string.
  @end
  */
struct Hjava_lang_String* java_lang_Double_toString(double val)
{
	char str[MAXNUMLEN];

	sprintf(str, "%g", val);
	return (makeJavaString(str, strlen(str)));
}

/**
  @function java_lang_Double_valueOf0
  @description Convert string to double object.
  @parameter Reference to the string to be converted.
  @rvalue The double value.
  @end
  */
double java_lang_Double_valueOf0(struct Hjava_lang_String* str)
{
	double value;
	char buf[MAXNUMLEN];
	char* endbuf;

	javaString2CString(str, buf, sizeof(buf));

	value = strtod(buf, &endbuf);
	if (*endbuf != 0) {
		SignalError(0, "java.lang.NumberFormatException", "Bad double format");
	}

	return (value);
}

/**
  @function java_lang_Double_valueOf
  @description Convert string into Double object. (JDK 1.0.2)
  @parameter Reference to the string to be converted.
  @rvalue Reference to the created Double object.
  @end
  */
struct Hjava_lang_Double* java_lang_Double_valueOf(struct Hjava_lang_String* str)
{
	struct Hjava_lang_Double* obj;
	obj = (struct Hjava_lang_Double*)execute_java_constructor(0, "java.lang.Double", 0, "()V");
	unhand(obj)->value = java_lang_Double_valueOf0(str);
	return (obj);
}

/**
  @function java_lang_Double_doubleToLongBits
  @description Convert double to long bits.
  @parameter Double value to be converted.
  @rvalue Converted jlong value.
  @end
  */
jlong java_lang_Double_doubleToLongBits(double val)
{
	return (*(jlong*)&val);
}

/**
  @function java_lang_Double_longBitsToDouble
  @description Convert long bits to double.
  @parameter Jlong value to be converted.
  @rvalue Converted double value.
  @end
  */
double java_lang_Double_longBitsToDouble(jlong val)
{
	return (*(double*)&val);
}
