/*
 * java.lang.Compiler.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 * 21.1.1998   Vesa Karpijoki   Added #includes <u.h> and <libc.h>.
 *                              Removed some #includes.
 *
 * 30.1.1998   Vesa Karpijoki   Added some SET- and USED-calls as well as
 *                              returns.
 */

#include <u.h>
#include <libc.h>

#include "config-std.h"
#include <native.h>
#include "../java.lang.stubs/Compiler.h"


void
java_lang_Compiler_initialize(void)
{
	abort();
}

jbool
java_lang_Compiler_compileClass(struct Hjava_lang_Class* class)
{
  SET(class);
  USED(class);
  abort();
  return 0;
}

jbool
java_lang_Compiler_compileClasses(struct Hjava_lang_String* str)
{
  SET(str);
  USED(str);
  abort();
  return 0;
}

struct Hjava_lang_Object*
java_lang_Compiler_command(struct Hjava_lang_Object* obj)
{
  SET(obj);
  USED(obj);
  abort();
  return NULL;
}

void
java_lang_Compiler_enable(void)
{
	abort();
}

void
java_lang_Compiler_disable(void)
{
	abort();
}
