/*
 * java.lang.reflect.Constructor.c
 *
 * Copyright (c) 1996,97 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.co.uk>
 */

/*** CHANGELOG ***
 *
 *  2.2.1998    Vesa Karpijoki     Added some SET- and USED-calls and includes
 *                                 <u.h>, <libc.h> and "plan9interface.h".
 *
 * 15.2.1998    Arttu Kuukankorpi  Added dokumatic-documentation
 *
 *
 * 16.3.1998    Arttu Kuukankorpi  Changed include-directories
 */

#include <u.h>
#include <libc.h>

#include "config.h"
#include "config-std.h"
#include "config-mem.h"
#include "../../../src/gtypes.h"
#include "../../../src/access.h"
#include "../../../src/constants.h"
#include "../../../src/object.h"
#include "../../../src/classMethod.h"
#include "../../../src/itypes.h"
#include "../../../src/support.h"
#include "../java.lang.reflect.stubs/Constructor.h"
#include <native.h>
#include "defs.h"
#include "plan9interface.h"

/**
  @title java_lang_reflect_Constructor
  @end
  */

/**
  @function java_lang_reflect_Constructor_getModifiers
  @description Get modifiers of a constructor.
  @parameter Reference to the object.
  @rvalue Modifiers.
  @end
  */

jint
java_lang_reflect_Constructor_getModifiers(struct Hjava_lang_reflect_Constructor* this)
{
	Hjava_lang_Class* clazz;
	jint slot;

	clazz = unhand(this)->clazz;
	slot = unhand(this)->slot;

	assert(slot < clazz->nmethods);

	return (clazz->methods[slot].accflags);
}

struct Hjava_lang_Object*
java_lang_reflect_Constructor_newInstance(struct Hjava_lang_reflect_Constructor* this, HArrayOfObject* obj)
{
    SET(this);
    USED(this);
    SET(obj);
    USED(obj);

    unimp("java.lang.reflect.Constructor:newInstance not implemented");
    return (0);
}
