/*
 * java.io.FileOutputStream.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 *  1.2.1998   Arttu Kuukankorpi          rewrote FileOutputStream_open and openAppend
 *                                        included u.h and libc.h
 *
 * 15.2.1998   Arttu Kuukankorpi          Added dokumatic-documentation
 *
 * 16.3.1998   Arttu Kuukankorpi          changed include-files of
 *                                         FileOutputStream.h and
 *                                         FileDescriptor.h
 */

#include <u.h>
#include <libc.h>

#include "config.h"
#include "config-std.h"
#include "config-io.h"
#include "config-mem.h"
#include "files.h"
#include "defs.h"
#include "../java.io.stubs/FileOutputStream.h"
#include "../java.io.stubs/FileDescriptor.h"
#include "kthread.h"

/**
  @title java_io_FileOutputStream
  @desc A file output stream is an output stream for writing data to a File or to a FileDescriptor.
  @funcidx
  @end
  */

/**
  @function java_io_FileOutputStream_open
  @description Open a file for output.
  @parameter Reference to the stream to be opened.
  @parameter Name of the file to be opened.
  @end
  */

void
java_io_FileOutputStream_open(struct Hjava_io_FileOutputStream* fh, struct Hjava_lang_String* nm)
{
	int fd;
	char str[MAXPATHLEN];

	javaString2CString(nm, str, sizeof(str));

	if( access(str, 0) < 0 ){
		if( create(str, ORDWR, 0777) < 0 ){
		    SignalError(NULL, "java.io.IOException", SYS_ERROR);
		}
	}

	fd = open(str, ORDWR);

	unhand(unhand(fh)->fd)->fd = fd;
	if (fd < 0) {
		SignalError(NULL, "java.io.IOException", SYS_ERROR);
	}
}

/**
  @function java_io_FileOutputStream_openAppend
  @description Open a file for appended output.
  @parameter Reference to the stream to be opened.
  @parameter Name of the file to be opened.
  @end
  */

void
java_io_FileOutputStream_openAppend(struct Hjava_io_FileOutputStream* fh, struct Hjava_lang_String* nm)
{
	int fd;
	char str[MAXPATHLEN];

	javaString2CString(nm, str, sizeof(str));

	if( access(str, 0) < 0 ){
	    SignalError(NULL, "java.io.IOException", SYS_ERROR);
	}

	fd = open(str, ORDWR);

	unhand(unhand(fh)->fd)->fd = fd;
	if (fd < 0) {
		SignalError(NULL, "java.io.IOException", SYS_ERROR);
	}
}

/**
  @function java_io_FileOutputStream_close
  @description Close a file.
  @parameter Reference to the stream to be closed.
  @end
  */

void
java_io_FileOutputStream_close(struct Hjava_io_FileOutputStream* fh)
{
	int r;

	if (unhand(unhand(fh)->fd)->fd >= 0) {
		r = close(unhand(unhand(fh)->fd)->fd);
		unhand(unhand(fh)->fd)->fd = -1;
		if (r < 0) {
			SignalError(NULL, "java.io.IOException", SYS_ERROR);
		}
	}
}

/**
  @function java_io_FileOutputStream_writeBytes
  @description Write bytes to file.
  @parameter Reference to the stream to write to.
  @parameter Array of bytes to be written..
  @parameter Starting point.
  @parameter Length.
  @end
  */

void
java_io_FileOutputStream_writeBytes(struct Hjava_io_FileOutputStream* fh, HArrayOfByte* byteArray, jint start, jint len)
{
	int fd;
	int r;

	fd = unhand(unhand(fh)->fd)->fd;
	r = write(fd, &unhand(byteArray)->body[start], len);
	if (r < 0) {
		SignalError(NULL, "java.io.IOException", SYS_ERROR);
	}
}

/**
  @function java_io_FileOutputStream_write
  @description Write a byte to file.
  @parameter Reference to the stream to write to.
  @parameter Byte to be written.
  @end
  */

void
java_io_FileOutputStream_write(struct Hjava_io_FileOutputStream* fh, jint byte)
{
	int fd;
	int r;
	/* unsigned */ char b = byte;

	fd = unhand(unhand(fh)->fd)->fd;
	r = write(fd, &b, 1);
	if (r < 0) {
		SignalError(NULL, "java.io.IOException", SYS_ERROR);
	}
}
