/*
 * nets.h
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 * 12.1.1998   Olli-Pekka Auvinen        Added MAX_CNUM_LEN definition.
 *
 * 13.1.1998   Olli-Pekka Auvinen        Added INADDR_ANY definition.
 *                                       Added AF_INET definition.
 *
 * 15.1.1998   Olli-Pekka Auvinen        Added MAX_PATH_LEN definition.
 *
 * 17.1.1998   Olli-Pekka Auvinen        Removed #include <errno.h>.
 */

#ifndef __nets_h
#define __nets_h

#include "config.h"
#include "config-mem.h"

extern int errno;
extern int h_errno;

#define	MAXHOSTNAME	128

#define	SYS_ERROR	strerror(errno)

#define	SYS_HERROR	"Network error"

#define MAX_CNUM_LEN    8

#define MAX_PATH_LEN    40

#define INADDR_ANY      0x00000000
#define AF_INET         2

#endif

