use strict;
use warnings;
use Test::More tests => 15;
my ($twiml, $test);

BEGIN {
	use_ok 'Twilio';
}
my $t = Twilio::Twiml->new;

is ref($t), 'Twilio::Twiml', 'Twiml instance';

#######################################################################
$test = 'say';
$twiml = $t->Response (
	content	=> [
		$t->Say (
			voice	=> 'woman',
			content	=> 'Hello! Please leave a message after the tone.',
		),
		$t->Say (
			voice	=> 'man',
			content	=> 'Hola! Por favor deje un mensaje despus del tono.',
		),
		$t->Record (
			max_length	=> 20,
		),
	],
);
is $twiml, open_response($test), $test;

#######################################################################
$test =  'play';
$twiml = $t->Response (
	content	=> $t->Play (
		loop	=> 10,
		content	=> 'https://api.twilio.com/cowbell.mp3',
	)
);
is $twiml, open_response($test), $test;

#######################################################################
$test = 'gather';
$twiml = $t->Response (
	content	=> [
		$t->Gather (
			action	=> '/process_gather.php',
			method	=> 'GET',
			content	=> $t->Say (
				content	=> "Please enter your account number,\nfollowed by the pound sign",
			),
		),
		$t->Redirect (
			method	=> 'GET',
			content	=> '/process_gather.php?Digits=TIMEOUT',
		)
	],
);
is $twiml, open_response($test), $test;

#######################################################################
$test = 'record';
$twiml = $t->Response (
	content	=> [
		$t->Say (
			content	=> "Please leave a message at the beep.\nPress the start key when finished.",
		),
		$t->Record (
			action			=> 'http://foo.edu/handleRecording.php',
			method			=> 'GET',
			max_length		=> 20,
			finish_on_key	=> '*',
		),
		$t->Say (
			content	=> 'I did not receive a recording',
		),
	],
);
is $twiml, open_response($test), $test;

#######################################################################
$test = 'sms';
$twiml = $t->Response (
	content	=> [
		$t->Say (
			content	=> 'Our store is located at 123 Easy St.',
		),
		$t->Sms (
			status_callback =>	'/smsHandler.php',
			content			=> 'Store Location: 123 Esasy St.',
		),
	],
);
is $twiml, open_response($test), $test;

#######################################################################
$test = 'dial';
$twiml = $t->Response (
	content	=> [
		$t->Dial (
			action	=> '/handleDialCallStatus.php',
			method	=> 'GET',
			content	=> '415-123-4567',
		),
		$t->Say ('I am unreachable'),
	],
);
is $twiml, open_response($test), $test;

#######################################################################
$test = 'enqueue';
$twiml = $t->Response (
	content	=> $t->Enqueue (
		wait_url	=> 'wait-music.xml',
		content		=> 'support',
	),
);
is $twiml, open_response($test), $test;

#######################################################################
$test = 'leave';
$twiml = $t->Response($t->Leave);
is $twiml, open_response($test), $test;

#######################################################################
$test = 'hangup';
$twiml = $t->Response($t->Hangup);
is $twiml, open_response($test), $test;

#######################################################################
$test = 'redirect';
$twiml = $t->Response (
	content	=> [
		$t->Dial('415-123-4567'),
		$t->Redirect('http://www.foo.com/nextInstructions'),
	],
);
is $twiml, open_response($test), $test;

#######################################################################
$test = 'reject';
$twiml = $t->Response (
	content	=> $t->Reject (
		reason	=> 'busy',
	),
);
is $twiml, open_response($test), $test;

#######################################################################
$test = 'pause';
$twiml = $t->Response (
	content	=> [
		$t->Say('I will pause 10 seconds starting now!'),
		$t->Pause( length => 10 ),
		$t->Say('I just paused 10 seconds'),
	],
);
is $twiml, open_response($test), $test;

#######################################################################
$test = 'message';
$twiml = $t->Response (
	content	=> $t->Message("I'm hungry!"),
);
is $twiml, open_response($test), $test;


sub open_response {
	my $test = shift;
	my $file = "twiml_responses/$test.twiml.xml";
	open my $in, '<', $file or die "Cannot read from $file: $!";
	binmode $in;
	my $twiml = join '', <$in>;
	close $in;
	$twiml;
}
