$| = 1;
use Perlmazing;
use strict;
use warnings;
use Test::More;

BEGIN {
	use_ok 'Twilio';
}

my $sid = 'AC6de7f154fda3b454bb9961df50427cdf';
my $token = '5d63b031798825773ecd430d3e73805e';

my $api = Twilio->new (
	sid		=> $sid,
	token	=> $token,
	trace	=> 0,
);
my $test;

###############################################
$test = 'Accounts instance';
my $accounts = $api->Accounts;
is ref($accounts), 'Twilio::Accounts', $test;

###############################################
$test = 'List accounts';
my @accounts = $api->Accounts;
is @accounts > 0, 1, $test;

###############################################
$test = 'Accounts are Account instances';
my $ok = 1;
for my $i (@accounts) {
	$ok = 0 unless ref($i) eq 'Twilio::Accounts::Account';
}
is $ok, 1, $test;

###############################################
$test = 'Get account instance by sid';
my $account = $api->Accounts->get($sid);
is ref($account), 'Twilio::Accounts::Account', $test;

###############################################
$test = 'Change friendly name on Account';
my $friendly_name = $account->friendly_name;
my $new_name = 'Test name';
$account->friendly_name = $new_name;
$account = $api->Accounts->get($sid);
is $account->friendly_name, $new_name, $test;

###############################################
$test = 'Change the account name back';
$account->friendly_name = $friendly_name;
$account = $api->Accounts->get($sid);
is $account->friendly_name, $friendly_name, $test;

###############################################
$test = 'Check if account subresources are present';
my @resources = $account->resources;
for my $resource (@resources) {
	my $module = $api->get_mapping($resource);
	my $subresource = $account->$resource;
	is ref($subresource), $module, "$resource isa $module";
}

###############################################
$test = 'Creating new subaccount';
$friendly_name = 'Test account';
my $new_account = $api->Accounts->create($friendly_name);
$new_account = $api->Accounts->get($new_account->sid);
is $new_account->friendly_name, $friendly_name, $test;

###############################################
$test = 'Closing new subaccount';
$new_account->close;
$new_account = $api->Accounts->get($new_account->sid);
is $new_account->status, 'closed', $test;

done_testing;
