package Twilio::WebApp::Session;
use Twilio::Objects;
use Perlmazing;
use overload (
	fallback	=> 1,
	'""'		=> \&SCALAR,
);
require Tie::Hash;
our @ISA = qw(Tie::StdHash);

sub new {
	my $class = shift;
	my $driver = shift;
	my $self = {};
	tie %$self, $class;
	bless $self, $class;
	$self->die("This constructor expects a session_driver object as argument") unless is_blessed $driver;
	$self->die("The provided session_driver '".ref($driver)."' cannot 'get_data'") unless $driver->can('get_data');
	$self->die("The provided session_driver '".ref($driver)."' cannot 'store_data'") unless $driver->can('store_data');
	$self->{driver} = $driver;
	$self->{data} = $driver->get_data;
	my $data = $self->{data};
	$self;
}

sub STORE {
	my $self = shift;
	my ($k, $v) = (shift, shift);
	my @call = caller;
	if ($call[0] =~ /^Twilio(::|$)/) {
		$self->{$k} = $v;
	} else {
		$self->{data}->{$k} = $v;
		$self->{driver}->store_data($self->{data});
	}
}

sub FETCH {
	my $self = shift;
	my $k = shift;
	my @call = caller(1);
	if ($call[0] =~ /^Twilio(::|$)/ and $call[3] ne __PACKAGE__.'::AUTOLOAD') {
		return $self->{$k};
	} else {
		return $self->{data}->{$k};
	}
}

sub EXISTS {
	my $self = shift;
	my $k = shift;
	my @call = caller;
	if ($call[0] =~ /^Twilio(::|$)/) {
		return exists $self->{$k};
	} else {
		return exists $self->{data}->{$k};
	}
}

sub DELETE {
	my $self = shift;
	my $k = shift;
	my @call = caller;
	if ($call[0] =~ /^Twilio(::|$)/) {
		return delete $self->{$k};
	} else {
		my $ret = delete $self->{data}->{$k};
		$self->{driver}->store_data($self->{data});
		return $ret;
	}
}

sub FIRSTKEY {
	my $self = shift;
	my @call = caller;
	if ($call[0] =~ /^Twilio(::|$)/) {
		$self->{iteration_keys} = keys %$self;
	} else {
		$self->{iteration_keys} = [keys %{$self->data}];
	}
	shift @{$self->{iteration_keys}};
}

sub NEXTKEY {
	my $self = shift;
	my $k = shift;
	shift @{$self->{iteration_keys}};
}

sub SCALAR {
	my $self = shift;
	return $self->{driver}->sid;
}

sub AUTOLOAD : lvalue {
	my $self = shift;
	our $AUTOLOAD;
	my $name = substr $AUTOLOAD, rindex($AUTOLOAD, ':') + 1;
	$self->{$name};
}

sub die {
	my $self = shift;
	my $msg = shift;
	my @call = caller(2);
	die "$msg at $call[1] line $call[2]\n";
}

1;
