$| = 1;
use Perlmazing;
use strict;
use warnings;
use Test::More;

BEGIN {
	use_ok 'Twilio';
}

my $sid = 'AC6e1650084fe73e11a80270e3c5878a0c';
my $token = '5d63b031798825773ecd430d3e73805e';

my $api = Twilio->new (
	sid		=> $sid,
	token	=> $token,
);
my $test;

###############################################
$test = 'Get Recordings instance';
my $recordings = $api->Recordings;
is ref($recordings), 'Twilio::Recordings', $test;

###############################################
$test = 'Get Recordings list';
my @recordings = $api->Recordings;
is @recordings > 0, 1, $test;

###############################################
$test = 'Items in the list are Twilio::Recordings::Recording instances';
my $ok = 1;
for my $i (@recordings) {
	$ok = 0 unless ref($i) eq 'Twilio::Recordings::Recording';
}
is $ok, 1, $test;

###############################################
$test = 'Get instance by sid';
my $recording = $api->Recordings->get($recordings[0]->sid);
is ref($recording), 'Twilio::Recordings::Recording', $test;

done_testing;
