package Twilio::WebApp::Session::Drivers::file;
use Perlmazing;
use parent 'Twilio';
use DBI;
use File::Temp;
use Scalar::Util qw(refaddr);
use File::Path qw(make_path);

sub new {
	my $class = shift;
	my $self = {};
	my $def = {@_};
	unless (exists $def->{path}) {
		my $temp_dir = File::Temp::tempdir();
		$temp_dir =~ s/\w+$/TwilioSessions/;
		$def->{path} = $temp_dir;
	}
	bless $self, $class;
	$self->{sid} = $def->{sid};
	$self->Objects->{path} = $def->{path};
	$self->ensure_path;
	$self->get_sid;
	$self;
}

sub ensure_path {
	my $self = shift;
	my $path = $self->path;
	make_path $path;
	my $error = $!;
	unless (-d $path) {
		$self->die("Cannot use '$path' as location for session files (directory not found or cannot be created): $!");
	}
}

sub generate_new_sid {
	my $self = shift;
	my $sid = md5 time.refaddr($self);
	while (-f $self->path.'/'.$sid) {
		$sid = md5 time.refaddr($self);
	}
	$self->{sid} = $sid;
}

sub get_sid {
	my $self = shift;
	my ($error, $sid);
	if ($self->sid and -f $self->path.'/'.$self->sid) {
		$self->get_data or $error = 1;
	} else {
		$self->generate_new_sid;
		my $file = $self->path.'/'.$self->sid;
		open my $out, '>', $file or $self->die("Cannot create session file '$file': $!");
		print $out '{}';
		close $out;
	}
	$self->get_data;
}

sub get_data {
	my $self = shift;
	my $file = $self->path.'/'.$self->sid;
	open my $in, '<', $file or $self->die("Cannot read session file '$file': $!");
	my $hashref = eval join '', <$in>;
	close $in;
	return if $@;
	$self->Objects->{session_data} = $hashref;
}

sub store_data {
	my $self = shift;
	my $data = shift;
	my $file = $self->path.'/'.$self->sid;
	open my $out, '>', $file or $self->die("Cannot create session file '$file': $!");
	print $out dumped $data;
	close $out;
	$self->Objects->{session_data} = $data;
}

1;
