package NKTI::general::dbconnect;

use strict;
use warnings;
use JSON;
use DBI;

# Define Version :
# ----------------------------------------------------------------
our $VERSION = '0.06';

# Create Module for Connection MySQL Database :
# ------------------------------------------------------------------------
# Module for MySQL Database Connection.
#
=head1 MODULE connection()

    Parameter Modul :
    ----------------------------------------
    _db_config =>       Parameter yang berisi hash config database.

=cut
sub connect {

    # Define parameter Module :
    # ----------------------------------------------------------------
    my $class = shift;
    my $self = {
        _db_config => shift
    };
    bless $self, $class;

    # Define scalar for parameter module :
    # ----------------------------------------------------------------
    my $get_db_config = $self->{_db_config};

    # Declare scalar for result :
    # ----------------------------------------------------------------
    my $dbh;

    # Declare scalar for Database Config :
    # ----------------------------------------------------------------
    my $db_config = decode_json($get_db_config);
    my $db_user = $db_config->{'db_user'};
    my $db_pass = $db_config->{'db_pass'};
    my $db_name = $db_config->{'db_name'};
    my $db_host = $db_config->{'db_host'};

    # Define database conection :
    # ----------------------------------------------------------------
    my $dsn = 'DBI:mysql:database='.$db_name.';host='.$db_host;
    $dbh = DBI->connect($dsn, $db_user, $db_pass, {RaiseError => 1});

    # Return Result :
    # ----------------------------------------------------------------
    return $dbh;
}
# End of Create Module for Connection MySQL Database.
# ===========================================================================================================

1;
__END__
=head1 AUTHOR
    Achmad Yusri Afandi, (linuxer08@gmail.com)

=head1 COPYRIGHT AND LICENSE
    Copyright (c) 2016, Achmad Yusri Afandi, All Rights reserved.

    Pustaka yang berfungsi untuk melakukan koneksi database MySQL.
=cut