#!perl
use warnings; use strict;
use Test::More tests => 11;
use Test::Exception;
use Test::Builder;
use version;

use lib '.';
use t::Elive::StandardV2;
use Elive::Util;

use Elive::StandardV2::Session;
use Elive::StandardV2::SessionTelephony;

our $t = Test::Builder->new;
our $class = 'Elive::StandardV2::Session' ;

our $connection;

SKIP: {

    my $skippable = 11;

    my %result = t::Elive::StandardV2->test_connection();
    my $auth = $result{auth};

   skip ($result{reason} || 'skipping live tests', $skippable)
	unless $auth && @$auth;

    use Elive::StandardV2::Connection;
    my $connection_class = $result{class};
    $connection = $connection_class->connect(@$auth);
    Elive::StandardV2->connection($connection);

    my $session_start = Elive::Util::next_quarter_hour();
    my $session_end = Elive::Util::next_quarter_hour( $session_start );

    $session_start .= '000';
    $session_end .= '000';

    my %session_data = (
	sessionName => 'test session, generated by t/13-soap-session.t',
	creatorId => $connection->user,
	startTime =>  $session_start,
	endTime => $session_end,
    );

    my ($session) = $class->insert(\%session_data);

    my $session_telephony;
    lives_ok(sub {$session_telephony = $session->telephony}, 'get session telephony - lives');

    my %telephony_data = (
	chairPhone => '(03) 5999 1234',
	chairPIN   => '6342',
	nonChairPhone => '(03) 5999 2234',
	nonChairPIN   => '7722',
	isPhone => '0',
	sessionSIPPhone => '1 6999 2222',
	sessionPIN => '1234',
	);

    lives_ok(sub {$session_telephony->update(\%telephony_data)},'telephony update - lives');

    $session_telephony = undef;

    lives_ok(sub {$session_telephony = Elive::StandardV2::SessionTelephony->retrieve([$session])},
	     'retrieve session telephony (direct) lives');

    foreach (keys %telephony_data) {
	is($telephony_data{$_},  $session_telephony->$_, "session telephony: $_ - as expected");
    }

    lives_ok(sub {$session->delete},'session deletion - lives');

}

Elive::StandardV2->disconnect;

