package Billing::LineItem;

use strict;
use warnings;

use base 'Billing::GEN::LineItem';

use Gantry::Plugins::AutoCRUD qw(
    do_add
    do_edit
    do_delete
    form_name
    write_file
);

use Billing::Model::line_item qw( $LINE_ITEM );
use Billing::Model::invoice   qw( $INVOICE   );
use Gantry::Plugins::Calendar qw(
    do_calendar_month
    calendar_month_js
);



#-----------------------------------------------------------------
# $self->do_main( [ $invoice_id ] )                 # M
#-----------------------------------------------------------------
sub do_main {
    my ( $self, $invoice_id ) = @_;                 # M

    my $only_one_invoice = 0;                       # *
    my $title            = 'Line Items';            # *
    if ( defined $invoice_id ) {                    # *
        $only_one_invoice = 1;                      # *
        my $invoice = $INVOICE->gfind(              # *
            $self, $invoice_id                      # *
        );                                          # *
        $title .= ' for Invoice '                   # *
               .   $invoice->foreign_display();     # *
    }

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Line Items' );

    my $real_location = $self->location() || '';
    if ( $real_location ) {
        $real_location =~ s{/+$}{};
        $real_location .= '/';
    }

    my @header_options = (
        {
            text => 'Add',
            link => $real_location . "add",
            type => 'create',
        },
    );

    my $retval = {
        headings       => [
            'Name',
            'Invoice Number',
            'Due Date',
        ],
    };

    my %param = $self->get_param_hash;

    my $search = {};
    if ( $param{ search } ) {
        my $form = $self->form();

        my @searches;
        foreach my $field ( @{ $form->{ fields } } ) {
            if ( $field->{ searchable } ) {
                push( @searches,
                    ( $field->{ name } => { 'like', "%$param{ search }%"  } )
                );
            }
        }

        $search = {
            -or => \@searches
        } if scalar( @searches ) > 0;
    }

    my @row_options = (
        {
            text => 'Edit',
            type => 'update',
        },
        {
            text => 'Delete',
            type => 'delete',
        },
    );

    my $perm_obj = Gantry::Utils::TablePerms->new(
        {
            site           => $self,
            real_location  => $real_location,
            header_options => \@header_options,
            row_options    => \@row_options,
        }
    );

    $retval->{ header_options } = $perm_obj->real_header_options;

    my $limit_to_user_id = $perm_obj->limit_to_user_id;
    $search->{ user_id } = $limit_to_user_id if ( $limit_to_user_id );

    my $schema = $self->get_schema();
    my @rows   = $LINE_ITEM->get_listing(
        {
            schema   => $schema,
            where    => $search,
        }
    );

    ROW:
    foreach my $row ( @rows ) {
        last ROW if $perm_obj->hide_all_data;

        my $id = $row->id;
        my $invoice = ( $row->invoice )
                ? $row->invoice->foreign_display()
                : '';

        next ROW if ( $only_one_invoice             # *
                        and                         # *
                      $id != $invoice_id );         # *

        push(
            @{ $retval->{rows} }, {
                orm_row => $row,
                data => [
                    $row->name,
                    $invoice,
                    $row->due_date,
                ],
                options => $perm_obj->real_row_options( $row ),
            }
        );
    }

    if ( $param{ json } ) {
        $self->template_disable( 1 );

        my $obj = {
            headings        => $retval->{ headings },
            header_options  => $retval->{ header_options },
            rows            => $retval->{ rows },
        };

        my $json = objToJson( $obj, { skipinvalid => 1 } );
        return( $json );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
# This method inherited from Billing::GEN::LineItem

#-----------------------------------------------------------------
# get_model_name( )
#-----------------------------------------------------------------
sub get_model_name {
    return $LINE_ITEM;
}

#-----------------------------------------------------------------
# get_orm_helper( )
#-----------------------------------------------------------------
sub get_orm_helper {
    return 'Gantry::Plugins::AutoCRUDHelper::DBIxClass';
}

#-----------------------------------------------------------------
# text_descr( )
#-----------------------------------------------------------------
sub text_descr     {
    return 'line item';
}

1;

=head1 NAME

Billing::LineItem - A controller in the Billing application

=head1 SYNOPSIS

This package is meant to be used in a stand alone server/CGI script or the
Perl block of an httpd.conf file.

Stand Alone Server or CGI script:

    use Billing::LineItem;

    my $cgi = Gantry::Engine::CGI->new( {
        config => {
            #...
        },
        locations => {
            '/someurl' => 'Billing::LineItem',
            #...
        },
    } );

httpd.conf:

    <Perl>
        # ...
        use Billing::LineItem;
    </Perl>

    <Location /someurl>
        SetHandler  perl-script
        PerlHandler Billing::LineItem
    </Location>

If all went well, one of these was correctly written during app generation.

=head1 DESCRIPTION

This module was originally generated by Bigtop.  But feel free to edit it.
You might even want to describe the table this module controls here.

=head1 METHODS

=over 4

=item get_model_name

=item text_descr

=item get_orm_helper


=back


=head1 METHODS INHERITED FROM Billing::GEN::LineItem

=over 4

=item do_main

=item form


=back


=head1 DEPENDENCIES

    Billing
    Billing::GEN::LineItem
    Billing::Model::line_item
    Gantry::Plugins::Calendar
    Gantry::Plugins::AutoCRUD

=head1 AUTHOR

Phil Crow

Tim Keefer

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
