#!/usr/bin/perl
use strict;


use CGI::Carp qw( fatalsToBrowser );

use JobAd qw{ -Engine=CGI -TemplateEngine=TT };

use Gantry::Engine::CGI;

my $cgi = Gantry::Engine::CGI->new( {
    config => {
        GantryConfInstance => 'jobad',
        GantryConfFile => '/etc/gantry.conf.2',
    },
    locations => {
        '/' => 'JobAd',
        '/job' => 'JobAd::Job',
        '/skill' => 'JobAd::Skill',
        '/position' => 'JobAd::Position',
        '/user' => 'JobAd::User',
        '/grouping' => 'JobAd::Grouping',
    },
} );

$cgi->dispatch();

if ( $cgi->{config}{debug} ) {
    foreach ( sort { $a cmp $b } keys %ENV ) {
        print "$_ $ENV{$_}<br />\n";
    }
}
