package Padre::Wx::Menu;

use 5.008;
use strict;
use warnings;
use Padre::Util  ();
use Params::Util qw{_INSTANCE};
use Wx           qw(:everything);
use Wx::Event    qw(:everything);

our $VERSION = '0.09';





#####################################################################
# Construction and Setup

sub new {
    my ($class, $win) = @_;

    my $ide      = Padre->ide;
    my $config   = $ide->get_config;
    my $menu     = bless {}, $class;

    $menu->{win} = $win;

    # Create the File menu
    $menu->{file} = Wx::Menu->new;

    # Opening and closing
    EVT_MENU( $win, $menu->{file}->Append( wxID_NEW,  '' ), \&Padre::Wx::MainWindow::on_new  );
    EVT_MENU( $win, $menu->{file}->Append( wxID_OPEN, '' ), \&Padre::Wx::MainWindow::on_open );
    EVT_MENU( $win, $menu->{file}->Append( -1, "Open Selection\tCtrl-Shift-O" ),  \&Padre::Wx::MainWindow::on_open_selection);
    EVT_MENU( $win, $menu->{file}->Append( wxID_CLOSE,  '' ), \&Padre::Wx::MainWindow::on_close     );
    EVT_MENU( $win, $menu->{file}->Append( -1, 'Close All' ), \&Padre::Wx::MainWindow::on_close_all );
    $menu->{file}->AppendSeparator;

    # Saving
    EVT_MENU( $win, $menu->{file}->Append( wxID_SAVE,   '' ), \&Padre::Wx::MainWindow::on_save      );
    EVT_MENU( $win, $menu->{file}->Append( wxID_SAVEAS, '' ), \&Padre::Wx::MainWindow::on_save_as   );
    EVT_MENU( $win, $menu->{file}->Append( -1, 'Save All'  ), \&Padre::Wx::MainWindow::on_save_all  );
    $menu->{file}->AppendSeparator;

    # Conversions and Transforms
    $menu->{file_convert} = Wx::Menu->new;
    $menu->{file}->Append( -1, "Convert EOL to...", $menu->{file_convert} );
    EVT_MENU(
        $win,
        $menu->{file_convert}->Append(-1, "Windows"),
        sub { $_[0]->convert_to("WIN") },
    );
    EVT_MENU(
        $win,
        $menu->{file_convert}->Append(-1, "Unix"),
        sub { $_[0]->convert_to("UNIX") },
    );
    EVT_MENU(
        $win,
        $menu->{file_convert}->Append(-1, "Mac"),
        sub { $_[0]->convert_to("MAC") },
    );
    $menu->{file}->AppendSeparator;

    # Recent things
    $menu->{file_recent_files} = Wx::Menu->new;
    $menu->{file}->Append( -1, "Recent Files", $menu->{file_recent_files} );
    foreach my $f ( $ide->get_recent('files') ) {
       next unless -f $f;
       EVT_MENU(
           $win,
           $menu->{file_recent_files}->Append(-1, $f), 
           sub { $_[0]->setup_editor($f) },
       );
    }
    if ( Padre->ide->get_config->{experimental} ) {
        $menu->{file_recent_projects} = Wx::Menu->new;
        $menu->{file}->Append( -1, "Recent Projects", $menu->{file_recent_projects} );
        # $menu->{file_recent_projects}->Enable(0);
    }
    $menu->{file}->AppendSeparator;

    # Exiting
    EVT_MENU( $win, $menu->{file}->Append( wxID_EXIT,   '' ), \&Padre::Wx::MainWindow::on_exit      );





    # Create the Project menu
    #$menu->{project} = Wx::Menu->new;
    #EVT_MENU( $win, $menu->{project}->Append( -1, "&New"),        \&Padre::Wx::MainWindow::on_new_project );
    #EVT_MENU( $win, $menu->{project}->Append( -1, "&Select"    ), \&Padre::Wx::MainWindow::on_select_project );





    # Create the Edit menu
    $menu->{edit} = Wx::Menu->new;
    EVT_MENU( $win, $menu->{edit}->Append( wxID_UNDO, '' ),  \&Padre::Wx::MainWindow::on_undo ); # Ctrl-Z
    EVT_MENU( $win, $menu->{edit}->Append( wxID_REDO, '' ),  \&Padre::Wx::MainWindow::on_redo ); # Ctrl-Y
    $menu->{edit}->AppendSeparator;

    EVT_MENU( $win, $menu->{edit}->Append( wxID_FIND, '' ),           \&Padre::Wx::FindDialog::on_find             );
    EVT_MENU( $win, $menu->{edit}->Append( -1, "&Find Again\tF3" ),   \&Padre::Wx::FindDialog::on_find_again       );
    EVT_MENU( $win, $menu->{edit}->Append( -1, "Ac&k" ),              \&Padre::Wx::Ack::on_ack  );
    EVT_MENU( $win, $menu->{edit}->Append( -1, "&Goto\tCtrl-G" ),     \&Padre::Wx::MainWindow::on_goto             );
    EVT_MENU( $win, $menu->{edit}->Append( -1, "&AutoComp\tCtrl-P" ), \&Padre::Wx::MainWindow::on_autocompletition );
    EVT_MENU( $win, $menu->{edit}->Append( -1, "Subs\tAlt-S"     ),   sub { $_[0]->{rightbar}->SetFocus()} ); 
    EVT_MENU( $win, $menu->{edit}->Append( -1, "&Brace matching\tCtrl-1" ),   \&Padre::Wx::MainWindow::on_brace_matching       );
    $menu->{edit}->AppendSeparator;

    # User Preferences
    EVT_MENU(
        $win,
        $menu->{edit}->Append( -1, "&Preferences" ),
        \&Padre::Wx::MainWindow::on_setup,
    );





    # Create the View menu
    $menu->{view}       = Wx::Menu->new;
    $menu->{view_lines} = $menu->{view}->AppendCheckItem( -1, "Show Line numbers" );
    $menu->{view_lines}->Check( $config->{show_line_numbers} ? 1 : 0 );
    EVT_MENU(
        $win,
        $menu->{view_lines},
        \&Padre::Wx::MainWindow::on_toggle_line_numbers,
    );
    $menu->{view_eol} = $menu->{view}->AppendCheckItem( -1, "Show Newlines" );
    $menu->{view_eol}->Check( $config->{show_eol} ? 1 : 0 );
    EVT_MENU(
        $win,
        $menu->{view_eol},
        \&Padre::Wx::MainWindow::on_toggle_eol,
    );
    $menu->{view_output} = $menu->{view}->AppendCheckItem( -1, "Show Output" );
    EVT_MENU(
        $win,
        $menu->{view_output},
        \&Padre::Wx::MainWindow::on_toggle_show_output,
    );
    unless ( Padre::Util::WIN32 ) {
        # On Windows disabling the status bar is broken, so don't allow it
        $menu->{view_statusbar} = $menu->{view}->AppendCheckItem( -1, "Show StatusBar" );
        $menu->{view_statusbar}->Check( $config->{show_status_bar} ? 1 : 0 );
        EVT_MENU(
            $win,
            $menu->{view_statusbar},
            \&Padre::Wx::MainWindow::on_toggle_status_bar,
        );
    }
    $menu->{view_indentation_guide} = $menu->{view}->AppendCheckItem( -1, "Show Indentation Guide" );
    $menu->{view_indentation_guide}->Check( $config->{editor}->{indentation_guide} ? 1 : 0 );
    EVT_MENU(
        $win,
        $menu->{view_indentation_guide},
        \&Padre::Wx::MainWindow::on_toggle_indentation_guide,
    );
    $menu->{view_show_calltips} = $menu->{view}->AppendCheckItem( -1, "Show Call Tips" );
    $menu->{view_show_calltips}->Check( $config->{editor}->{show_calltips} ? 1 : 0 );
    EVT_MENU(
        $win,
        $menu->{view_show_calltips},
        sub {$config->{editor}->{show_calltips} = $menu->{view_show_calltips}->IsChecked},
    );
    $menu->{view}->AppendSeparator;
    EVT_MENU( $win, $menu->{view}->Append( -1, "Increase Font Size\tCtrl--" ),   \&Padre::Wx::MainWindow::on_zoom_in   );
    EVT_MENU( $win, $menu->{view}->Append( -1, "Decrease Font Size\tCtrl-+" ),  \&Padre::Wx::MainWindow::on_zoom_out  );
    EVT_MENU( $win, $menu->{view}->Append( -1, "Reset Font Size\tCtrl-/" ),  \&Padre::Wx::MainWindow::on_zoom_reset  );
    $menu->{view}->AppendSeparator;
    EVT_MENU(
        $win,
        $menu->{view}->Append( -1, "Set Bookmark\tCtrl-B" ),
        \&Padre::Wx::Bookmarks::on_set_bookmark,
    );
    EVT_MENU(
        $win,
        $menu->{view}->Append( -1, "Goto Bookmark\tCtrl-Shift-B" ),
        \&Padre::Wx::Bookmarks::on_goto_bookmark,
    );




    # Create the Perl menu
    $menu->{perl} = Wx::Menu->new;

    # Perl-Specific Searches
    $menu->{perl_find_unmatched} = $menu->{perl}->Append( -1, "Find Unmatched Brace" );
    EVT_MENU(
        $win,
        $menu->{perl_find_unmatched},
        sub {
            my $doc = Padre::Document->from_selection;
            unless ( $doc and $doc->isa('Padre::Document::Perl') ) {
                return;
            }
            Class::Autouse->load('Padre::PPI');
            my $ppi   = $doc->ppi_get or return;
            my $where = $ppi->find( \&Padre::PPI::find_unmatched_brace );
            if ( $where ) {
                @$where = sort {
                    Padre::PPI::element_depth($b) <=> Padre::PPI::element_depth($a)
                    or
                    $a->location->[0] <=> $b->location->[0]
                    or
                    $a->location->[1] <=> $b->location->[1]
                } @$where;
                $doc->ppi_select( $where->[0] );
            } else {
                Wx::MessageBox( "All braces appear to be matched", "Check Complete", wxOK, $win );
            }
        },
    );
    $menu->{perl}->AppendSeparator;

    # Script Execution
    $menu->{perl_run_this} = $menu->{perl}->Append( -1, "Run &This\tF5" );
    EVT_MENU(
        $win,
        $menu->{perl_run_this},
        \&Padre::Wx::Execute::on_run_this,
    );
    $menu->{perl_run_any} = $menu->{perl}->Append( -1, "Run Any\tCtrl-F5" );
    EVT_MENU(
        $win,
        $menu->{perl_run_any},
        \&Padre::Wx::Execute::on_run,
    );
    $menu->{perl_stop} = $menu->{perl}->Append( -1, "&Stop" );
    EVT_MENU(
        $win,
        $menu->{perl_stop},
        \&Padre::Wx::Execute::on_stop,
    );
    $menu->{perl_stop}->Enable(0);
    EVT_MENU(
        $win,
        $menu->{perl}->Append( -1, "&Setup" ),
        \&Padre::Wx::Execute::on_setup_run,
    );
    $menu->{perl}->AppendSeparator;

    # Commenting
    EVT_MENU(
        $win,
        $menu->{perl}->Append( -1, "&Comment Selected Lines\tCtrl-M" ),
        \&Padre::Wx::MainWindow::on_comment_out_block,
    );
    EVT_MENU(
        $win,
        $menu->{perl}->Append( -1, "&Uncomment Selected Lines\tCtrl-Shift-M" ),
        \&Padre::Wx::MainWindow::on_uncomment_block,
    );





    # Create the Plugins menu if there are any plugins
    my %plugins = %{ $ide->plugin_manager->plugins };
    if ( %plugins ) {
        $menu->{plugin} = Wx::Menu->new;
    }
    foreach my $name ( sort keys %plugins ) {
        next if not $plugins{$name};
        my @menu    = eval { $plugins{$name}->menu };
        warn "Error when calling menu for plugin '$name' $@" if $@;
        my $menu_items = $menu->add_plugin_menu_items(\@menu);
        $menu->{plugin}->Append( -1, $name, $menu_items );
    }





    # Create the window menu
    $menu->{window} = Wx::Menu->new;
    EVT_MENU(
        $win,
        $menu->{window}->Append( -1, "&Split window" ),
        \&Padre::Wx::MainWindow::on_split_window,
    );
    $menu->{window}->AppendSeparator;
    EVT_MENU(
        $win,
        $menu->{window}->Append(-1, "Next File\tCtrl-TAB"),
        \&Padre::Wx::MainWindow::on_next_pane,
    );
    EVT_MENU(
        $win,
        $menu->{window}->Append(-1, "Previous File\tCtrl-Shift-TAB"),
        \&Padre::Wx::MainWindow::on_prev_pane,
    );
    $menu->{window}->AppendSeparator;





    # Create the help menu
    $menu->{help} = Wx::Menu->new;
    EVT_MENU(
        $win,
        $menu->{help}->Append( wxID_HELP, '' ),
        \&Padre::Wx::Help::on_help,
    );
    EVT_MENU(
        $win,
        $menu->{help}->Append( -1, "Context Help\tCtrl-Shift-H" ),
        \&Padre::Wx::Help::on_context_help,
    );
    $menu->{help}->AppendSeparator;
    EVT_MENU(
        $win,
        $menu->{help}->Append( wxID_ABOUT,   '' ),
        \&Padre::Wx::Help::on_about,
    );





    # Create the Experimental menu
    $menu->{experimental} = Wx::Menu->new;
    EVT_MENU(
        $win,
        $menu->{experimental}->Append( -1, 'Reflow Menu' ),
        sub {
            my $document = Padre::Document->from_selection;
            $_[0]->{menu}->reflow( $document );
            $_[0]->SetMenuBar( $_[0]->{menu}->{wx} );
            return;
        },
    );





    # Create and return the main menu bar
    $menu->{wx} = Wx::MenuBar->new;
    $menu->{wx}->Append( $menu->{file},     "&File"      );
    $menu->{wx}->Append( $menu->{project},  "&Project"   );
    $menu->{wx}->Append( $menu->{edit},     "&Edit"      );
    $menu->{wx}->Append( $menu->{view},     "&View"      );
    $menu->{wx}->Append( $menu->{perl},     "Perl"       );
    $menu->{wx}->Append( $menu->{bookmark}, "&Bookmarks" );
    $menu->{wx}->Append( $menu->{plugin},   "Pl&ugins"   ) if $menu->{plugin};
    $menu->{wx}->Append( $menu->{window},   "&Window"    );
    $menu->{wx}->Append( $menu->{help},     "&Help"      );
    if ( Padre->ide->get_config->{experimental} ) {
        $menu->{wx}->Append( $menu->{experimental}, "E&xperimental" );
    }

    # Do an initial reflow
    # $menu->reflow;

    return $menu;
}


# Recursively add plugin menu items from nested array refs
sub add_plugin_menu_items {
    my ($self, $menu_items) = @_;

    my $menu = Wx::Menu->new;
    foreach my $m ( @{$menu_items} ) {
        if (ref $m->[1] eq 'ARRAY') {
            my $submenu = $self->add_plugin_menu_items($m->[1]);
            $menu->Append(-1, $m->[0], $submenu);
        } else {
            EVT_MENU( $self->win, $menu->Append(-1, $m->[0]), $m->[1] );
        }
    }

    return $menu;
}


sub add_alt_n_menu {
    my ($self, $file, $n) = @_;
    return if $n > 9;

    $self->{alt}->[$n] = $self->{window}->Append(-1, "");
    EVT_MENU( $self->win, $self->{alt}->[$n], sub { $_[0]->on_nth_pane($n) } );
    $self->update_alt_n_menu($file, $n);

    return;
}

sub update_alt_n_menu {
    my ($self, $file, $n) = @_;

    my $v = $n + 1;
    $self->{alt}->[$n]->SetText("$file\tAlt-$v");

    return;
}

sub remove_alt_n_menu {
    my ($self) = @_;

    $self->{window}->Remove(pop @{ $self->{alt} });

    return;
}

sub win {
	$_[0]->{win};
}





#####################################################################
# Reflowing the Menu

sub reflow {
	my $self     = shift;
	my $document = _INSTANCE(shift, 'Padre::Document');

	# Create the new menu bar
	$self->{wx} = Wx::MenuBar->new;
	$self->{wx}->Append( $self->{file},     "&File"      );
	$self->{wx}->Append( $self->{project},  "&Project"   );
	$self->{wx}->Append( $self->{edit},     "&Edit"      );
	$self->{wx}->Append( $self->{view},     "&View"      );
        if ( _INSTANCE($document, 'Padre::Document::Perl') ) {
		$self->{wx}->Append( $self->{perl}, "&Run" );
	}
	$self->{wx}->Append( $self->{bookmark}, "&Bookmarks" );
	if ( $self->{plugins} ) {
		$self->{wx}->Append( $self->{plugin}, "Pl&ugins" );
	}
	$self->{wx}->Append( $self->{window},   "&Window"    );
	$self->{wx}->Append( $self->{help},     "&Help"      );
        if ( Padre->ide->get_config->{experimental} ) {
            $self->{wx}->Append( $self->{experimental}, "E&xperimental" );
        }

	return 1;
}

1;
