use strict;
use XS::Install;
use Alien::CMake;
use Env qw/@PATH/;

unless (-f 'libcares/Makefile') {
    unshift @PATH, Alien::CMake->bin_dir;
    my $flags = qq{-DCARES_STATIC=ON -DCARES_STATIC_PIC=ON -DCARES_SHARED=OFF -DCMAKE_C_FLAGS="-O2"};
    my $result = system(qq{cd libcares && cmake CMakeLists.txt -G "Unix Makefiles" $flags});
    die "FATAL: could not make libcares' Makefile\n" if $result != 0;
}

my %params = (
    NAME      => 'Alien::cares',
    CPLUS     => 11,
    PREREQ_PM => {'Alien::CMake' => "0.11"},
    BIN_SHARE => {INCLUDE => {'libcares' => '/'}},
    CLIB      => {
        DIR    => 'libcares',
        FILE   => 'lib/libcares.a',
        TARGET => '',
    },
);

write_makefile(%params);
